/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociationStore;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/nlj/util/ReceiveSsrcStore;", "", "ssrcAssociationStore", "Lorg/jitsi/nlj/util/SsrcAssociationStore;", "<init>", "(Lorg/jitsi/nlj/util/SsrcAssociationStore;)V", "receiveSsrcs", "", "", "getReceiveSsrcs", "()Ljava/util/Set;", "receiveSsrcsByMediaType", "", "Lorg/jitsi/utils/MediaType;", "primaryMediaSsrcs", "getPrimaryMediaSsrcs", "primaryVideoSsrcs", "getPrimaryVideoSsrcs", "addReceiveSsrc", "", "ssrc", "mediaType", "removeReceiveSsrc", "onSsrcAssociation", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nReceiveSsrcStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReceiveSsrcStore.kt\norg/jitsi/nlj/util/ReceiveSsrcStore\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n382#2,7:93\n1869#3,2:100\n*S KotlinDebug\n*F\n+ 1 ReceiveSsrcStore.kt\norg/jitsi/nlj/util/ReceiveSsrcStore\n*L\n59#1:93,7\n71#1:100,2\n*E\n"})
public final class ReceiveSsrcStore {
    @NotNull
    private final SsrcAssociationStore ssrcAssociationStore;
    @NotNull
    private final Set<Long> receiveSsrcs;
    @NotNull
    private final Map<MediaType, Set<Long>> receiveSsrcsByMediaType;
    @NotNull
    private final Set<Long> primaryMediaSsrcs;
    @NotNull
    private final Set<Long> primaryVideoSsrcs;

    public ReceiveSsrcStore(@NotNull SsrcAssociationStore ssrcAssociationStore) {
        Intrinsics.checkNotNullParameter((Object)ssrcAssociationStore, (String)"ssrcAssociationStore");
        this.ssrcAssociationStore = ssrcAssociationStore;
        this.receiveSsrcs = new CopyOnWriteArraySet();
        this.receiveSsrcsByMediaType = new ConcurrentHashMap();
        this.primaryMediaSsrcs = new CopyOnWriteArraySet();
        this.primaryVideoSsrcs = new CopyOnWriteArraySet();
        this.ssrcAssociationStore.onAssociation((Function1<? super SsrcAssociation, Unit>)((Function1)new Function1<SsrcAssociation, Unit>((Object)this){

            public final void invoke(SsrcAssociation p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ReceiveSsrcStore)this.receiver).onSsrcAssociation(p0);
            }
        }));
    }

    @NotNull
    public final Set<Long> getReceiveSsrcs() {
        return this.receiveSsrcs;
    }

    @NotNull
    public final Set<Long> getPrimaryMediaSsrcs() {
        return this.primaryMediaSsrcs;
    }

    @NotNull
    public final Set<Long> getPrimaryVideoSsrcs() {
        return this.primaryVideoSsrcs;
    }

    /*
     * WARNING - void declaration
     */
    public final void addReceiveSsrc(long ssrc, @NotNull MediaType mediaType) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        Map<MediaType, Set<Long>> map = this.receiveSsrcsByMediaType;
        MediaType key$iv = mediaType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(ssrc);
        this.receiveSsrcs.add(ssrc);
        if (this.ssrcAssociationStore.isPrimarySsrc(ssrc)) {
            this.primaryMediaSsrcs.add(ssrc);
            if (mediaType == MediaType.VIDEO) {
                this.primaryVideoSsrcs.add(ssrc);
            }
        }
    }

    public final void removeReceiveSsrc(long ssrc) {
        this.receiveSsrcs.remove(ssrc);
        Iterable $this$forEach$iv = this.receiveSsrcsByMediaType.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            it.remove(ssrc);
        }
        this.primaryMediaSsrcs.remove(ssrc);
        this.primaryVideoSsrcs.remove(ssrc);
    }

    private final void onSsrcAssociation(SsrcAssociation ssrcAssociation) {
        this.primaryVideoSsrcs.remove(ssrcAssociation.getSecondarySsrc());
        this.primaryMediaSsrcs.remove(ssrcAssociation.getSecondarySsrc());
    }

    @NotNull
    public final OrderedJsonObject debugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$debugState_u24lambda_u240).put("receive_ssrcs", MapsKt.toMap(this.receiveSsrcsByMediaType));
        ((Map)$this$debugState_u24lambda_u240).put("primary_media_ssrcs", CollectionsKt.toSet((Iterable)this.primaryMediaSsrcs));
        ((Map)$this$debugState_u24lambda_u240).put("primary_video_ssrcs", CollectionsKt.toSet((Iterable)this.primaryVideoSsrcs));
        return orderedJsonObject;
    }
}

