/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\tJ\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/util/TreeCache;", "T", "", "minSize", "", "<init>", "(I)V", "map", "Ljava/util/TreeMap;", "", "highestIndex", "insert", "", "index", "value", "(JLjava/lang/Object;)V", "getEntryBefore", "", "get", "(J)Ljava/lang/Object;", "updateState", "size", "getSize", "()I", "jitsi-media-transform"})
public class TreeCache<T> {
    private final int minSize;
    @NotNull
    private final TreeMap<Long, T> map;
    private long highestIndex;

    public TreeCache(int minSize) {
        this.minSize = minSize;
        this.map = new TreeMap();
        this.highestIndex = -1L;
    }

    public final void insert(long index, T value) {
        ((Map)this.map).put(index, value);
        this.updateState(index);
    }

    @Nullable
    public final Map.Entry<Long, T> getEntryBefore(long index) {
        this.updateState(index);
        return this.map.floorEntry(index);
    }

    @Nullable
    public final T get(long index) {
        return this.map.get(index);
    }

    private final void updateState(long index) {
        SortedMap<Long, T> headMap;
        if (this.highestIndex < index) {
            this.highestIndex = index;
        }
        if ((headMap = this.map.headMap(this.highestIndex - (long)this.minSize)).size() > 1) {
            Set<Long> set = headMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Long last = (Long)CollectionsKt.last((Iterable)set);
            headMap.keySet().removeIf(arg_0 -> TreeCache.updateState$lambda$1(arg_0 -> TreeCache.updateState$lambda$0(last, arg_0), arg_0));
        }
    }

    public final int getSize() {
        return this.map.size();
    }

    private static final boolean updateState$lambda$0(Long $last, Long it) {
        return it < $last;
    }

    private static final boolean updateState$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

