/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionHelpers;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionParser;
import org.jitsi.rtp.rtp.header_extensions.OneByteHeaderExtensionParser;
import org.jitsi.rtp.rtp.header_extensions.TwoByteHeaderExtensionParser;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.FieldParsersKt;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u000e\b\u0017\u0018\u0000 m2\u00020\u0001:\u0006hijklmB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020\u0005H\u0002J\u0010\u0010W\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020\u0005J\u001e\u0010X\u001a\u00020Y2\u0014\u0010Z\u001a\u0010\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\u0010\u0018\u00010[H\u0002J\u000e\u0010\\\u001a\u00020Y2\u0006\u0010]\u001a\u00020\u0005J\u0014\u0010^\u001a\u00020Y2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00050`J\u0016\u0010a\u001a\u00020R2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010b\u001a\u00020\u0005J\u001a\u0010c\u001a\u00020B2\u0010\u0010N\u001a\f\u0012\b\u0012\u00060PR\u00020\u000002H\u0002J\u0006\u0010d\u001a\u00020YJ\b\u0010e\u001a\u00020\u0000H\u0016J\u0010\u0010f\u001a\u00020Y2\u0006\u0010e\u001a\u00020\u0000H\u0004J\b\u0010g\u001a\u00020KH\u0016R$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00108B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR$\u0010\u001b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u000fR\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010*\"\u0004\b0\u0010,R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020'028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR$\u00107\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\r\"\u0004\b9\u0010\u000fR\u0011\u0010:\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\rR\u0011\u0010<\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\rR$\u0010>\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\r\"\u0004\b@\u0010\u000fR\u0016\u0010A\u001a\u0004\u0018\u00010B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0012\u0010E\u001a\u00060FR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010G\u001a\u00060FR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0014\u0010J\u001a\u00020K8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u001a\u0010N\u001a\u000e\u0012\b\u0012\u00060PR\u00020\u0000\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010T\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010\u0013\"\u0004\bV\u0010\u0015\u00a8\u0006n"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket;", "Lorg/jitsi/rtp/Packet;", "buffer", "", "offset", "", "length", "<init>", "([BII)V", "([B)V", "value", "version", "getVersion", "()I", "setVersion", "(I)V", "", "hasPadding", "getHasPadding", "()Z", "setHasPadding", "(Z)V", "hasEncodedExtensions", "getHasEncodedExtensions", "setHasEncodedExtensions", "csrcCount", "getCsrcCount", "isMarked", "setMarked", "_payloadType", "newValue", "payloadType", "getPayloadType", "setPayloadType", "_sequenceNumber", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "_timestamp", "", "timestamp", "getTimestamp", "()J", "setTimestamp", "(J)V", "_ssrc", "ssrc", "getSsrc", "setSsrc", "csrcs", "", "getCsrcs", "()Ljava/util/List;", "extensionsProfileType", "getExtensionsProfileType", "headerLength", "getHeaderLength", "setHeaderLength", "payloadLength", "getPayloadLength", "payloadOffset", "getPayloadOffset", "paddingSize", "getPaddingSize", "setPaddingSize", "headerExtensionParser", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "getHeaderExtensionParser", "()Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "_encodedHeaderExtensions", "Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "encodedHeaderExtensions", "getEncodedHeaderExtensions", "()Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "pendingHeaderExtensions", "", "Lorg/jitsi/rtp/rtp/RtpPacket$PendingHeaderExtension;", "getEncodedHeaderExtension", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "extensionId", "hasExtensions", "getHasExtensions", "setHasExtensions", "getHeaderExtension", "createPendingHeaderExtensions", "", "removeIf", "Lkotlin/Function1;", "removeHeaderExtension", "id", "removeHeaderExtensionsExcept", "retain", "", "addHeaderExtension", "extDataLength", "pickParserForEncodedHeaders", "encodeHeaderExtensions", "clone", "postClone", "toString", "HeaderExtension", "StandaloneHeaderExtension", "EncodedHeaderExtension", "PendingHeaderExtension", "EncodedHeaderExtensions", "Companion", "rtp"})
@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We intentionally pass a reference to our buffer when using observableWhenChanged.")
@SourceDebugExtension(value={"SMAP\nRtpPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpPacket.kt\norg/jitsi/rtp/rtp/RtpPacket\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,625:1\n32#2,2:626\n32#2,2:628\n32#2,2:630\n1869#3,2:632\n1869#3,2:635\n1#4:634\n*S KotlinDebug\n*F\n+ 1 RtpPacket.kt\norg/jitsi/rtp/rtp/RtpPacket\n*L\n196#1:626,2\n225#1:628,2\n241#1:630,2\n298#1:632,2\n377#1:635,2\n*E\n"})
public class RtpPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int _payloadType;
    private int _sequenceNumber;
    private long _timestamp;
    private long _ssrc;
    private int headerLength;
    @NotNull
    private final EncodedHeaderExtensions _encodedHeaderExtensions;
    @Nullable
    private List<PendingHeaderExtension> pendingHeaderExtensions;
    public static final int HEADER_EXT_HEADER_SIZE = 1;
    public static final int BYTES_TO_LEAVE_AT_START_OF_PACKET = 10;

    public RtpPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer, offset, length);
        this._payloadType = RtpHeader.Companion.getPayloadType(buffer, offset);
        this._sequenceNumber = RtpHeader.Companion.getSequenceNumber(buffer, offset);
        this._timestamp = RtpHeader.Companion.getTimestamp(buffer, offset);
        this._ssrc = RtpHeader.Companion.getSsrc(buffer, offset);
        this.headerLength = RtpHeader.Companion.getTotalLength(buffer, offset);
        if (this.headerLength > length) {
            throw new IllegalArgumentException("RTP packet header length " + this.headerLength + " > length " + length);
        }
        this._encodedHeaderExtensions = new EncodedHeaderExtensions();
    }

    public RtpPacket(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(buffer, 0, buffer.length);
    }

    public final int getVersion() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.getVersion(this.buffer, this.offset);
    }

    public final void setVersion(int value) {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        RtpHeader.Companion.setVersion(this.buffer, this.offset, value);
    }

    public final boolean getHasPadding() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.hasPadding(this.buffer, this.offset);
    }

    public final void setHasPadding(boolean value) {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        RtpHeader.Companion.setPadding(this.buffer, this.offset, value);
    }

    private final boolean getHasEncodedExtensions() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.hasExtensions(this.buffer, this.offset);
    }

    private final void setHasEncodedExtensions(boolean value) {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        RtpHeader.Companion.setHasExtensions(this.buffer, this.offset, value);
    }

    public final int getCsrcCount() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.getCsrcCount(this.buffer, this.offset);
    }

    public final boolean isMarked() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.getMarker(this.buffer, this.offset);
    }

    public final void setMarked(boolean value) {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        RtpHeader.Companion.setMarker(this.buffer, this.offset, value);
    }

    public final int getPayloadType() {
        return this._payloadType;
    }

    public final void setPayloadType(int newValue) {
        if (newValue != this._payloadType) {
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
            RtpHeader.Companion.setPayloadType(this.buffer, this.offset, newValue);
            this._payloadType = newValue;
        }
    }

    public final int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public final void setSequenceNumber(int newValue) {
        if (newValue != this._sequenceNumber) {
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
            RtpHeader.Companion.setSequenceNumber(this.buffer, this.offset, newValue);
            this._sequenceNumber = newValue;
        }
    }

    public final long getTimestamp() {
        return this._timestamp;
    }

    public final void setTimestamp(long newValue) {
        if (newValue != this._timestamp) {
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
            RtpHeader.Companion.setTimestamp(this.buffer, this.offset, newValue);
            this._timestamp = newValue;
        }
    }

    public final long getSsrc() {
        return this._ssrc;
    }

    public final void setSsrc(long newValue) {
        if (newValue != this._ssrc) {
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
            RtpHeader.Companion.setSsrc(this.buffer, this.offset, newValue);
            this._ssrc = newValue;
        }
    }

    @NotNull
    public final List<Long> getCsrcs() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.getCsrcs(this.buffer, this.offset);
    }

    public final int getExtensionsProfileType() {
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return RtpHeader.Companion.getExtensionsProfileType(this.buffer, this.offset);
    }

    public final int getHeaderLength() {
        return this.headerLength;
    }

    protected final void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public final int getPayloadLength() {
        return this.length - this.headerLength;
    }

    public final int getPayloadOffset() {
        return this.offset + this.headerLength;
    }

    public final int getPaddingSize() {
        if (!this.getHasPadding()) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return FieldParsersKt.getByteAsInt(this.buffer, this.offset + this.length - 1);
    }

    public final void setPaddingSize(int value) {
        if (value > 0) {
            this.setHasPadding(true);
            this.buffer[this.offset + this.length - 1] = (byte)value;
        } else {
            this.setHasPadding(false);
        }
    }

    private final HeaderExtensionParser getHeaderExtensionParser() {
        return HeaderExtensionHelpers.Companion.getHeaderExtensionParser(this.getExtensionsProfileType());
    }

    private final EncodedHeaderExtensions getEncodedHeaderExtensions() {
        this._encodedHeaderExtensions.reset$rtp();
        return this._encodedHeaderExtensions;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int n = this.getPayloadLength();
        Intrinsics.checkNotNullExpressionValue((Object)this.buffer, (String)"buffer");
        return "type=RtpPacket len=" + n + " hashCode=" + ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, this.getPayloadOffset(), this.getPayloadOffset() + this.getPayloadLength());
    }

    private final HeaderExtension getEncodedHeaderExtension(int extensionId) {
        if (!this.getHasEncodedExtensions()) {
            return null;
        }
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    public final boolean getHasExtensions() {
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        return list != null ? !((Collection)list).isEmpty() : this.getHasEncodedExtensions();
    }

    public final void setHasExtensions(boolean value) {
        List<PendingHeaderExtension> p = this.pendingHeaderExtensions;
        if (p != null) {
            if (value && p.isEmpty()) {
                throw new IllegalStateException("Cannot set hasExtensions to true with empty pending extensions");
            }
            if (!value) {
                p.clear();
            }
        } else {
            this.setHasEncodedExtensions(value);
        }
    }

    @Nullable
    public final HeaderExtension getHeaderExtension(int extensionId) {
        List<PendingHeaderExtension> activeHeaderExtensions;
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null || (list = list.iterator()) == null) {
            list = this.getEncodedHeaderExtensions();
        }
        List<PendingHeaderExtension> $this$forEach$iv = activeHeaderExtensions = list;
        boolean $i$f$forEach = false;
        List<PendingHeaderExtension> list2 = $this$forEach$iv;
        while (list2.hasNext()) {
            Object element$iv = list2.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPendingHeaderExtensions(Function1<? super HeaderExtension, Boolean> removeIf) {
        ArrayList arrayList;
        if (this.pendingHeaderExtensions != null) {
            return;
        }
        if (!(!this.getHasEncodedExtensions() || this.getHeaderExtensionParser() != null)) {
            boolean $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = false;
            String $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = "Cannot modify header extensions for header extension type " + Integer.toHexString(this.getExtensionsProfileType());
            throw new IllegalStateException($i$a$-check-RtpPacket$createPendingHeaderExtensions$22.toString());
        }
        ArrayList $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = arrayList = new ArrayList();
        RtpPacket rtpPacket = this;
        boolean bl = false;
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            void l;
            Object element$iv = iterator.next();
            HeaderExtension it = (HeaderExtension)element$iv;
            boolean bl2 = false;
            if (removeIf != null && ((Boolean)removeIf.invoke((Object)it)).booleanValue()) continue;
            l.add(new PendingHeaderExtension(this, it));
        }
        rtpPacket.pendingHeaderExtensions = arrayList;
    }

    public final void removeHeaderExtension(int id) {
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtension$lambda$1(arg_0 -> RtpPacket.removeHeaderExtension$lambda$0(id, arg_0), arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)((Function1)arg_0 -> RtpPacket.removeHeaderExtension$lambda$2(id, arg_0)));
        }
    }

    public final void removeHeaderExtensionsExcept(@NotNull Set<Integer> retain) {
        Intrinsics.checkNotNullParameter(retain, (String)"retain");
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtensionsExcept$lambda$1(arg_0 -> RtpPacket.removeHeaderExtensionsExcept$lambda$0(retain, arg_0), arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)((Function1)arg_0 -> RtpPacket.removeHeaderExtensionsExcept$lambda$2(retain, arg_0)));
        }
    }

    @NotNull
    public final HeaderExtension addHeaderExtension(int id, int extDataLength) {
        if (!(1 <= id ? id < 256 : false)) {
            boolean $i$a$-require-RtpPacket$addHeaderExtension$32 = false;
            String $i$a$-require-RtpPacket$addHeaderExtension$32 = "Invalid header extension ID " + id;
            throw new IllegalArgumentException($i$a$-require-RtpPacket$addHeaderExtension$32.toString());
        }
        if (!(0 <= extDataLength ? extDataLength < 256 : false)) {
            boolean bl = false;
            String string = "Invalid header extension length " + extDataLength;
            throw new IllegalArgumentException(string.toString());
        }
        PendingHeaderExtension newHeader = new PendingHeaderExtension(this, id, extDataLength);
        if (this.pendingHeaderExtensions == null) {
            this.createPendingHeaderExtensions(null);
        }
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        Intrinsics.checkNotNull(list);
        list.add(newHeader);
        return newHeader;
    }

    private final HeaderExtensionParser pickParserForEncodedHeaders(List<PendingHeaderExtension> pendingHeaderExtensions) {
        Iterable $this$forEach$iv = pendingHeaderExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PendingHeaderExtension it = (PendingHeaderExtension)element$iv;
            boolean bl = false;
            if (it.getId() < 15 && it.getDataLengthBytes() != 0 && it.getDataLengthBytes() <= 16) continue;
            return TwoByteHeaderExtensionParser.INSTANCE;
        }
        return OneByteHeaderExtensionParser.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeHeaderExtensions() {
        byte[] byArray;
        int n;
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null) {
            return;
        }
        List<PendingHeaderExtension> pendingHeaderExtensions = list;
        HeaderExtensionParser newParser = this.pickParserForEncodedHeaders(pendingHeaderExtensions);
        int currHeaderLength = this.headerLength;
        int currPayloadLength = this.getPayloadLength();
        int baseHeaderLength = 12 + this.getCsrcCount() * 4;
        if (pendingHeaderExtensions.isEmpty()) {
            n = 0;
        } else {
            int n2;
            Iterable iterable = pendingHeaderExtensions;
            int n3 = 4;
            int n4 = 0;
            for (Object object : iterable) {
                void h;
                PendingHeaderExtension pendingHeaderExtension = (PendingHeaderExtension)object;
                n2 = n4;
                boolean bl = false;
                int n5 = newParser.getExtHeaderSizeBytes() + h.getDataLengthBytes();
                n4 = n2 + n5;
            }
            n2 = n4;
            int rawHeaderLength = n3 + n2;
            n = rawHeaderLength + RtpUtils.Companion.getNumPaddingBytes(rawHeaderLength);
        }
        int newExtHeaderLength = n;
        int newHeaderLength = baseHeaderLength + newExtHeaderLength;
        int newPacketLength = newHeaderLength + currPayloadLength;
        int newPayloadOffset = 0;
        if (this.buffer.length >= newPacketLength + 20) {
            if (this.offset + currHeaderLength >= newPacketLength - currPayloadLength) {
                newPayloadOffset = this.getPayloadOffset();
            } else {
                newPayloadOffset = this.buffer.length - currPayloadLength - 20;
                System.arraycopy(this.buffer, this.getPayloadOffset(), this.buffer, newPayloadOffset, currPayloadLength);
            }
            byArray = this.buffer;
        } else {
            Object object;
            object = BufferPool.Companion.getGetArray().invoke((Object)(newPacketLength + 20));
            byte[] $this$encodeHeaderExtensions_u24lambda_u241 = (byte[])object;
            boolean bl = false;
            newPayloadOffset = $this$encodeHeaderExtensions_u24lambda_u241.length - currPayloadLength - 20;
            System.arraycopy(this.buffer, this.getPayloadOffset(), $this$encodeHeaderExtensions_u24lambda_u241, newPayloadOffset, currPayloadLength);
            byArray = (byte[])object;
        }
        byte[] newBuffer = byArray;
        int newOffset = newPayloadOffset - newHeaderLength;
        if (this.buffer != newBuffer || this.offset != newOffset) {
            System.arraycopy(this.buffer, this.offset, newBuffer, newOffset, baseHeaderLength);
        }
        if (!((Collection)pendingHeaderExtensions).isEmpty()) {
            int off = 0;
            off = newOffset + baseHeaderLength;
            Intrinsics.checkNotNull((Object)newBuffer);
            ByteArrayExtensionsKt.putShort(newBuffer, off, (short)newParser.getHeaderExtensionLabel());
            ByteArrayExtensionsKt.putShort(newBuffer, off + 2, (short)((newExtHeaderLength - 4) / 4));
            off += 4;
            Iterable $this$forEach$iv = pendingHeaderExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PendingHeaderExtension h = (PendingHeaderExtension)element$iv;
                boolean bl = false;
                int len = h.writeToBuffer(newBuffer, off, newParser);
                off += len;
            }
            while (off < newOffset + newHeaderLength) {
                newBuffer[off] = 0;
                int n6 = off;
                off = n6 + 1;
            }
        }
        byte[] oldBuffer = this.buffer;
        this.buffer = newBuffer;
        if (oldBuffer != newBuffer) {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnArray();
            Intrinsics.checkNotNull((Object)oldBuffer);
            function1.invoke((Object)oldBuffer);
        }
        this.offset = newOffset;
        this.length = newPacketLength;
        this.headerLength = newHeaderLength;
        this.setHasEncodedExtensions(!((Collection)pendingHeaderExtensions).isEmpty());
        this.pendingHeaderExtensions = null;
    }

    @Override
    @NotNull
    public RtpPacket clone() {
        RtpPacket rtpPacket;
        RtpPacket it = rtpPacket = new RtpPacket(this.cloneBuffer(10), 10, this.length);
        boolean bl = false;
        this.postClone(it);
        return rtpPacket;
    }

    protected final void postClone(@NotNull RtpPacket clone) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)clone, (String)"clone");
            List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
            if (list == null) break block0;
            List<PendingHeaderExtension> it = list;
            boolean bl = false;
            clone.pendingHeaderExtensions = new ArrayList(it);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(this.getClass().getSimpleName() + ": ");
        $this$toString_u24lambda_u240.append("PT=" + this.getPayloadType());
        $this$toString_u24lambda_u240.append(", Ssrc=" + this.getSsrc());
        $this$toString_u24lambda_u240.append(", SeqNum=" + this.getSequenceNumber());
        $this$toString_u24lambda_u240.append(", M=" + this.isMarked());
        $this$toString_u24lambda_u240.append(", X=" + this.getHasEncodedExtensions());
        $this$toString_u24lambda_u240.append(", Ts=" + this.getTimestamp());
        return stringBuilder.toString();
    }

    private static final boolean removeHeaderExtension$lambda$0(int $id, PendingHeaderExtension h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return h.getId() == $id;
    }

    private static final boolean removeHeaderExtension$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeHeaderExtension$lambda$2(int $id, HeaderExtension h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return h.getId() == $id;
    }

    private static final boolean removeHeaderExtensionsExcept$lambda$0(Set $retain, PendingHeaderExtension h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return !$retain.contains(h.getId());
    }

    private static final boolean removeHeaderExtensionsExcept$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeHeaderExtensionsExcept$lambda$2(Set $retain, HeaderExtension h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return !$retain.contains(h.getId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$Companion;", "", "<init>", "()V", "HEADER_EXT_HEADER_SIZE", "", "BYTES_TO_LEAVE_AT_START_OF_PACKET", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "<init>", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "currExtOffset", "", "currExtLength", "dataLengthBytes", "getDataLengthBytes", "()I", "buffer", "", "getBuffer", "()[B", "newId", "id", "getId", "setId", "(I)V", "dataOffset", "getDataOffset", "totalLengthBytes", "getTotalLengthBytes", "setOffsetLength", "", "nextHeaderExtOffset", "nextHeaderExtLength", "rtp"})
    @SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
    public final class EncodedHeaderExtension
    implements HeaderExtension {
        private int currExtOffset;
        private int currExtLength;

        @Override
        public int getDataLengthBytes() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            return headerExtensionParser.getDataLengthBytes(this.getBuffer(), this.currExtOffset);
        }

        @Override
        @NotNull
        public byte[] getBuffer() {
            Intrinsics.checkNotNullExpressionValue((Object)RtpPacket.this.buffer, (String)"buffer");
            return RtpPacket.this.buffer;
        }

        @Override
        public int getId() {
            if (this.currExtLength <= 0) {
                return -1;
            }
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            return headerExtensionParser.getId(this.getBuffer(), this.currExtOffset);
        }

        @Override
        public void setId(int newId) {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            if (this.currExtLength < headerExtensionParser.getMinimumExtSizeBytes()) {
                throw new IllegalStateException("Can't set ID: Header extension too short");
            }
            HeaderExtensionParser headerExtensionParser2 = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser2);
            headerExtensionParser2.writeIdAndLength(newId, this.getDataLengthBytes(), this.getBuffer(), this.currExtOffset);
        }

        @Override
        public int getDataOffset() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            return headerExtensionParser.getExtHeaderSizeBytes() + this.currExtOffset;
        }

        @Override
        public int getTotalLengthBytes() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            return headerExtensionParser.getExtHeaderSizeBytes() + this.getDataLengthBytes();
        }

        public final void setOffsetLength(int nextHeaderExtOffset, int nextHeaderExtLength) {
            this.currExtOffset = nextHeaderExtOffset;
            this.currExtLength = nextHeaderExtLength;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "<init>", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "nextOffset", "", "remainingLength", "currHeaderExtension", "Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket;", "hasNext", "", "next", "getNextExtLength", "reset", "", "reset$rtp", "rtp"})
    @SourceDebugExtension(value={"SMAP\nRtpPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpPacket.kt\norg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,625:1\n1#2:626\n*E\n"})
    public final class EncodedHeaderExtensions
    implements Iterator<HeaderExtension>,
    KMappedMarker {
        private int nextOffset;
        private int remainingLength;
        @NotNull
        private final EncodedHeaderExtension currHeaderExtension;

        public EncodedHeaderExtensions() {
            this.currHeaderExtension = new EncodedHeaderExtension();
        }

        @Override
        public boolean hasNext() {
            if (RtpPacket.this.getHeaderExtensionParser() == null) {
                return false;
            }
            while (this.remainingLength > 0 && RtpUtilsKt.isPadding(RtpPacket.this.buffer[this.nextOffset])) {
                int n = this.nextOffset;
                this.nextOffset = n + 1;
                n = this.remainingLength;
                this.remainingLength = n + -1;
            }
            if (this.remainingLength <= 0 || this.nextOffset < 0) {
                return false;
            }
            return this.getNextExtLength() > 0;
        }

        @Override
        @NotNull
        public HeaderExtension next() {
            int nextExtLen = this.getNextExtLength();
            if (nextExtLen <= 0) {
                throw new Exception("Invalid extension length.  Did hasNext() return true?");
            }
            this.currHeaderExtension.setOffsetLength(this.nextOffset, nextExtLen);
            this.nextOffset += nextExtLen;
            this.remainingLength -= nextExtLen;
            return this.currHeaderExtension;
        }

        private final int getNextExtLength() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            if (headerExtensionParser != null) {
                HeaderExtensionParser headerExtensionParser2 = headerExtensionParser;
                RtpPacket rtpPacket = RtpPacket.this;
                HeaderExtensionParser parser = headerExtensionParser2;
                boolean bl = false;
                if (this.remainingLength < parser.getMinimumExtSizeBytes()) {
                    return -1;
                }
                Intrinsics.checkNotNullExpressionValue((Object)rtpPacket.buffer, (String)"buffer");
                int extLen = parser.getEntireLengthBytes(rtpPacket.buffer, this.nextOffset);
                return extLen > this.remainingLength ? -1 : extLen;
            }
            EncodedHeaderExtensions $this$getNextExtLength_u24lambda_u241 = this;
            boolean bl = false;
            return -1;
        }

        public final void reset$rtp() {
            int extLength;
            int n;
            if (RtpPacket.this.getHeaderExtensionParser() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)RtpPacket.this.buffer, (String)"buffer");
                int extensionBlockLength = HeaderExtensionHelpers.Companion.getExtensionsTotalLength(RtpPacket.this.buffer, RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4);
                n = extensionBlockLength - 4;
            } else {
                n = extLength = 0;
            }
            if (extLength <= 0) {
                this.nextOffset = -1;
                this.remainingLength = -1;
            } else {
                this.nextOffset = RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4 + 4;
                this.remainingLength = extLength;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\b\u0010\u0012\u001a\u00020\u0000H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0012\u0010\u0010\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0013\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "", "buffer", "", "getBuffer", "()[B", "dataOffset", "", "getDataOffset", "()I", "id", "getId", "setId", "(I)V", "dataLengthBytes", "getDataLengthBytes", "totalLengthBytes", "getTotalLengthBytes", "clone", "rtp"})
    public static interface HeaderExtension {
        @NotNull
        public byte[] getBuffer();

        public int getDataOffset();

        public int getId();

        public void setId(int var1);

        public int getDataLengthBytes();

        public int getTotalLengthBytes();

        @NotNull
        default public HeaderExtension clone() {
            return new StandaloneHeaderExtension(this);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            @NotNull
            public static HeaderExtension clone(@NotNull HeaderExtension $this) {
                return $this.clone();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\bJ\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$PendingHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "id", "", "dataLengthBytes", "<init>", "(Lorg/jitsi/rtp/rtp/RtpPacket;II)V", "other", "(Lorg/jitsi/rtp/rtp/RtpPacket;Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "getId", "()I", "setId", "(I)V", "getDataLengthBytes", "buffer", "", "getBuffer", "()[B", "dataOffset", "getDataOffset", "totalLengthBytes", "getTotalLengthBytes", "writeToBuffer", "offset", "parser", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "rtp"})
    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"}, justification="We intentionally expose the internal buffer.")
    public final class PendingHeaderExtension
    implements HeaderExtension {
        private int id;
        private final int dataLengthBytes;
        @NotNull
        private final byte[] buffer;
        private final int dataOffset;
        final /* synthetic */ RtpPacket this$0;

        public PendingHeaderExtension(RtpPacket this$0, int id, int dataLengthBytes) {
            this.this$0 = this$0;
            this.id = id;
            this.dataLengthBytes = dataLengthBytes;
            this.buffer = new byte[this.getDataLengthBytes()];
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int n) {
            this.id = n;
        }

        @Override
        public int getDataLengthBytes() {
            return this.dataLengthBytes;
        }

        @Override
        @NotNull
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public int getDataOffset() {
            return this.dataOffset;
        }

        @Override
        public int getTotalLengthBytes() {
            int n = this.getDataLengthBytes();
            HeaderExtensionParser headerExtensionParser = this.this$0.getHeaderExtensionParser();
            Intrinsics.checkNotNull((Object)headerExtensionParser);
            return n + headerExtensionParser.getExtHeaderSizeBytes();
        }

        public PendingHeaderExtension(@NotNull RtpPacket this$0, HeaderExtension other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this(this$0, other.getId(), other.getDataLengthBytes());
            System.arraycopy(other.getBuffer(), other.getDataOffset(), this.getBuffer(), 0, this.getDataLengthBytes());
        }

        public final int writeToBuffer(@NotNull byte[] buffer, int offset, @NotNull HeaderExtensionParser parser) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            parser.writeIdAndLength(this.getId(), this.getDataLengthBytes(), buffer, offset);
            System.arraycopy(this.getBuffer(), this.getDataOffset(), buffer, offset + parser.getExtHeaderSizeBytes(), this.getDataLengthBytes());
            return parser.getExtHeaderSizeBytes() + this.getDataLengthBytes();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$StandaloneHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "ext", "<init>", "(Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "buffer", "", "getBuffer", "()[B", "dataOffset", "", "getDataOffset", "()I", "id", "getId", "setId", "(I)V", "dataLengthBytes", "getDataLengthBytes", "totalLengthBytes", "getTotalLengthBytes", "rtp"})
    @SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
    public static final class StandaloneHeaderExtension
    implements HeaderExtension {
        @NotNull
        private final byte[] buffer;
        private final int dataOffset;
        private int id;

        /*
         * WARNING - void declaration
         */
        public StandaloneHeaderExtension(@NotNull HeaderExtension ext) {
            void it;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            byte[] byArray2 = byArray = new byte[ext.getDataLengthBytes()];
            StandaloneHeaderExtension standaloneHeaderExtension = this;
            boolean bl = false;
            System.arraycopy(ext.getBuffer(), ext.getDataOffset(), it, 0, ext.getDataLengthBytes());
            standaloneHeaderExtension.buffer = byArray;
            this.id = ext.getId();
        }

        @Override
        @NotNull
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public int getDataOffset() {
            return this.dataOffset;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int n) {
            this.id = n;
        }

        @Override
        public int getDataLengthBytes() {
            return this.getBuffer().length;
        }

        @Override
        public int getTotalLengthBytes() {
            return this.getBuffer().length;
        }
    }
}

