/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/AbsSendTimeHeaderExtension;", "", "<init>", "()V", "Companion", "rtp"})
public final class AbsSendTimeHeaderExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DATA_SIZE_BYTES = 3;
    private static final int B = 1000000000;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/AbsSendTimeHeaderExtension$Companion;", "", "<init>", "()V", "DATA_SIZE_BYTES", "", "B", "setTime", "", "ext", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "timestampNanos", "", "buf", "", "offset", "getTime", "Ljava/time/Instant;", "dataOffset", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final void setTime(@NotNull RtpPacket.HeaderExtension ext, long timestampNanos) {
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            this.setTime(ext.getBuffer(), ext.getDataOffset(), timestampNanos);
        }

        private final void setTime(byte[] buf, int offset, long timestampNanos) {
            long fraction = timestampNanos % (long)1000000000 * (long)262144 / (long)1000000000;
            long seconds = timestampNanos / (long)1000000000 % (long)64;
            long timestamp = (seconds << 18 | fraction) & 0xFFFFFFL;
            ByteArrayExtensionsKt.put3Bytes(buf, offset, (int)timestamp);
        }

        @NotNull
        public final Instant getTime(@NotNull RtpPacket.HeaderExtension ext) {
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            return this.getTime(ext.getBuffer(), ext.getDataOffset());
        }

        private final Instant getTime(byte[] buf, int dataOffset) {
            int seconds = FieldParsersKt.getBitsAsInt(buf, dataOffset, 0, 6);
            double fraction = (double)(FieldParsersKt.getBitsAsInt(buf, dataOffset, 6, 2) + FieldParsersKt.getShortAsInt(buf, dataOffset + 1)) / (double)262143;
            Instant instantMillis = Instant.ofEpochSecond(seconds);
            Instant instant = instantMillis.plusNanos((long)(fraction * (double)1000000000));
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusNanos(...)");
            return instant;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

