/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/rtp/util/BitReader;", "", "buf", "", "byteOffset", "", "byteLength", "<init>", "([BII)V", "getBuf", "()[B", "offset", "byteBound", "clone", "newByteLength", "remainingBits", "bitAsBoolean", "", "bit", "bits", "n", "bitsLong", "", "skipBits", "", "ns", "leb128", "reset", "rtp"})
@SourceDebugExtension(value={"SMAP\nBitReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitReader.kt\norg/jitsi/rtp/util/BitReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1869#3,2:138\n*S KotlinDebug\n*F\n+ 1 BitReader.kt\norg/jitsi/rtp/util/BitReader\n*L\n123#1:138,2\n*E\n"})
public final class BitReader {
    @NotNull
    private final byte[] buf;
    private final int byteOffset;
    private final int byteLength;
    private int offset;
    private final int byteBound;

    public BitReader(@NotNull byte[] buf, int byteOffset, int byteLength) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.buf = buf;
        this.byteOffset = byteOffset;
        this.byteLength = byteLength;
        this.offset = this.byteOffset * 8;
        this.byteBound = this.byteOffset + this.byteLength;
        if (!(this.byteOffset >= 0)) {
            boolean $i$a$-check-BitReader$32 = false;
            String $i$a$-check-BitReader$32 = "byteOffset must be >= 0";
            throw new IllegalStateException($i$a$-check-BitReader$32.toString());
        }
        if (!(this.byteBound <= this.buf.length)) {
            boolean bl = false;
            String string = "byteOffset + byteLength must be <= buf.size";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ BitReader(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    @NotNull
    public final BitReader clone(int newByteLength) {
        if (!(this.offset % 8 == 0)) {
            boolean $i$a$-check-BitReader$clone$32 = false;
            String $i$a$-check-BitReader$clone$32 = "Cannot clone BitReader with unaligned offset";
            throw new IllegalStateException($i$a$-check-BitReader$clone$32.toString());
        }
        if (!(this.offset / 8 + newByteLength <= this.byteBound)) {
            boolean bl = false;
            String string = "newByteLength " + newByteLength + " exceeds buffer length " + this.byteLength + " after offset " + this.byteOffset;
            throw new IllegalStateException(string.toString());
        }
        return new BitReader(this.buf, this.offset / 8, newByteLength);
    }

    public final int remainingBits() {
        return this.byteBound * 8 - this.offset;
    }

    public final boolean bitAsBoolean() {
        int byteIdx = this.offset / 8;
        int bitIdx = this.offset % 8;
        if (!(byteIdx < this.byteBound)) {
            boolean $i$a$-check-BitReader$bitAsBoolean$22 = false;
            String $i$a$-check-BitReader$bitAsBoolean$22 = "offset " + this.offset + " (" + byteIdx + "/" + bitIdx + ") invalid in buffer of length " + this.byteLength + " after offset " + this.byteOffset;
            throw new IllegalStateException($i$a$-check-BitReader$bitAsBoolean$22.toString());
        }
        byte by = this.buf[byteIdx];
        byte mask = (byte)(1 << 7 - bitIdx);
        int n = this.offset;
        this.offset = n + 1;
        return (byte)(by & mask) != 0;
    }

    public final int bit() {
        return this.bitAsBoolean() ? 1 : 0;
    }

    public final int bits(int n) {
        if (!(n < 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int ret = 0;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ret <<= 1;
            ret |= this.bit();
        }
        return ret;
    }

    public final long bitsLong(int n) {
        if (!(n < 64)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long ret = 0L;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ret <<= 1;
            ret |= (long)this.bit();
        }
        return ret;
    }

    public final void skipBits(int n) {
        this.offset += n;
    }

    public final int ns(int n) {
        int w = 0;
        int x = n;
        while (x != 0) {
            x >>= 1;
            ++w;
        }
        int m = (1 << w) - n;
        int v = this.bits(w - 1);
        if (v < m) {
            return v;
        }
        int extraBit = this.bit();
        return (v << 1) - m + extraBit;
    }

    public final long leb128() {
        long value = 0L;
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 8);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            boolean hasNext = this.bitAsBoolean();
            value |= (long)this.bits(7) << i * 7;
            if (hasNext) continue;
            return value;
        }
        return value;
    }

    public final void reset() {
        this.offset = this.byteOffset * 8;
    }
}

