/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.support.model.DescMeta;
import org.jupnp.support.model.container.Album;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.container.GenreContainer;
import org.jupnp.support.model.container.MovieGenre;
import org.jupnp.support.model.container.MusicAlbum;
import org.jupnp.support.model.container.MusicArtist;
import org.jupnp.support.model.container.MusicGenre;
import org.jupnp.support.model.container.PersonContainer;
import org.jupnp.support.model.container.PhotoAlbum;
import org.jupnp.support.model.container.PlaylistContainer;
import org.jupnp.support.model.container.StorageFolder;
import org.jupnp.support.model.container.StorageSystem;
import org.jupnp.support.model.container.StorageVolume;
import org.jupnp.support.model.item.AudioBook;
import org.jupnp.support.model.item.AudioBroadcast;
import org.jupnp.support.model.item.AudioItem;
import org.jupnp.support.model.item.ImageItem;
import org.jupnp.support.model.item.Item;
import org.jupnp.support.model.item.Movie;
import org.jupnp.support.model.item.MusicTrack;
import org.jupnp.support.model.item.MusicVideoClip;
import org.jupnp.support.model.item.Photo;
import org.jupnp.support.model.item.PlaylistItem;
import org.jupnp.support.model.item.TextItem;
import org.jupnp.support.model.item.VideoBroadcast;
import org.jupnp.support.model.item.VideoItem;

public class DIDLContent {
    public static final String NAMESPACE_URI = "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/";
    public static final String DESC_WRAPPER_NAMESPACE_URI = "urn:fourthline-org:cling:support:content-directory-desc-1-0";
    protected List<Container> containers = new ArrayList<Container>();
    protected List<Item> items = new ArrayList<Item>();
    protected List<DescMeta<?>> descMetadata = new ArrayList();

    public Container getFirstContainer() {
        return this.getContainers().get(0);
    }

    public DIDLContent addContainer(Container container) {
        this.getContainers().add(container);
        return this;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public DIDLContent addObject(Object object) {
        if (object instanceof Item) {
            this.addItem((Item)object);
        } else if (object instanceof Container) {
            this.addContainer((Container)object);
        }
        return this;
    }

    public DIDLContent addItem(Item item) {
        this.getItems().add(item);
        return this;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public DIDLContent addDescMetadata(DescMeta<?> descMetadata) {
        this.getDescMetadata().add(descMetadata);
        return this;
    }

    public List<DescMeta<?>> getDescMetadata() {
        return this.descMetadata;
    }

    public void setDescMetadata(List<DescMeta<?>> descMetadata) {
        this.descMetadata = descMetadata;
    }

    public void replaceGenericContainerAndItems() {
        this.setItems(this.replaceGenericItems(this.getItems()));
        this.setContainers(this.replaceGenericContainers(this.getContainers()));
    }

    protected List<Item> replaceGenericItems(List<Item> genericItems) {
        ArrayList<Item> specificItems = new ArrayList<Item>();
        for (Item genericItem : genericItems) {
            String genericType = genericItem.getClazz().getValue();
            if (AudioItem.CLASS.getValue().equals(genericType)) {
                specificItems.add(new AudioItem(genericItem));
                continue;
            }
            if (MusicTrack.CLASS.getValue().equals(genericType)) {
                specificItems.add(new MusicTrack(genericItem));
                continue;
            }
            if (AudioBook.CLASS.getValue().equals(genericType)) {
                specificItems.add(new AudioBook(genericItem));
                continue;
            }
            if (AudioBroadcast.CLASS.getValue().equals(genericType)) {
                specificItems.add(new AudioBroadcast(genericItem));
                continue;
            }
            if (VideoItem.CLASS.getValue().equals(genericType)) {
                specificItems.add(new VideoItem(genericItem));
                continue;
            }
            if (Movie.CLASS.getValue().equals(genericType)) {
                specificItems.add(new Movie(genericItem));
                continue;
            }
            if (VideoBroadcast.CLASS.getValue().equals(genericType)) {
                specificItems.add(new VideoBroadcast(genericItem));
                continue;
            }
            if (MusicVideoClip.CLASS.getValue().equals(genericType)) {
                specificItems.add(new MusicVideoClip(genericItem));
                continue;
            }
            if (ImageItem.CLASS.getValue().equals(genericType)) {
                specificItems.add(new ImageItem(genericItem));
                continue;
            }
            if (Photo.CLASS.getValue().equals(genericType)) {
                specificItems.add(new Photo(genericItem));
                continue;
            }
            if (PlaylistItem.CLASS.getValue().equals(genericType)) {
                specificItems.add(new PlaylistItem(genericItem));
                continue;
            }
            if (TextItem.CLASS.getValue().equals(genericType)) {
                specificItems.add(new TextItem(genericItem));
                continue;
            }
            specificItems.add(genericItem);
        }
        return specificItems;
    }

    protected List<Container> replaceGenericContainers(List<Container> genericContainers) {
        ArrayList<Container> specificContainers = new ArrayList<Container>();
        for (Container genericContainer : genericContainers) {
            String genericType = genericContainer.getClazz().getValue();
            Container specific = Album.CLASS.getValue().equals(genericType) ? new Album(genericContainer) : (MusicAlbum.CLASS.getValue().equals(genericType) ? new MusicAlbum(genericContainer) : (PhotoAlbum.CLASS.getValue().equals(genericType) ? new PhotoAlbum(genericContainer) : (GenreContainer.CLASS.getValue().equals(genericType) ? new GenreContainer(genericContainer) : (MusicGenre.CLASS.getValue().equals(genericType) ? new MusicGenre(genericContainer) : (MovieGenre.CLASS.getValue().equals(genericType) ? new MovieGenre(genericContainer) : (PlaylistContainer.CLASS.getValue().equals(genericType) ? new PlaylistContainer(genericContainer) : (PersonContainer.CLASS.getValue().equals(genericType) ? new PersonContainer(genericContainer) : (MusicArtist.CLASS.getValue().equals(genericType) ? new MusicArtist(genericContainer) : (StorageSystem.CLASS.getValue().equals(genericType) ? new StorageSystem(genericContainer) : (StorageVolume.CLASS.getValue().equals(genericType) ? new StorageVolume(genericContainer) : (StorageFolder.CLASS.getValue().equals(genericType) ? new StorageFolder(genericContainer) : genericContainer)))))))))));
            specific.setItems(this.replaceGenericItems(genericContainer.getItems()));
            specificContainers.add(specific);
        }
        return specificContainers;
    }

    public long getCount() {
        return this.items.size() + this.containers.size();
    }
}

