/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.internal.math.DoubleAdder;
import java.util.Objects;

abstract class MomentStatistics {
    private long _n = 0L;
    private final DoubleAdder _m1 = new DoubleAdder();
    private final DoubleAdder _m2 = new DoubleAdder();
    private final DoubleAdder _m3 = new DoubleAdder();
    private final DoubleAdder _m4 = new DoubleAdder();

    MomentStatistics() {
    }

    void accept(double value) {
        ++this._n;
        double n = this._n;
        double d = value - this._m1.value();
        double dN = d / n;
        double dN2 = dN * dN;
        double t1 = d * dN * (n - 1.0);
        this._m1.add(dN);
        this._m4.add(t1 * dN2 * (n * n - 3.0 * n + 3.0)).add(6.0 * dN2 * this._m2.value() - 4.0 * dN * this._m3.value());
        this._m3.add(t1 * dN * (n - 2.0) - 3.0 * dN * this._m2.value());
        this._m2.add(t1);
    }

    void combine(MomentStatistics b) {
        Objects.requireNonNull(b);
        double m2 = this._m2.value();
        double m3 = this._m3.value();
        double pn = this._n;
        double n = this._n + b._n;
        double nn = n * n;
        double d = b._m1.value() - this._m1.value();
        double dd = d * d;
        this._n += b._n;
        this._m1.add(d * (double)b._n / n);
        this._m2.add(b._m2).add(dd * pn * (double)b._n / n);
        this._m3.add(b._m3).add(dd * d * (pn * (double)b._n * (pn - (double)b._n) / nn)).add(3.0 * d * (pn * b._m2.value() - (double)b._n * m2) / n);
        this._m4.add(b._m4).add(dd * dd * (pn * (double)b._n * (pn * pn - pn * (double)b._n + (double)(b._n * b._n)) / (nn * n))).add(6.0 * dd * (pn * pn * b._m2.value() + (double)(b._n * b._n) * m2) / nn).add(4.0 * d * (pn * b._m3.value() - (double)b._n * m3) / n);
    }

    public long getCount() {
        return this._n;
    }

    public double getMean() {
        return this._n == 0L ? Double.NaN : this._m1.value();
    }

    public double getVariance() {
        double var = Double.NaN;
        if (this._n == 1L) {
            var = this._m2.value();
        } else if (this._n > 1L) {
            var = this._m2.value() / ((double)this._n - 1.0);
        }
        return var;
    }

    public double getSkewness() {
        double skewness = Double.NaN;
        if (this._n >= 3L) {
            double var = this._m2.value() / ((double)this._n - 1.0);
            skewness = var < 1.0E-19 ? 0.0 : (double)this._n * this._m3.value() / (((double)this._n - 1.0) * ((double)this._n - 2.0) * Math.sqrt(var) * var);
        }
        return skewness;
    }

    public double getKurtosis() {
        double kurtosis = Double.NaN;
        if (this._n > 3L) {
            double var = this._m2.value() / (double)(this._n - 1L);
            kurtosis = this._n <= 3L || var < 1.0E-19 ? 0.0 : ((double)this._n * ((double)this._n + 1.0) * this._m4.value() - 3.0 * this._m2.value() * this._m2.value() * ((double)this._n - 1.0)) / (((double)this._n - 1.0) * ((double)this._n - 2.0) * ((double)this._n - 3.0) * var * var);
        }
        return kurtosis;
    }

    final boolean sameState(MomentStatistics statistics) {
        return this._n == statistics._n && this._m1.sameState(statistics._m1) && this._m2.sameState(statistics._m2) && this._m3.sameState(statistics._m3) && this._m4.sameState(statistics._m4);
    }
}

