/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class VcsCacheManager {
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;

    public static VcsCacheManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsCacheManager.$$$reportNull$$$0(0);
        }
        return (VcsCacheManager)project.getService(VcsCacheManager.class);
    }

    public VcsCacheManager(@NotNull Project project) {
        if (project == null) {
            VcsCacheManager.$$$reportNull$$$0(1);
        }
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearAll());
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearAll());
        VcsEP.EP_NAME.addChangeListener(() -> {
            this.myVcsHistoryCache.clearAll();
            this.myContentRevisionCache.clearAll();
        }, (Disposable)project);
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsCacheManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

