/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class ScaleData {
    private static final int[] NTICKS = new int[]{2, 5, 10, 10};
    private static final double[] LOGTICKS = new double[]{Math.log10(2.0), Math.log10(5.0), 0.0, 1.0};
    private double initMinYOnScale;
    private double initMaxYOnScale;
    private double initMinY;
    private double initMaxY;
    int startDataPointIndex;
    int endDataPointIndex;
    int pointCount;
    double minX;
    double maxX;
    double firstX = Double.NaN;
    public double minXOnScale;
    public double maxXOnScale;
    double specShift;
    public int[] precision = new int[2];
    public int[] exportPrecision = new int[2];
    public double[] steps = new double[2];
    int[] minorTickCounts = new int[2];
    public double minYOnScale;
    public double maxYOnScale;
    double minY;
    double maxY;
    boolean isShiftZoomedY;
    double spectrumScaleFactor = 1.0;
    double spectrumYRef = 0.0;
    double userYFactor = 1.0;
    double firstY;
    double minY2D;
    double maxY2D;
    private double xFactorForScale;
    private double yFactorForScale;

    ScaleData() {
    }

    ScaleData(int iStart, int iEnd) {
        this.startDataPointIndex = iStart;
        this.endDataPointIndex = iEnd;
        this.pointCount = this.endDataPointIndex - this.startDataPointIndex + 1;
    }

    public ScaleData(Coordinate[] coords, int start, int end, boolean isContinuous, boolean isInverted) {
        this.minX = Coordinate.getMinX(coords, start, end);
        this.maxX = Coordinate.getMaxX(coords, start, end);
        this.minY = Coordinate.getMinY(coords, start, end);
        if (this.minY > 0.0 && !isContinuous) {
            this.minY = 0.0;
        }
        this.maxY = Coordinate.getMaxY(coords, start, end);
        this.setScale(isContinuous, isInverted);
    }

    void setScale(boolean isContinuous, boolean isInverted) {
        this.setXScale();
        if (!isContinuous) {
            this.maxXOnScale += this.steps[0] / 2.0;
        }
        this.setYScale(this.minY, this.maxY, true, isInverted);
    }

    private void setXScale() {
        double xStep = this.setScaleParams(this.minX, this.maxX, 0);
        this.firstX = Math.floor(this.minX / xStep) * xStep;
        if (Math.abs((this.minX - this.firstX) / xStep) > 1.0E-4) {
            this.firstX += xStep;
        }
        this.minXOnScale = this.minX;
        this.maxXOnScale = this.maxX;
    }

    boolean isYZeroOnScale() {
        return this.minYOnScale < this.spectrumYRef && this.maxYOnScale > this.spectrumYRef;
    }

    void setYScale(double minY, double maxY, boolean setScaleMinMax, boolean isInverted) {
        double dy2;
        if (minY == 0.0 && maxY == 0.0) {
            maxY = 1.0;
        }
        if (this.isShiftZoomedY) {
            minY = this.minYOnScale;
            maxY = this.maxYOnScale;
        }
        double yStep = this.setScaleParams(minY, maxY, 1);
        double dy = isInverted ? yStep / 2.0 : yStep / 4.0;
        double d = dy2 = isInverted ? yStep / 4.0 : yStep / 2.0;
        if (!this.isShiftZoomedY) {
            this.minYOnScale = minY == 0.0 ? 0.0 : (setScaleMinMax ? dy * Math.floor(minY / dy) : minY);
            this.maxYOnScale = setScaleMinMax ? dy2 * Math.ceil(maxY * 1.05 / dy2) : maxY;
        }
        double d2 = this.firstY = minY == 0.0 ? 0.0 : Math.floor(minY / dy) * dy;
        if (this.minYOnScale < 0.0 && this.maxYOnScale > 0.0) {
            this.firstY = 0.0;
            while (this.firstY - yStep > this.minYOnScale) {
                this.firstY -= yStep;
            }
        } else if (this.minYOnScale != 0.0 && Math.abs((minY - this.firstY) / dy) > 1.0E-4) {
            this.firstY += dy;
        }
        if (setScaleMinMax) {
            this.initMinYOnScale = this.minYOnScale;
            this.initMaxYOnScale = this.maxYOnScale;
            this.initMinY = minY;
            this.initMaxY = maxY;
        }
    }

    void scale2D(double f) {
        double dy = this.maxY - this.minY;
        if (f == 1.0) {
            this.maxY = this.initMaxY;
            this.minY = this.initMinY;
            return;
        }
        this.maxY = this.minY + dy / f;
    }

    void setXRange(double x1, double x2) {
        this.minX = x1;
        this.maxX = x2;
        this.setXScale();
    }

    private static int getXRange(int i, Coordinate[] xyCoords, double initX, double finalX, int iStart, int iEnd, int[] startIndices, int[] endIndices) {
        int index = 0;
        int ptCount = 0;
        for (index = iStart; index <= iEnd; ++index) {
            if (!(xyCoords[index].getXVal() >= initX)) continue;
            startIndices[i] = index;
            ptCount = 1;
            break;
        }
        while (++index <= iEnd && xyCoords[index].getXVal() <= finalX) {
            ++ptCount;
        }
        endIndices[i] = startIndices[i] + ptCount - 1;
        return ptCount;
    }

    private double setScaleParams(double min, double max, int i) {
        int exp;
        double dx = max == min ? 1.0 : Math.abs(max - min) / 14.0;
        double log = Math.log10(Math.abs(dx));
        this.exportPrecision[i] = exp = (int)Math.floor(log);
        this.precision[i] = exp <= 0 ? Math.min(8, 1 - exp) : (exp > 3 ? -2 : 0);
        int j = 0;
        double dec = Math.pow(10.0, log - (double)exp);
        while (dec > (double)NTICKS[j]) {
            ++j;
        }
        this.steps[i] = Math.pow(10.0, exp) * (double)NTICKS[j];
        log = Math.log10(Math.abs(this.steps[i] * 100010.0));
        double mantissa = log - Math.floor(log);
        int n = 0;
        for (j = 0; j < NTICKS.length; ++j) {
            if (!(Math.abs(mantissa - LOGTICKS[j]) < 0.001)) continue;
            n = NTICKS[j];
            break;
        }
        this.minorTickCounts[i] = n;
        return this.steps[i];
    }

    boolean isInRangeX(double x) {
        return x >= this.minX && x <= this.maxX;
    }

    void addSpecShift(double dx) {
        this.specShift += dx;
        this.minX += dx;
        this.maxX += dx;
        this.minXOnScale += dx;
        this.maxXOnScale += dx;
        this.firstX += dx;
    }

    Map<String, Object> getInfo(Map<String, Object> info) {
        info.put("specShift", this.specShift);
        info.put("minX", this.minX);
        info.put("maxX", this.maxX);
        info.put("minXOnScale", this.minXOnScale);
        info.put("maxXOnScale", this.maxXOnScale);
        info.put("minY", this.minY);
        info.put("maxY", this.maxY);
        info.put("minYOnScale", this.minYOnScale);
        info.put("maxYOnScale", this.maxYOnScale);
        info.put("minorTickCountX", this.minorTickCounts[0]);
        info.put("xStep", this.steps[0]);
        return info;
    }

    void setMinMax(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    double toX(int xPixel, int xPixel1, boolean drawXAxisLeftToRight) {
        return this.toXScaled(xPixel, xPixel1, drawXAxisLeftToRight, this.xFactorForScale);
    }

    double toX0(int xPixel, int xPixel0, int xPixel1, boolean drawXAxisLeftToRight) {
        return this.toXScaled(xPixel, xPixel1, drawXAxisLeftToRight, (this.maxXOnScale - this.minXOnScale) / (double)(xPixel1 - xPixel0));
    }

    private double toXScaled(int xPixel, int xPixel1, boolean drawXAxisLeftToRight, double factor) {
        return drawXAxisLeftToRight ? this.maxXOnScale - (double)(xPixel1 - xPixel) * factor : this.minXOnScale + (double)(xPixel1 - xPixel) * factor;
    }

    int toPixelX(double dx, int xPixel0, int xPixel1, boolean drawXAxisLeftToRight) {
        return this.toPixelXScaled(dx, xPixel0, xPixel1, drawXAxisLeftToRight, this.xFactorForScale);
    }

    int toPixelX0(double dx, int xPixel0, int xPixel1, boolean drawXAxisLeftToRight) {
        return this.toPixelXScaled(dx, xPixel0, xPixel1, drawXAxisLeftToRight, (this.maxXOnScale - this.minXOnScale) / (double)(xPixel1 - xPixel0));
    }

    private int toPixelXScaled(double dx, int xPixel0, int xPixel1, boolean drawXAxisLeftToRight, double factor) {
        int x = (int)((dx - this.minXOnScale) / factor);
        return drawXAxisLeftToRight ? xPixel0 + x : xPixel1 - x;
    }

    double toY(int yPixel, int yPixel0) {
        return this.maxYOnScale + (double)(yPixel0 - yPixel) * this.yFactorForScale;
    }

    double toY0(int yPixel, int yPixel0, int yPixel1) {
        double factor = (this.maxYOnScale - this.minYOnScale) / (double)(yPixel1 - yPixel0);
        double y = this.maxYOnScale + (double)(yPixel0 - yPixel) * factor;
        return Math.max(this.minYOnScale, Math.min(y, this.maxYOnScale));
    }

    int toPixelY(double yVal, int yPixel1) {
        return Double.isNaN(yVal) ? Integer.MIN_VALUE : yPixel1 - (int)(((yVal - this.spectrumYRef) * this.userYFactor + this.spectrumYRef - this.minYOnScale) / this.yFactorForScale);
    }

    int toPixelY0(double y, int yPixel0, int yPixel1) {
        double factor = (this.maxYOnScale - this.minYOnScale) / (double)(yPixel1 - yPixel0);
        return (int)((double)yPixel0 + (this.maxYOnScale - y) / factor);
    }

    void setXYScale(int xPixels, int yPixels, boolean isInverted) {
        double maxY;
        double yRef = this.spectrumYRef;
        double f = this.spectrumScaleFactor;
        boolean useInit = f != 1.0 || this.isShiftZoomedY;
        double minY = useInit ? this.initMinYOnScale : this.minY;
        double d = maxY = useInit ? this.initMaxYOnScale : this.maxY;
        if (useInit && yRef < minY) {
            yRef = minY;
        }
        if (useInit && yRef > maxY) {
            yRef = maxY;
        }
        this.setYScale((minY - yRef) / f + yRef, (maxY - yRef) / f + yRef, f == 1.0, isInverted);
        this.xFactorForScale = (this.maxXOnScale - this.minXOnScale) / (double)(xPixels - 1);
        this.yFactorForScale = (this.maxYOnScale - this.minYOnScale) / (double)(yPixels - 1);
    }

    static void copyScaleFactors(ScaleData[] sdFrom, ScaleData[] sdTo) {
        for (int i = 0; i < sdFrom.length; ++i) {
            sdTo[i].spectrumScaleFactor = sdFrom[i].spectrumScaleFactor;
            sdTo[i].spectrumYRef = sdFrom[i].spectrumYRef;
            sdTo[i].userYFactor = sdFrom[i].userYFactor;
            sdTo[i].specShift = sdFrom[i].specShift;
            sdTo[i].isShiftZoomedY = sdFrom[i].isShiftZoomedY;
        }
    }

    static void copyYScales(ScaleData[] sdFrom, ScaleData[] sdTo) {
        for (int i = 0; i < sdFrom.length; ++i) {
            sdTo[i].initMinYOnScale = sdFrom[i].initMinYOnScale;
            sdTo[i].initMaxYOnScale = sdFrom[i].initMaxYOnScale;
            sdTo[i].minY = sdFrom[i].minY;
            sdTo[i].maxY = sdFrom[i].maxY;
            if (!sdFrom[i].isShiftZoomedY) continue;
            sdTo[i].isShiftZoomedY = true;
            sdTo[i].minYOnScale = sdFrom[i].minYOnScale;
            sdTo[i].maxYOnScale = sdFrom[i].maxYOnScale;
        }
    }

    static boolean setDataPointIndices(Lst<Spectrum> graphsTemp, double initX, double finalX, int minPoints, int[] startIndices, int[] endIndices) {
        int nSpectraOK = 0;
        int nSpectra = graphsTemp.size();
        for (int i = 0; i < nSpectra; ++i) {
            Coordinate[] xyCoords = ((Spectrum)graphsTemp.get(i)).getXYCoords();
            if (ScaleData.getXRange(i, xyCoords, initX, finalX, 0, xyCoords.length - 1, startIndices, endIndices) < minPoints) continue;
            ++nSpectraOK;
        }
        return nSpectraOK == nSpectra;
    }

    /*
     * Unable to fully structure code
     */
    static void fixScale(Map<Double, String> map) {
        if (map.isEmpty()) {
            return;
        }
        while (true) {
            for (Map.Entry<Double, String> entry : map.entrySet()) {
                s = entry.getValue();
                pt = s.indexOf("E");
                if (pt >= 0) {
                    s = s.substring(0, pt);
                }
                if (s.indexOf(".") < 0) {
                    return;
                }
                if (s.endsWith("0") || s.endsWith(".")) continue;
                return;
            }
            var1_1 = map.entrySet().iterator();
            while (true) {
                if (!var1_1.hasNext()) ** continue;
                entry = var1_1.next();
                s = entry.getValue();
                pt = s.indexOf("E");
                if (pt >= 0) {
                    entry.setValue(s.substring(0, pt - 1) + s.substring(pt));
                    continue;
                }
                entry.setValue(s.substring(0, s.length() - 1));
            }
            break;
        }
    }

    void scaleBy(double f) {
        if (this.isShiftZoomedY) {
            double center = this.isYZeroOnScale() ? this.spectrumYRef : (this.minYOnScale + this.maxYOnScale) / 2.0;
            this.minYOnScale = center - (center - this.minYOnScale) / f;
            this.maxYOnScale = center - (center - this.maxYOnScale) / f;
        } else {
            this.spectrumScaleFactor *= f;
        }
    }
}

