/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.GeoJSONWriter;
import org.openstreetmap.josm.tools.Logging;

public class GeoJSONMapRouletteWriter
extends GeoJSONWriter {
    public GeoJSONMapRouletteWriter(DataSet ds) {
        super(ds);
        super.setOptions(GeoJSONWriter.Options.RIGHT_HAND_RULE, GeoJSONWriter.Options.WRITE_OSM_INFORMATION);
    }

    public Optional<JsonObject> write(TestError testError) {
        JsonObjectBuilder jsonObjectBuilder = JSON_PROVIDER.createObjectBuilder();
        JsonArrayBuilder featuresBuilder = JSON_PROVIDER.createArrayBuilder();
        JsonObjectBuilder propertiesBuilder = JSON_PROVIDER.createObjectBuilder();
        propertiesBuilder.add("message", testError.getMessage());
        Optional.ofNullable(testError.getDescription()).ifPresent(description -> propertiesBuilder.add("description", (String)description));
        propertiesBuilder.add("code", testError.getUniqueCode());
        propertiesBuilder.add("fixable", testError.isFixable());
        propertiesBuilder.add("severity", testError.getSeverity().toString());
        propertiesBuilder.add("severityInteger", testError.getSeverity().getLevel());
        propertiesBuilder.add("test", testError.getTester().getName());
        Stream.concat(testError.getPrimitives().stream(), testError.getHighlighted().stream()).distinct().map(p -> {
            if (p instanceof OsmPrimitive) {
                return p;
            }
            if (p instanceof WaySegment) {
                return ((WaySegment)p).toWay();
            }
            Logging.trace("Could not convert {0} to an OsmPrimitive", p);
            return null;
        }).filter(Objects::nonNull).distinct().map(OsmPrimitive.class::cast).forEach(primitive -> super.appendPrimitive((OsmPrimitive)primitive, featuresBuilder));
        JsonArray featureArray = featuresBuilder.build();
        JsonArrayBuilder featuresMessageBuilder = JSON_PROVIDER.createArrayBuilder();
        if (featureArray.isEmpty()) {
            Logging.trace("Could not generate task for {0}", testError.getMessage());
            return Optional.empty();
        }
        JsonObject primitive2 = featureArray.getJsonObject(0);
        JsonObjectBuilder replacementPrimitive = JSON_PROVIDER.createObjectBuilder(primitive2);
        JsonObjectBuilder properties = primitive2.containsKey("properties") && ((JsonValue)primitive2.get("properties")).getValueType() == JsonValue.ValueType.OBJECT ? JSON_PROVIDER.createObjectBuilder(primitive2.getJsonObject("properties")) : JSON_PROVIDER.createObjectBuilder();
        properties.addAll(propertiesBuilder);
        replacementPrimitive.add("properties", properties);
        featuresMessageBuilder.add(replacementPrimitive);
        for (int i = 1; i < featureArray.size(); ++i) {
            featuresMessageBuilder.add((JsonValue)featureArray.get(i));
        }
        jsonObjectBuilder.add("type", "FeatureCollection");
        jsonObjectBuilder.add("features", featuresMessageBuilder);
        return Optional.of(jsonObjectBuilder.build());
    }
}

