/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.tools.LtThreadPoolFactory;

public class LtThreadPoolFactoryTest {
    @Test
    public void cachedThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-cached", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        Assert.assertEquals((Object)myThreadPool, LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-cached").get());
    }

    @Test
    public void notcachedThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-notCached", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)false);
        Assert.assertEquals((Object)LtThreadPoolFactory.defaultPool, LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-notCached").get());
    }

    @Test
    @Ignore
    public void stressedQueueTest() {
        int i;
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-stressed", (int)5, (int)10, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        for (i = 0; i < 15; ++i) {
            myThreadPool.submit(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        Assert.assertThrows(Exception.class, () -> myThreadPool.submit(() -> System.out.println("Should fail.")));
        for (i = 0; i < 100; ++i) {
            Awaitility.await().until(() -> myThreadPool.getQueue().size() < 9);
            myThreadPool.submit(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        long startTime = System.currentTimeMillis();
        Awaitility.await().forever().until(() -> myThreadPool.getActiveCount() == 0);
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(endTime - startTime), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(100L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(120L))));
    }

    @Test
    @Ignore
    public void normalUsageThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-snt", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        Optional fixedThreadPoolExecutor = LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-snt");
        Assert.assertTrue((boolean)fixedThreadPoolExecutor.isPresent());
        ThreadPoolExecutor sameAsMyThreadPool = (ThreadPoolExecutor)fixedThreadPoolExecutor.get();
        Assert.assertEquals((Object)sameAsMyThreadPool, (Object)myThreadPool);
        for (int i = 0; i < 30; ++i) {
            sameAsMyThreadPool.submit(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    System.out.println(ex.getMessage());
                }
            });
        }
        Assert.assertEquals((long)10L, (long)myThreadPool.getActiveCount());
        Assert.assertFalse((boolean)myThreadPool.getQueue().isEmpty());
        long startTime = System.currentTimeMillis();
        Awaitility.await().until(() -> myThreadPool.getActiveCount() == 0);
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(endTime - startTime), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(6000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(7000L))));
        Assert.assertEquals((long)0L, (long)myThreadPool.getActiveCount());
        Assert.assertTrue((boolean)myThreadPool.getQueue().isEmpty());
    }

    @Test
    @Ignore
    public void normalMultiUsageThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-mnp", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        for (int i = 0; i < 30; ++i) {
            new Thread(() -> {
                Optional fixedThreadPoolExecutor = LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-mnp");
                Assert.assertTrue((boolean)fixedThreadPoolExecutor.isPresent());
                ThreadPoolExecutor multiThreadedAccessOnMyThreadPool = (ThreadPoolExecutor)fixedThreadPoolExecutor.get();
                Assert.assertEquals((Object)multiThreadedAccessOnMyThreadPool, (Object)myThreadPool);
                multiThreadedAccessOnMyThreadPool.submit(() -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        System.out.println(ex.getMessage());
                    }
                });
            }).start();
        }
        Assert.assertFalse((boolean)myThreadPool.getQueue().isEmpty());
        long startTime = System.currentTimeMillis();
        Awaitility.await().until(() -> myThreadPool.getActiveCount() == 0);
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(endTime - startTime), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(6000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(7000L))));
        Assert.assertEquals((long)0L, (long)myThreadPool.getActiveCount());
        Assert.assertTrue((boolean)myThreadPool.getQueue().isEmpty());
    }

    @Test
    @Ignore
    public void overloadingUsageThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-osp", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        Optional fixedThreadPoolExecutor = LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-osp");
        Assert.assertTrue((boolean)fixedThreadPoolExecutor.isPresent());
        ThreadPoolExecutor sameAsMyThreadPool = (ThreadPoolExecutor)fixedThreadPoolExecutor.get();
        Assert.assertEquals((Object)sameAsMyThreadPool, (Object)myThreadPool);
        for (int i = 0; i < 31; ++i) {
            if (i == 30) {
                Assert.assertThrows(RejectedExecutionException.class, () -> sameAsMyThreadPool.submit(() -> {}));
                break;
            }
            sameAsMyThreadPool.submit(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    System.out.println(ex.getMessage());
                }
            });
        }
        Assert.assertFalse((boolean)myThreadPool.getQueue().isEmpty());
        long startTime = System.currentTimeMillis();
        Awaitility.await().until(() -> myThreadPool.getActiveCount() == 0);
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(endTime - startTime), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(6000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(7000L))));
        Assert.assertEquals((long)0L, (long)myThreadPool.getActiveCount());
        Assert.assertTrue((boolean)myThreadPool.getQueue().isEmpty());
    }

    @Test
    @Ignore
    public void overloadedMultiUsageThreadPoolTest() {
        ThreadPoolExecutor myThreadPool = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"Test-Pool-omp", (int)10, (int)20, (boolean)false, (thread, throwable) -> System.out.println(throwable.getClass()), (boolean)true);
        int i = 0;
        while (i < 31) {
            int finalI = i++;
            new Thread(() -> {
                Optional fixedThreadPoolExecutor = LtThreadPoolFactory.getFixedThreadPoolExecutor((String)"Test-Pool-omp");
                Assert.assertTrue((boolean)fixedThreadPoolExecutor.isPresent());
                ThreadPoolExecutor multiThreadedAccessOnMyThreadPool = (ThreadPoolExecutor)fixedThreadPoolExecutor.get();
                Assert.assertEquals((Object)multiThreadedAccessOnMyThreadPool, (Object)myThreadPool);
                if (finalI == 30) {
                    Assert.assertThrows(RejectedExecutionException.class, () -> multiThreadedAccessOnMyThreadPool.submit(() -> {}));
                } else {
                    multiThreadedAccessOnMyThreadPool.submit(() -> {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex) {
                            System.out.println(ex.getMessage());
                        }
                    });
                }
            }).start();
        }
        Assert.assertFalse((boolean)myThreadPool.getQueue().isEmpty());
        long startTime = System.currentTimeMillis();
        Awaitility.await().until(() -> myThreadPool.getActiveCount() == 0);
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(endTime - startTime), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(6000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(7000L))));
        Assert.assertEquals((long)0L, (long)myThreadPool.getActiveCount());
        Assert.assertTrue((boolean)myThreadPool.getQueue().isEmpty());
    }
}

