/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class CachedVector<E>
extends Vector<E> {
    private static final long serialVersionUID = -4994486169224407197L;
    private Map<Object, IntegerWrapper> _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> c) {
        super(c);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public int indexOf(Object elem) {
        this.initializeCache();
        IntegerWrapper o = this._indexCache.get(elem);
        if (o != null) {
            return o.integer;
        }
        if (this.isLazyCaching()) {
            int i = super.indexOf(elem);
            if (i == -1) {
                this.uncacheIt(elem);
            } else {
                this.cacheIt(elem, i);
            }
            return i;
        }
        return -1;
    }

    protected synchronized void adjustCache(int index, int increase) {
        if (this._indexCache != null) {
            if (this.size() - index <= this.size() >> 2) {
                Collection<IntegerWrapper> values = this._indexCache.values();
                for (IntegerWrapper value : values) {
                    if (value.integer < index) continue;
                    value.integer += increase;
                }
            } else {
                this.uncacheAll();
                if (!this.isLazyCaching()) {
                    this.cacheAll();
                }
            }
        }
    }

    protected Map<Object, IntegerWrapper> createCache() {
        return new IdentityHashMap<Object, IntegerWrapper>();
    }

    public synchronized void cacheIt(Object o, int index) {
        if (this._indexCache != null && (this._indexCache.get(o) == null || index < this._indexCache.get((Object)o).integer)) {
            this._indexCache.put(o, new IntegerWrapper(index));
        }
    }

    public synchronized void uncacheIt(Object o) {
        if (this._indexCache != null) {
            this._indexCache.remove(o);
        }
    }

    @Override
    public synchronized boolean add(E element) {
        boolean added = super.add(element);
        if (!this.isLazyCaching() && added) {
            this.initializeCache();
            this.cacheIt(element, this.size() - 1);
        }
        return added;
    }

    @Override
    public synchronized void add(int index, E element) {
        super.add(index, element);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        } else if (this._indexCache != null) {
            this.adjustCache(index, 1);
            this.cacheIt(element, index);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public synchronized E remove(int index) {
        Object element = super.remove(index);
        if (element != null) {
            this.uncacheIt(element);
            this.adjustCache(index, -1);
        }
        return element;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int oldIndex = this.indexOf(o);
        boolean removed = super.remove(o);
        if (removed) {
            this.uncacheIt(o);
            this.adjustCache(oldIndex, -1);
        }
        return removed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        this.uncacheAll();
        return super.removeAll(c);
    }

    @Override
    public synchronized void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        boolean added = super.addAll(c);
        if (added) {
            this.cacheAll();
        }
        return added;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        boolean added = super.addAll(index, c);
        this.initializeCache();
        this.adjustCache(index, c.size());
        for (E e : c) {
            this.cacheIt(e, index++);
        }
        return added;
    }

    @Override
    public synchronized E set(int index, E element) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e = super.set(index, element);
            this.uncacheIt(e);
            this.cacheIt(element, index);
            return e;
        }
        return super.set(index, element);
    }

    public synchronized void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer i = 0;
        for (Object elem : this) {
            if (this._indexCache.get(elem) == null) {
                this._indexCache.put(elem, new IntegerWrapper(i));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean lazyCaching) {
        this._lazyCaching = lazyCaching;
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
        } else {
            super.removeRange(fromIndex, toIndex);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }

    public static class IntegerWrapper {
        int integer;

        private IntegerWrapper(int integer) {
            this.integer = integer;
        }
    }
}

