/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;

class IntervaldsAccessor
extends Accessor {
    static final int MAXLENGTH = 11;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;

    IntervaldsAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.INTERVALDS, stmt, 11, isStoredInBindData);
        this.init(stmt, 183, 183, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    IntervaldsAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.INTERVALDS, stmt, 11, false);
        this.init(stmt, 183, 183, form, false);
        this.initForDescribe(183, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    Duration getDuration(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] bytes = this.getBytesInternal(currentRow);
        return oracle.sql.INTERVALDS.toDuration(bytes);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getINTERVALDS(currentRow).toString();
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    @Override
    INTERVALDS getINTERVALDS(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new INTERVALDS(this.getBytesInternal(currentRow));
    }
}

