/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

class DNVerifier
implements Diagnosable {
    private static final String CLASS_NAME = DNVerifier.class.getName();
    private static final int SSL_CERT_SAN_TYPE_DNS_NAME = 2;
    private static final int SSL_CERT_SAN_TYPE_IP_ADDR = 7;
    private final ConnOption connOption;
    private final boolean isDNmatchEnabled;
    private final Diagnosable diagnosable;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;

    DNVerifier(ConnOption connOption, boolean isDNmatchEnabled, Diagnosable diagnosable) {
        this.connOption = connOption;
        this.isDNmatchEnabled = isDNmatchEnabled;
        this.diagnosable = diagnosable;
    }

    SecurityInformation.DNMatchStatus verify(X509Certificate serverCert) throws IOException {
        if (!this.isDNmatchEnabled) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "verify", "Server DN verification is disabled and connection is not secure.Enable DN verification through Connection Property 'oracle.net.ssl_server_dn_match' or through URL parameter 'SSL_SERVER_DN_MATCH'", null, null);
            return SecurityInformation.DNMatchStatus.NOT_VERIFIED;
        }
        return this.verifyServerCertificate(serverCert);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    boolean isWeakDNMatchAllowed() {
        ConnOption originalConnOption = this.connOption.getOriginalConnOption();
        return originalConnOption.sslAllowWeakDNMatch != null && (originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("on") || originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("true") || originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("yes"));
    }

    public SecurityInformation.DNMatchStatus verifyServerCertificate(X509Certificate serverCertificate) throws NetException, IOException {
        ConnOption originalConnOption = this.connOption.getOriginalConnOption();
        if (originalConnOption.sslServerCertDN != null) {
            return this.verifyConfiguredDN(serverCertificate, originalConnOption.sslServerCertDN);
        }
        return this.verifyHostOrServiceName(serverCertificate);
    }

    private SecurityInformation.DNMatchStatus verifyConfiguredDN(X509Certificate serverCertificate, String dnToMatch) throws NetException, IOException {
        String serverCertDN = serverCertificate.getSubjectDN().getName();
        if (this.doFullDNMatch(serverCertDN, dnToMatch)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_CONFIG;
        }
        throw new NetException(17954, null, false, dnToMatch, serverCertDN);
    }

    private SecurityInformation.DNMatchStatus verifyHostOrServiceName(X509Certificate serverCertificate) throws NetException, IOException {
        ConnOption originalConnOption = this.connOption.getOriginalConnOption();
        String hostNameForDNMatch = this.connOption.host;
        String originalHostNameForDNMatch = originalConnOption.host;
        if (this.matchCNAndSANs(serverCertificate, hostNameForDNMatch) || this.matchCNAndSANs(serverCertificate, originalHostNameForDNMatch)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_HOSTNAME;
        }
        boolean isAllowWeakDNMatchEnabled = this.isWeakDNMatchAllowed();
        String originalServiceNameForDNMatch = originalConnOption.service_name;
        Object hostNameForError = Objects.equals(originalHostNameForDNMatch, hostNameForDNMatch) ? hostNameForDNMatch : originalHostNameForDNMatch + ", " + hostNameForDNMatch;
        if (!isAllowWeakDNMatchEnabled || originalServiceNameForDNMatch == null) {
            throw new NetException(17965, null, false, hostNameForError, this.getCNValue(serverCertificate), Optional.ofNullable(this.getDNSSubjectAlts(serverCertificate)).map(Arrays::toString).orElse("null"));
        }
        if (this.matchSANs(serverCertificate, originalServiceNameForDNMatch) || this.matchCN(serverCertificate, originalServiceNameForDNMatch)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_SERVICENAME;
        }
        throw new NetException(17966, null, false, hostNameForError, originalServiceNameForDNMatch, this.getCNValue(serverCertificate), Optional.ofNullable(this.getDNSSubjectAlts(serverCertificate)).map(Arrays::toString).orElse("null"));
    }

    private boolean doFullDNMatch(String serverDN, String matchDN) throws IOException {
        if (serverDN == null || matchDN == null) {
            return false;
        }
        try {
            LdapName serverLdapName = new LdapName(serverDN);
            LdapName userLdapName = new LdapName(matchDN);
            return serverLdapName.equals(userLdapName);
        }
        catch (InvalidNameException e) {
            throw new IOException(e);
        }
    }

    private boolean matchCNAndSANs(X509Certificate serverCertificate, String hostName) throws IOException {
        return hostName != null && (this.matchSANs(serverCertificate, hostName) || this.matchCN(serverCertificate, hostName));
    }

    private boolean matchCN(X509Certificate serverCert, String matchStr) throws IOException {
        String serverCN = this.getCNValue(serverCert);
        return this.compare(serverCN, matchStr);
    }

    private boolean matchSANs(X509Certificate serverCert, String matchStr) throws IOException {
        String[] altNames = this.getDNSSubjectAlts(serverCert);
        if (altNames != null) {
            for (String altName : altNames) {
                if (!this.compare(altName, matchStr)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getDNSSubjectAlts(X509Certificate serverCert) throws IOException {
        try {
            LinkedList<String> subjectAltList = new LinkedList<String>();
            Collection<List<?>> altNames = serverCert.getSubjectAlternativeNames();
            if (altNames == null) {
                return null;
            }
            for (List<?> altName : altNames) {
                Integer type = (Integer)altName.get(0);
                if (type != 2 && type != 7) continue;
                subjectAltList.add((String)altName.get(1));
            }
            return subjectAltList.toArray(new String[subjectAltList.size()]);
        }
        catch (CertificateParsingException cpe) {
            throw new IOException(cpe);
        }
    }

    private String getCNValue(X509Certificate serverCert) throws IOException {
        try {
            return this.getCNValue(new LdapName(serverCert.getSubjectDN().getName()));
        }
        catch (InvalidNameException invalidNameException) {
            throw new IOException(invalidNameException);
        }
    }

    private String getCNValue(LdapName ldapName) {
        for (Rdn rdn : ldapName.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            return (String)rdn.getValue();
        }
        return null;
    }

    private boolean compare(String certValue, String matchValue) {
        String matchValRemaining;
        String certValRemaining;
        if ((certValue = certValue.toLowerCase()).equals(matchValue = matchValue.toLowerCase())) {
            return true;
        }
        int certLeftLblEndIndex = certValue.indexOf(46);
        int matchLeftLblEndIndex = matchValue.indexOf(46);
        if (certLeftLblEndIndex > 0 && matchLeftLblEndIndex > 0 && (certValRemaining = certValue.substring(certLeftLblEndIndex)).equals(matchValRemaining = matchValue.substring(matchLeftLblEndIndex))) {
            String certValLeftLbl = certValue.substring(0, certLeftLblEndIndex);
            String matchValLeftLbl = matchValue.substring(0, matchLeftLblEndIndex);
            return this.wildcardCompare(certValLeftLbl, matchValLeftLbl);
        }
        return false;
    }

    private boolean wildcardCompare(String certLftLbl, String matchLftLbl) {
        if (certLftLbl.equals("*")) {
            return !matchLftLbl.isEmpty();
        }
        int wildcardCharIndex = certLftLbl.indexOf(42);
        if (wildcardCharIndex == -1) {
            return false;
        }
        if (wildcardCharIndex == certLftLbl.length() - 1) {
            return matchLftLbl.startsWith(certLftLbl.substring(0, certLftLbl.length() - 1));
        }
        if (wildcardCharIndex == 0) {
            return matchLftLbl.endsWith(certLftLbl.substring(1));
        }
        String startPattern = certLftLbl.substring(0, wildcardCharIndex);
        String endPattern = certLftLbl.substring(wildcardCharIndex + 1);
        return matchLftLbl.startsWith(startPattern) && matchLftLbl.endsWith(endPattern);
    }
}

