/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Function;

public final class OpaqueString
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 4343640747510L;
    public static final OpaqueString NULL = new OpaqueString((String)null);
    public static final OpaqueString EMPTY = new OpaqueString("");
    private char[] c;
    private final int superHashCode = super.hashCode();

    public static OpaqueString newOpaqueString(char[] ch) {
        if (ch == null) {
            return NULL;
        }
        if (ch.length == 0) {
            return EMPTY;
        }
        return new OpaqueString(ch);
    }

    public static OpaqueString newOpaqueString(String s) {
        if (s == null) {
            return NULL;
        }
        if ("".equals(s)) {
            return EMPTY;
        }
        return new OpaqueString(s);
    }

    private OpaqueString(String s) {
        if (s == null) {
            this.c = null;
        } else {
            this.c = s.toCharArray();
            OpaqueString.xor(this.c, this.c, this.superHashCode + this.getClass().hashCode());
        }
    }

    private OpaqueString(char[] ch) {
        if (ch == null) {
            this.c = null;
        } else {
            try {
                this.c = new char[ch.length];
                OpaqueString.xor(ch, this.c, this.superHashCode + this.getClass().hashCode());
            }
            finally {
                Arrays.fill(ch, '\u0000');
            }
        }
    }

    public String get() {
        if (this.c == null) {
            return null;
        }
        return this.map(String::new);
    }

    public char[] getChars() {
        if (this.c == null) {
            return null;
        }
        char[] clearText = new char[this.c.length];
        OpaqueString.xor(this.c, clearText, this.superHashCode + this.getClass().hashCode());
        return clearText;
    }

    @Override
    public void close() {
        Random rand = new Random();
        for (int i = 0; i < this.c.length; ++i) {
            this.c[i] = (char)(this.c[i] ^ (char)rand.nextInt());
        }
    }

    public boolean isNull() {
        return this.c == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T map(Function<char[], T> mapper) {
        if (this.c == null) {
            return mapper.apply(null);
        }
        char[] clearText = new char[this.c.length];
        try {
            OpaqueString.xor(this.c, clearText, this.superHashCode + this.getClass().hashCode());
            T t = mapper.apply(clearText);
            return t;
        }
        finally {
            Arrays.fill(clearText, '\u0000');
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        short[] sh;
        if (this.c == null) {
            sh = null;
        } else {
            sh = new short[this.c.length * 2];
            for (int i = 0; i < this.c.length; ++i) {
                sh[i] = (short)this.c[i];
            }
            Random rand = new Random(this.superHashCode + this.getClass().hashCode());
            for (int i = this.c.length; i < sh.length; ++i) {
                sh[i] = (short)rand.nextInt();
            }
        }
        oos.writeObject(sh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        short[] sh = (short[])ois.readObject();
        if (sh == null) {
            this.c = null;
        } else {
            char[] clearText = new char[sh.length / 2];
            try {
                for (int i = 0; i < clearText.length; ++i) {
                    clearText[i] = (char)(sh[i] ^ sh[i + clearText.length]);
                }
                this.c = new char[clearText.length];
                OpaqueString.xor(clearText, this.c, this.superHashCode + this.getClass().hashCode());
            }
            finally {
                Arrays.fill(clearText, '\u0000');
            }
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpaqueString)) {
            return false;
        }
        OpaqueString other = (OpaqueString)obj;
        if (this.c == null || other.c == null) {
            return this.c == other.c;
        }
        if (this.c.length != other.c.length) {
            return false;
        }
        Random rand = new Random(this.superHashCode + this.getClass().hashCode());
        Random otherRand = new Random(other.superHashCode + other.getClass().hashCode());
        for (int i = 0; i < this.c.length; ++i) {
            char otherChar;
            char thisChar = (char)(this.c[i] ^ rand.nextInt());
            if (thisChar == (otherChar = (char)(other.c[i] ^ otherRand.nextInt()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.c == null || this.c.length == 0) {
            return 0;
        }
        return this.map(clearText -> {
            int hash = 0;
            for (int i = 0; i < ((char[])clearText).length; ++i) {
                hash = 31 * hash + clearText[i];
            }
            return hash;
        });
    }

    public oracle.jdbc.internal.OpaqueString toJDBCOpaqueString() {
        return this.map(oracle.jdbc.internal.OpaqueString::newOpaqueString);
    }

    private static void xor(char[] input, char[] output, int seed) {
        assert (input.length == output.length) : "Input and output are different lengths. input.length: " + input.length + " output.length: " + output.length;
        Random rand = new Random(seed);
        for (int i = 0; i < output.length; ++i) {
            output[i] = (char)(input[i] ^ rand.nextInt());
        }
    }
}

