/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.index.mapper.FieldValueFetcher;
import org.opensearch.index.mapper.MappedFieldType;

public class SortedNumericDocValuesFetcher
extends FieldValueFetcher {
    public SortedNumericDocValuesFetcher(MappedFieldType mappedFieldType, String SimpleName) {
        super(SimpleName);
        this.mappedFieldType = mappedFieldType;
    }

    @Override
    public List<Object> fetch(LeafReader reader, int docId) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            SortedNumericDocValues sortedNumericDocValues = reader.getSortedNumericDocValues(this.mappedFieldType.name());
            if (sortedNumericDocValues == null || !sortedNumericDocValues.advanceExact(docId)) {
                return values;
            }
            for (int i = 0; i < sortedNumericDocValues.docValueCount(); ++i) {
                values.add(sortedNumericDocValues.nextValue());
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to read doc values for document " + docId + " in field " + this.mappedFieldType.name(), e);
        }
        return values;
    }

    @Override
    public Object convert(Object value) {
        return this.mappedFieldType.valueForDisplay(value);
    }
}

