/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningInputTextReference;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningInputTextReferenceListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAutomatedReasoningTranslation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAutomatedReasoningTranslation> {
    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> PREMISES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("premises").getter(GuardrailAutomatedReasoningTranslation.getter(GuardrailAutomatedReasoningTranslation::premises)).setter(GuardrailAutomatedReasoningTranslation.setter(Builder::premises)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("premises").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("claims").getter(GuardrailAutomatedReasoningTranslation.getter(GuardrailAutomatedReasoningTranslation::claims)).setter(GuardrailAutomatedReasoningTranslation.setter(Builder::claims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningInputTextReference>> UNTRANSLATED_PREMISES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("untranslatedPremises").getter(GuardrailAutomatedReasoningTranslation.getter(GuardrailAutomatedReasoningTranslation::untranslatedPremises)).setter(GuardrailAutomatedReasoningTranslation.setter(Builder::untranslatedPremises)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedPremises").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningInputTextReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningInputTextReference>> UNTRANSLATED_CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("untranslatedClaims").getter(GuardrailAutomatedReasoningTranslation.getter(GuardrailAutomatedReasoningTranslation::untranslatedClaims)).setter(GuardrailAutomatedReasoningTranslation.setter(Builder::untranslatedClaims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedClaims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningInputTextReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("confidence").getter(GuardrailAutomatedReasoningTranslation.getter(GuardrailAutomatedReasoningTranslation::confidence)).setter(GuardrailAutomatedReasoningTranslation.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREMISES_FIELD, CLAIMS_FIELD, UNTRANSLATED_PREMISES_FIELD, UNTRANSLATED_CLAIMS_FIELD, CONFIDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAutomatedReasoningTranslation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailAutomatedReasoningStatement> premises;
    private final List<GuardrailAutomatedReasoningStatement> claims;
    private final List<GuardrailAutomatedReasoningInputTextReference> untranslatedPremises;
    private final List<GuardrailAutomatedReasoningInputTextReference> untranslatedClaims;
    private final Double confidence;

    private GuardrailAutomatedReasoningTranslation(BuilderImpl builder) {
        this.premises = builder.premises;
        this.claims = builder.claims;
        this.untranslatedPremises = builder.untranslatedPremises;
        this.untranslatedClaims = builder.untranslatedClaims;
        this.confidence = builder.confidence;
    }

    public final boolean hasPremises() {
        return this.premises != null && !(this.premises instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningStatement> premises() {
        return this.premises;
    }

    public final boolean hasClaims() {
        return this.claims != null && !(this.claims instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningStatement> claims() {
        return this.claims;
    }

    public final boolean hasUntranslatedPremises() {
        return this.untranslatedPremises != null && !(this.untranslatedPremises instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningInputTextReference> untranslatedPremises() {
        return this.untranslatedPremises;
    }

    public final boolean hasUntranslatedClaims() {
        return this.untranslatedClaims != null && !(this.untranslatedClaims instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningInputTextReference> untranslatedClaims() {
        return this.untranslatedClaims;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPremises() ? this.premises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClaims() ? this.claims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUntranslatedPremises() ? this.untranslatedPremises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUntranslatedClaims() ? this.untranslatedClaims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningTranslation)) {
            return false;
        }
        GuardrailAutomatedReasoningTranslation other = (GuardrailAutomatedReasoningTranslation)obj;
        return this.hasPremises() == other.hasPremises() && Objects.equals(this.premises(), other.premises()) && this.hasClaims() == other.hasClaims() && Objects.equals(this.claims(), other.claims()) && this.hasUntranslatedPremises() == other.hasUntranslatedPremises() && Objects.equals(this.untranslatedPremises(), other.untranslatedPremises()) && this.hasUntranslatedClaims() == other.hasUntranslatedClaims() && Objects.equals(this.untranslatedClaims(), other.untranslatedClaims()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAutomatedReasoningTranslation").add("Premises", this.hasPremises() ? this.premises() : null).add("Claims", this.hasClaims() ? this.claims() : null).add("UntranslatedPremises", this.hasUntranslatedPremises() ? this.untranslatedPremises() : null).add("UntranslatedClaims", this.hasUntranslatedClaims() ? this.untranslatedClaims() : null).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "premises": {
                return Optional.ofNullable(clazz.cast(this.premises()));
            }
            case "claims": {
                return Optional.ofNullable(clazz.cast(this.claims()));
            }
            case "untranslatedPremises": {
                return Optional.ofNullable(clazz.cast(this.untranslatedPremises()));
            }
            case "untranslatedClaims": {
                return Optional.ofNullable(clazz.cast(this.untranslatedClaims()));
            }
            case "confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("premises", PREMISES_FIELD);
        map.put("claims", CLAIMS_FIELD);
        map.put("untranslatedPremises", UNTRANSLATED_PREMISES_FIELD);
        map.put("untranslatedClaims", UNTRANSLATED_CLAIMS_FIELD);
        map.put("confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningTranslation, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningTranslation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailAutomatedReasoningStatement> premises = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAutomatedReasoningStatement> claims = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAutomatedReasoningInputTextReference> untranslatedPremises = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAutomatedReasoningInputTextReference> untranslatedClaims = DefaultSdkAutoConstructList.getInstance();
        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningTranslation model) {
            this.premises(model.premises);
            this.claims(model.claims);
            this.untranslatedPremises(model.untranslatedPremises);
            this.untranslatedClaims(model.untranslatedClaims);
            this.confidence(model.confidence);
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getPremises() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier.copyToBuilder(this.premises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremises(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(premises);
        }

        @Override
        public final Builder premises(Collection<GuardrailAutomatedReasoningStatement> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copy(premises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(GuardrailAutomatedReasoningStatement ... premises) {
            this.premises(Arrays.asList(premises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... premises) {
            this.premises(Stream.of(premises).map(c -> (GuardrailAutomatedReasoningStatement)((GuardrailAutomatedReasoningStatement.Builder)GuardrailAutomatedReasoningStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getClaims() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier.copyToBuilder(this.claims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClaims(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(claims);
        }

        @Override
        public final Builder claims(Collection<GuardrailAutomatedReasoningStatement> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copy(claims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(GuardrailAutomatedReasoningStatement ... claims) {
            this.claims(Arrays.asList(claims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... claims) {
            this.claims(Stream.of(claims).map(c -> (GuardrailAutomatedReasoningStatement)((GuardrailAutomatedReasoningStatement.Builder)GuardrailAutomatedReasoningStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningInputTextReference.Builder> getUntranslatedPremises() {
            List<GuardrailAutomatedReasoningInputTextReference.Builder> result = GuardrailAutomatedReasoningInputTextReferenceListCopier.copyToBuilder(this.untranslatedPremises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedPremises(Collection<GuardrailAutomatedReasoningInputTextReference.BuilderImpl> untranslatedPremises) {
            this.untranslatedPremises = GuardrailAutomatedReasoningInputTextReferenceListCopier.copyFromBuilder(untranslatedPremises);
        }

        @Override
        public final Builder untranslatedPremises(Collection<GuardrailAutomatedReasoningInputTextReference> untranslatedPremises) {
            this.untranslatedPremises = GuardrailAutomatedReasoningInputTextReferenceListCopier.copy(untranslatedPremises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(GuardrailAutomatedReasoningInputTextReference ... untranslatedPremises) {
            this.untranslatedPremises(Arrays.asList(untranslatedPremises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(Consumer<GuardrailAutomatedReasoningInputTextReference.Builder> ... untranslatedPremises) {
            this.untranslatedPremises(Stream.of(untranslatedPremises).map(c -> (GuardrailAutomatedReasoningInputTextReference)((GuardrailAutomatedReasoningInputTextReference.Builder)GuardrailAutomatedReasoningInputTextReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningInputTextReference.Builder> getUntranslatedClaims() {
            List<GuardrailAutomatedReasoningInputTextReference.Builder> result = GuardrailAutomatedReasoningInputTextReferenceListCopier.copyToBuilder(this.untranslatedClaims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedClaims(Collection<GuardrailAutomatedReasoningInputTextReference.BuilderImpl> untranslatedClaims) {
            this.untranslatedClaims = GuardrailAutomatedReasoningInputTextReferenceListCopier.copyFromBuilder(untranslatedClaims);
        }

        @Override
        public final Builder untranslatedClaims(Collection<GuardrailAutomatedReasoningInputTextReference> untranslatedClaims) {
            this.untranslatedClaims = GuardrailAutomatedReasoningInputTextReferenceListCopier.copy(untranslatedClaims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(GuardrailAutomatedReasoningInputTextReference ... untranslatedClaims) {
            this.untranslatedClaims(Arrays.asList(untranslatedClaims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(Consumer<GuardrailAutomatedReasoningInputTextReference.Builder> ... untranslatedClaims) {
            this.untranslatedClaims(Stream.of(untranslatedClaims).map(c -> (GuardrailAutomatedReasoningInputTextReference)((GuardrailAutomatedReasoningInputTextReference.Builder)GuardrailAutomatedReasoningInputTextReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public GuardrailAutomatedReasoningTranslation build() {
            return new GuardrailAutomatedReasoningTranslation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAutomatedReasoningTranslation> {
        public Builder premises(Collection<GuardrailAutomatedReasoningStatement> var1);

        public Builder premises(GuardrailAutomatedReasoningStatement ... var1);

        public Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... var1);

        public Builder claims(Collection<GuardrailAutomatedReasoningStatement> var1);

        public Builder claims(GuardrailAutomatedReasoningStatement ... var1);

        public Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... var1);

        public Builder untranslatedPremises(Collection<GuardrailAutomatedReasoningInputTextReference> var1);

        public Builder untranslatedPremises(GuardrailAutomatedReasoningInputTextReference ... var1);

        public Builder untranslatedPremises(Consumer<GuardrailAutomatedReasoningInputTextReference.Builder> ... var1);

        public Builder untranslatedClaims(Collection<GuardrailAutomatedReasoningInputTextReference> var1);

        public Builder untranslatedClaims(GuardrailAutomatedReasoningInputTextReference ... var1);

        public Builder untranslatedClaims(Consumer<GuardrailAutomatedReasoningInputTextReference.Builder> ... var1);

        public Builder confidence(Double var1);
    }
}

