/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.evaluation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.evaluation.ConfusionMatrix;
import org.tribuo.classification.evaluation.LabelEvaluation;
import org.tribuo.classification.evaluation.LabelEvaluationUtil;
import org.tribuo.classification.evaluation.LabelMetric;
import org.tribuo.classification.evaluation.LabelMetrics;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.provenance.EvaluationProvenance;

final class LabelEvaluationImpl
implements LabelEvaluation {
    private final Map<MetricID<Label>, Double> results;
    private final LabelMetric.Context context;
    private final boolean modelGeneratesProbabilities;
    private final ConfusionMatrix<Label> cm;
    private final EvaluationProvenance provenance;

    LabelEvaluationImpl(Map<MetricID<Label>, Double> results, LabelMetric.Context context, EvaluationProvenance provenance) {
        this.results = results;
        this.context = context;
        this.provenance = provenance;
        this.modelGeneratesProbabilities = context.getModel().generatesProbabilities();
        this.cm = context.getCM();
    }

    public List<Prediction<Label>> getPredictions() {
        return this.context.getPredictions();
    }

    public Map<MetricID<Label>, Double> asMap() {
        return Collections.unmodifiableMap(this.results);
    }

    @Override
    public double averagedPrecision(Label label) {
        if (!this.modelGeneratesProbabilities) {
            throw new UnsupportedOperationException("averaged precision score not available for models that do not generate probabilities");
        }
        return this.get(label, LabelMetrics.AVERAGED_PRECISION);
    }

    @Override
    public LabelEvaluationUtil.PRCurve precisionRecallCurve(Label label) {
        return LabelMetrics.precisionRecallCurve(label, this.context.getPredictions());
    }

    @Override
    public double AUCROC(Label label) {
        if (!this.modelGeneratesProbabilities) {
            throw new UnsupportedOperationException("AUCROC score not available for models that do not generate probabilities");
        }
        return this.get(label, LabelMetrics.AUCROC);
    }

    @Override
    public double averageAUCROC(boolean weighted) {
        if (!this.modelGeneratesProbabilities) {
            throw new UnsupportedOperationException("AUCROC score not available for models that do not generate probabilities");
        }
        double sum = 0.0;
        double weightSum = 0.0;
        for (Label l : this.cm.getDomain().getDomain()) {
            double currentValue = this.get(l, LabelMetrics.AUCROC);
            double currentWeight = weighted ? this.cm.support(l) : 1.0;
            sum += currentWeight * currentValue;
            weightSum += currentWeight;
        }
        return sum / weightSum;
    }

    @Override
    public double confusion(Label predictedLabel, Label trueLabel) {
        return this.cm.confusion(predictedLabel, trueLabel);
    }

    @Override
    public double tp(Label label) {
        return this.get(label, LabelMetrics.TP);
    }

    @Override
    public double tp() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.TP);
    }

    @Override
    public double macroTP() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.TP);
    }

    @Override
    public double fp(Label label) {
        return this.get(label, LabelMetrics.FP);
    }

    @Override
    public double fp() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.FP);
    }

    @Override
    public double macroFP() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.FP);
    }

    @Override
    public double tn(Label label) {
        return this.get(label, LabelMetrics.TN);
    }

    @Override
    public double tn() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.TN);
    }

    @Override
    public double macroTN() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.TN);
    }

    @Override
    public double fn(Label label) {
        return this.get(label, LabelMetrics.FN);
    }

    @Override
    public double fn() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.FN);
    }

    @Override
    public double macroFN() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.FN);
    }

    @Override
    public double precision(Label label) {
        return this.get(label, LabelMetrics.PRECISION);
    }

    @Override
    public double microAveragedPrecision() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.PRECISION);
    }

    @Override
    public double macroAveragedPrecision() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.PRECISION);
    }

    @Override
    public double recall(Label label) {
        return this.get(label, LabelMetrics.RECALL);
    }

    @Override
    public double microAveragedRecall() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.RECALL);
    }

    @Override
    public double macroAveragedRecall() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.RECALL);
    }

    @Override
    public double f1(Label label) {
        return this.get(label, LabelMetrics.F1);
    }

    @Override
    public double microAveragedF1() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.F1);
    }

    @Override
    public double macroAveragedF1() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.F1);
    }

    @Override
    public double accuracy() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.ACCURACY);
    }

    @Override
    public double accuracy(Label label) {
        return this.get(label, LabelMetrics.ACCURACY);
    }

    @Override
    public double balancedErrorRate() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.BALANCED_ERROR_RATE);
    }

    @Override
    public ConfusionMatrix<Label> getConfusionMatrix() {
        return this.cm;
    }

    public EvaluationProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return LabelEvaluation.toFormattedString(this);
    }

    private double get(MetricTarget<Label> tgt, LabelMetrics metric) {
        return this.get(metric.forTarget(tgt).getID());
    }

    private double get(Label label, LabelMetrics metric) {
        return this.get(metric.forTarget((MetricTarget<Label>)new MetricTarget((Output)label)).getID());
    }

    private double get(EvaluationMetric.Average avg, LabelMetrics metric) {
        return this.get(metric.forTarget((MetricTarget<Label>)new MetricTarget(avg)).getID());
    }
}

