/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence.viterbi;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.sequence.viterbi.LabelFeatureExtractor;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceExample;
import org.tribuo.sequence.SequenceModel;

public class ViterbiModel
extends SequenceModel<Label> {
    private static final long serialVersionUID = 1L;
    private final Model<Label> model;
    private final LabelFeatureExtractor labelFeatureExtractor;
    private final int stackSize;
    private final ScoreAggregation scoreAggregation;

    ViterbiModel(String name, ModelProvenance description, Model<Label> model, LabelFeatureExtractor labelFeatureExtractor, int stackSize, ScoreAggregation scoreAggregation) {
        super(name, description, model.getFeatureIDMap(), model.getOutputIDInfo());
        this.model = model;
        this.labelFeatureExtractor = labelFeatureExtractor;
        this.stackSize = stackSize;
        this.scoreAggregation = scoreAggregation;
    }

    public List<List<Prediction<Label>>> predict(SequenceDataset<Label> examples) {
        ArrayList<List<Prediction<Label>>> predictions = new ArrayList<List<Prediction<Label>>>();
        for (SequenceExample e : examples) {
            predictions.add(this.predict((SequenceExample<Label>)e));
        }
        return predictions;
    }

    public List<Prediction<Label>> predict(SequenceExample<Label> examples) {
        if (this.stackSize == 1) {
            ArrayList<Label> labels = new ArrayList<Label>();
            ArrayList<Prediction<Label>> returnValues = new ArrayList<Prediction<Label>>();
            for (Example example : examples) {
                List<Feature> labelFeatures = this.extractFeatures(labels);
                example.addAll(labelFeatures);
                Prediction prediction = this.model.predict(example);
                labels.add((Label)prediction.getOutput());
                returnValues.add((Prediction<Label>)prediction);
            }
            return returnValues;
        }
        return this.viterbi(examples);
    }

    private List<Feature> extractFeatures(List<Label> labels) {
        ArrayList<Feature> labelFeatures = new ArrayList<Feature>();
        for (Feature labelFeature : this.labelFeatureExtractor.extractFeatures(labels, 1.0)) {
            int id = this.featureIDMap.getID(labelFeature.getName());
            if (id <= -1) continue;
            labelFeatures.add(labelFeature);
        }
        return labelFeatures;
    }

    private List<Prediction<Label>> viterbi(SequenceExample<Label> examples) {
        Collection<Object> paths = null;
        int[] numUsed = new int[examples.size()];
        int i = 0;
        for (Example example : examples) {
            if (paths == null) {
                paths = new ArrayList();
                Prediction prediction = this.model.predict(example);
                numUsed[i] = prediction.getNumActiveFeatures();
                Map distribution = prediction.getOutputScores();
                for (Label label : this.getTopLabels(distribution)) {
                    paths.add(new Path(label, label.getScore(), null));
                }
            } else {
                HashMap<Label, Path> maxPaths = new HashMap<Label, Path>();
                for (Path path : paths) {
                    Example clonedExample = example.copy();
                    ArrayList<Label> previousLabels = new ArrayList<Label>(path.labels);
                    List<Feature> labelFeatures = this.extractFeatures(previousLabels);
                    clonedExample.addAll(labelFeatures);
                    Prediction prediction = this.model.predict(clonedExample);
                    numUsed[i] = prediction.getNumActiveFeatures();
                    Map distribution = prediction.getOutputScores();
                    for (Label label : this.getTopLabels(distribution)) {
                        double labelScore = label.getScore();
                        double score = this.scoreAggregation == ScoreAggregation.ADD ? path.score + labelScore : path.score * labelScore;
                        Path maxPath = (Path)maxPaths.get(label);
                        if (maxPath != null && !(score > maxPath.score)) continue;
                        maxPaths.put(label, new Path(label, score, path));
                    }
                }
                paths = maxPaths.values();
            }
            ++i;
        }
        Path maxPath = (Path)Collections.max(paths);
        ArrayList<Prediction<Label>> output = new ArrayList<Prediction<Label>>();
        for (int j = 0; j < examples.size(); ++j) {
            Example e = examples.get(j);
            output.add((Prediction<Label>)new Prediction((Output)maxPath.labels.get(j), numUsed[j], e));
        }
        return output;
    }

    protected List<Label> getTopLabels(Map<String, Label> distribution) {
        return ViterbiModel.getTopLabels(distribution, this.stackSize);
    }

    protected static List<Label> getTopLabels(Map<String, Label> distribution, int stackSize) {
        return distribution.values().stream().sorted(Comparator.comparingDouble(Label::getScore).reversed()).limit(stackSize).collect(Collectors.toList());
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public ScoreAggregation getScoreAggregation() {
        return this.scoreAggregation;
    }

    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return this.model.getTopFeatures(n);
    }

    private static class Path
    implements Comparable<Path> {
        public final double score;
        public final Path parent;
        public final List<Label> labels;

        public Path(Label label, double score, Path parent) {
            this.score = score;
            this.parent = parent;
            this.labels = new ArrayList<Label>();
            if (this.parent != null) {
                this.labels.addAll(this.parent.labels);
            }
            this.labels.add(label);
        }

        @Override
        public int compareTo(Path that) {
            return Double.compare(this.score, that.score);
        }
    }

    public static enum ScoreAggregation {
        ADD,
        MULTIPLY;

    }
}

