/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.MapProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.TrainerProvenance;

public class ModelProvenance
implements ObjectProvenance {
    private static final long serialVersionUID = 1L;
    protected static final String DATASET = "dataset";
    protected static final String TRAINER = "trainer";
    protected static final String TRAINING_TIME = "trained-at";
    protected static final String INSTANCE_VALUES = "instance-values";
    protected static final String TRIBUO_VERSION_STRING = "tribuo-version";
    protected static final String JAVA_VERSION_STRING = "java-version";
    protected static final String OS_STRING = "os-name";
    protected static final String ARCH_STRING = "os-arch";
    protected static final String UNKNOWN_VERSION = "unknown-version";
    protected final String className;
    protected final OffsetDateTime time;
    protected final DatasetProvenance datasetProvenance;
    protected final TrainerProvenance trainerProvenance;
    protected final MapProvenance<? extends Provenance> instanceProvenance;
    protected final String versionString;
    protected final String javaVersionString;
    protected final String osString;
    protected final String archString;

    public ModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance) {
        this(className, time, datasetProvenance, trainerProvenance, Collections.emptyMap());
    }

    public ModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance, Map<String, Provenance> instanceProvenance) {
        this(className, time, datasetProvenance, trainerProvenance, instanceProvenance, true);
    }

    public ModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance, Map<String, Provenance> instanceProvenance, boolean trackSystem) {
        this.className = className;
        this.time = time;
        this.datasetProvenance = datasetProvenance;
        this.trainerProvenance = trainerProvenance;
        this.instanceProvenance = instanceProvenance.isEmpty() ? new MapProvenance() : new MapProvenance(instanceProvenance);
        this.versionString = "4.2.1";
        if (trackSystem) {
            this.javaVersionString = System.getProperty("java.version");
            this.osString = System.getProperty("os.name");
            this.archString = System.getProperty("os.arch");
        } else {
            this.javaVersionString = UNKNOWN_VERSION;
            this.osString = UNKNOWN_VERSION;
            this.archString = UNKNOWN_VERSION;
        }
    }

    public ModelProvenance(Map<String, Provenance> map) {
        this.className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)ModelProvenance.class.getSimpleName())).getValue();
        this.datasetProvenance = (DatasetProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DATASET, DatasetProvenance.class, (String)ModelProvenance.class.getSimpleName());
        this.trainerProvenance = (TrainerProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRAINER, TrainerProvenance.class, (String)ModelProvenance.class.getSimpleName());
        this.time = ((DateTimeProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRAINING_TIME, DateTimeProvenance.class, (String)ModelProvenance.class.getSimpleName())).getValue();
        this.instanceProvenance = (MapProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)INSTANCE_VALUES, MapProvenance.class, (String)ModelProvenance.class.getSimpleName());
        this.versionString = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRIBUO_VERSION_STRING, StringProvenance.class, (String)ModelProvenance.class.getSimpleName())).getValue();
        this.javaVersionString = ObjectProvenance.maybeExtractProvenance(map, (String)JAVA_VERSION_STRING, StringProvenance.class, (String)ModelProvenance.class.getSimpleName()).map(StringProvenance::getValue).orElse(UNKNOWN_VERSION);
        this.osString = ObjectProvenance.maybeExtractProvenance(map, (String)OS_STRING, StringProvenance.class, (String)ModelProvenance.class.getSimpleName()).map(StringProvenance::getValue).orElse(UNKNOWN_VERSION);
        this.archString = ObjectProvenance.maybeExtractProvenance(map, (String)ARCH_STRING, StringProvenance.class, (String)ModelProvenance.class.getSimpleName()).map(StringProvenance::getValue).orElse(UNKNOWN_VERSION);
    }

    public OffsetDateTime getTrainingTime() {
        return this.time;
    }

    public DatasetProvenance getDatasetProvenance() {
        return this.datasetProvenance;
    }

    public TrainerProvenance getTrainerProvenance() {
        return this.trainerProvenance;
    }

    public MapProvenance<? extends Provenance> getInstanceProvenance() {
        return this.instanceProvenance;
    }

    public String getTribuoVersion() {
        return this.versionString;
    }

    public String getJavaVersion() {
        return this.javaVersionString;
    }

    public String getOS() {
        return this.osString;
    }

    public String getArch() {
        return this.archString;
    }

    public String toString() {
        return this.generateString("Model");
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelProvenance)) {
            return false;
        }
        ModelProvenance pairs = (ModelProvenance)o;
        return this.className.equals(pairs.className) && this.time.equals(pairs.time) && this.datasetProvenance.equals(pairs.datasetProvenance) && this.trainerProvenance.equals(pairs.trainerProvenance) && this.instanceProvenance.equals(pairs.instanceProvenance) && this.versionString.equals(pairs.versionString) && this.javaVersionString.equals(pairs.javaVersionString) && this.osString.equals(pairs.osString) && this.archString.equals(pairs.archString);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.time, this.datasetProvenance, this.trainerProvenance, this.instanceProvenance, this.versionString);
    }

    protected List<Pair<String, Provenance>> internalProvenances() {
        ArrayList<Pair<String, Provenance>> iterable = new ArrayList<Pair<String, Provenance>>();
        iterable.add(new Pair((Object)"class-name", (Object)new StringProvenance("class-name", this.className)));
        iterable.add(new Pair((Object)DATASET, (Object)this.datasetProvenance));
        iterable.add(new Pair((Object)TRAINER, (Object)this.trainerProvenance));
        iterable.add(new Pair((Object)TRAINING_TIME, (Object)new DateTimeProvenance(TRAINING_TIME, this.time)));
        iterable.add(new Pair((Object)INSTANCE_VALUES, this.instanceProvenance));
        iterable.add(new Pair((Object)TRIBUO_VERSION_STRING, (Object)new StringProvenance(TRIBUO_VERSION_STRING, this.versionString)));
        iterable.add(new Pair((Object)JAVA_VERSION_STRING, (Object)new StringProvenance(JAVA_VERSION_STRING, this.javaVersionString)));
        iterable.add(new Pair((Object)OS_STRING, (Object)new StringProvenance(OS_STRING, this.osString)));
        iterable.add(new Pair((Object)ARCH_STRING, (Object)new StringProvenance(ARCH_STRING, this.archString)));
        return iterable;
    }

    public Iterator<Pair<String, Provenance>> iterator() {
        return this.internalProvenances().iterator();
    }
}

