/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarLog;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.HarUtils;
import org.zaproxy.zap.utils.ZapSupportUtils;

public class CoreAPI
extends ApiImplementor
implements SessionListener {
    private static final Logger LOGGER = LogManager.getLogger(CoreAPI.class);
    private static final String PREFIX = "core";
    private static final String ACTION_LOAD_SESSION = "loadSession";
    private static final String ACTION_NEW_SESSION = "newSession";
    private static final String ACTION_SAVE_SESSION = "saveSession";
    private static final String ACTION_SNAPSHOT_SESSION = "snapshotSession";
    private static final String ACTION_ACCESS_URL = "accessUrl";
    private static final String ACTION_SHUTDOWN = "shutdown";
    private static final String ACTION_EXCLUDE_FROM_PROXY = "excludeFromProxy";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_PROXY = "clearExcludedFromProxy";
    private static final String ACTION_SET_HOME_DIRECTORY = "setHomeDirectory";
    private static final String ACTION_GENERATE_ROOT_CA = "generateRootCA";
    private static final String ACTION_SEND_REQUEST = "sendRequest";
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_DELETE_ALERT = "deleteAlert";
    private static final String ACTION_COLLECT_GARBAGE = "runGarbageCollection";
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_DELETE_SITE_NODE = "deleteSiteNode";
    private static final String ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN = "addProxyChainExcludedDomain";
    private static final String ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN = "modifyProxyChainExcludedDomain";
    private static final String ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN = "removeProxyChainExcludedDomain";
    private static final String ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS = "enableAllProxyChainExcludedDomains";
    private static final String ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS = "disableAllProxyChainExcludedDomains";
    private static final String ACTION_OPTION_MAXIMUM_ALERT_INSTANCES = "setOptionMaximumAlertInstances";
    private static final String ACTION_OPTION_MERGE_RELATED_ALERTS = "setOptionMergeRelatedAlerts";
    private static final String ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH = "setOptionAlertOverridesFilePath";
    private static final String ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE = "enablePKCS12ClientCertificate";
    private static final String ACTION_DISABLE_CLIENT_CERTIFICATE = "disableClientCertificate";
    private static final String ACTION_CREATE_SBOM_ZIP = "createSbomZip";
    private static final String ACTION_LOGGING = "setLogLevel";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_ALERTS_SUMMARY = "alertsSummary";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_HOSTS = "hosts";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_URLS = "urls";
    private static final String VIEW_CHILD_NODES = "childNodes";
    private static final String VIEW_MESSAGE = "message";
    private static final String VIEW_MESSAGES = "messages";
    private static final String VIEW_MESSAGES_BY_ID = "messagesById";
    private static final String VIEW_MODE = "mode";
    private static final String VIEW_NUMBER_OF_MESSAGES = "numberOfMessages";
    private static final String VIEW_VERSION = "version";
    private static final String VIEW_EXCLUDED_FROM_PROXY = "excludedFromProxy";
    private static final String VIEW_HOME_DIRECTORY = "homeDirectory";
    private static final String VIEW_SESSION_LOCATION = "sessionLocation";
    private static final String VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS = "proxyChainExcludedDomains";
    private static final String VIEW_OPTION_PROXY_CHAIN_SKIP_NAME = "optionProxyChainSkipName";
    private static final String VIEW_OPTION_PROXY_EXCLUDED_DOMAINS = "optionProxyExcludedDomains";
    private static final String VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED = "optionProxyExcludedDomainsEnabled";
    private static final String VIEW_ZAP_HOME_PATH = "zapHomePath";
    private static final String VIEW_OPTION_MAXIMUM_ALERT_INSTANCES = "optionMaximumAlertInstances";
    private static final String VIEW_OPTION_MERGE_RELATED_ALERTS = "optionMergeRelatedAlerts";
    private static final String VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH = "optionAlertOverridesFilePath";
    private static final String VIEW_LOGGING = "getLogLevel";
    private static final String OTHER_PROXY_PAC = "proxy.pac";
    private static final String OTHER_SET_PROXY = "setproxy";
    private static final String OTHER_ROOT_CERT = "rootcert";
    private static final String OTHER_XML_REPORT = "xmlreport";
    private static final String OTHER_HTML_REPORT = "htmlreport";
    private static final String OTHER_JSON_REPORT = "jsonreport";
    private static final String OTHER_MD_REPORT = "mdreport";
    private static final String OTHER_MESSAGE_HAR = "messageHar";
    private static final String OTHER_MESSAGES_HAR = "messagesHar";
    private static final String OTHER_MESSAGES_HAR_BY_ID = "messagesHarById";
    private static final String OTHER_SEND_HAR_REQUEST = "sendHarRequest";
    private static final String OTHER_SCRIPT_JS = "script.js";
    private static final String OTHER_FILE_DOWNLOAD = "fileDownload";
    private static final String OTHER_FILE_UPLOAD = "fileUpload";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_DIR = "dir";
    private static final String PARAM_SESSION = "name";
    private static final String PARAM_OVERWRITE_SESSION = "overwrite";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private static final String PARAM_PROXY_DETAILS = "proxy";
    private static final String PARAM_ID = "id";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_REQUEST = "request";
    private static final String PARAM_FOLLOW_REDIRECTS = "followRedirects";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_URL = "url";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_IS_REGEX = "isRegex";
    private static final String PARAM_IS_ENABLED = "isEnabled";
    private static final String PARAM_RISK = "riskId";
    private static final String PARAM_NUMBER_OF_INSTANCES = "numberOfInstances";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_FILE_PATH = "filePath";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_INDEX = "index";
    private static final String PARAM_FILENAME = "fileName";
    private static final String PARAM_CONTENTS = "fileContents";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_LEVEL = "logLevel";
    private static final List<String> PARAMS_STRING = Collections.singletonList("String");
    private static final List<String> PARAMS_BOOLEAN = Collections.singletonList("Boolean");
    private static final List<String> PARAMS_INTEGER = Collections.singletonList("Integer");
    protected static final int API_SCRIPT_VERSION = 2;
    private static final String API_SCRIPT = "function submitScript() {\n  var button=document.getElementById('button');\n  var component=button.getAttribute('zap-component')\n  var type=button.getAttribute('zap-type')\n  var name=button.getAttribute('zap-name')\n  var format\n  if (type == 'other') {\n    format = 'OTHER'\n  } else {\n    format = document.getElementById('zapapiformat').value\n  }\n  \n  var url = '/' + format + '/' + component + '/' + type + '/' + name + '/'\n  var form=document.getElementById('zapform');\n  form.action = url;\n  form.method = document.getElementById('formMethod').value;\n  form.submit();\n}\ndocument.addEventListener('DOMContentLoaded', function () {\n  var button=document.getElementById('button');\n  if (button) {\n    document.getElementById('button').addEventListener('click',  function(e) {submitScript();}, false);\n  }\n});\n";
    private static final String API_SCRIPT_CACHE_CONTROL = "max-age=86400";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private boolean savingSession = false;
    private static ExtensionHistory extHistory;

    @Deprecated
    public CoreAPI(ConnectionParam connectionParam) {
        this();
    }

    public CoreAPI() {
        this.addApiAction(new ApiAction(ACTION_ACCESS_URL, new String[]{PARAM_URL}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_SHUTDOWN));
        this.addApiAction(new ApiAction(ACTION_NEW_SESSION, null, new String[]{"name", PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_LOAD_SESSION, new String[]{"name"}));
        this.addApiAction(new ApiAction(ACTION_SAVE_SESSION, new String[]{"name"}, new String[]{PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SNAPSHOT_SESSION, null, new String[]{"name", PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_PROXY));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_PROXY, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_SET_HOME_DIRECTORY, new String[]{PARAM_DIR}));
        this.addApiAction(new ApiAction(ACTION_SET_MODE, new String[]{"mode"}));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_GENERATE_ROOT_CA)));
        this.addApiAction(new ApiAction(ACTION_SEND_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_COLLECT_GARBAGE));
        this.addApiAction(new ApiAction(ACTION_DELETE_SITE_NODE, new String[]{PARAM_URL}, new String[]{PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_VALUE}, new String[]{PARAM_IS_REGEX, PARAM_IS_ENABLED})));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_IDX}, new String[]{PARAM_VALUE, PARAM_IS_REGEX, PARAM_IS_ENABLED})));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_IDX})));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS)));
        this.addApiAction(new ApiAction(ACTION_OPTION_MAXIMUM_ALERT_INSTANCES, new String[]{PARAM_NUMBER_OF_INSTANCES}));
        this.addApiAction(new ApiAction(ACTION_OPTION_MERGE_RELATED_ALERTS, new String[]{PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH, null, new String[]{PARAM_FILE_PATH}));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE, new String[]{PARAM_FILE_PATH, PARAM_PASSWORD}, new String[]{PARAM_INDEX})));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction(ACTION_DISABLE_CLIENT_CERTIFICATE)));
        this.addApiAction(new ApiAction(ACTION_CREATE_SBOM_ZIP, new String[]{PARAM_FILE_PATH}, null));
        this.addApiAction(this.depreciatedAlertApi(new ApiAction(ACTION_DELETE_ALL_ALERTS)));
        this.addApiAction(this.depreciatedAlertApi(new ApiAction(ACTION_DELETE_ALERT, new String[]{PARAM_ID})));
        this.addApiAction(new ApiAction(ACTION_LOGGING, new String[]{"name", PARAM_LEVEL}));
        this.addApiView(new ApiView(VIEW_HOSTS));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_URLS, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_CHILD_NODES, null, new String[]{PARAM_URL}));
        this.addApiView(new ApiView(VIEW_MESSAGE, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_ID, new String[]{PARAM_IDS}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_MESSAGES, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView("mode"));
        this.addApiView(new ApiView(VIEW_VERSION));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_PROXY));
        this.addApiView(new ApiView(VIEW_SESSION_LOCATION));
        this.addApiView(this.deprecatedNetworkApi(new ApiView(VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS)));
        this.addApiView(new ApiView(VIEW_ZAP_HOME_PATH));
        this.addApiView(new ApiView(VIEW_OPTION_MAXIMUM_ALERT_INSTANCES));
        this.addApiView(new ApiView(VIEW_OPTION_MERGE_RELATED_ALERTS));
        this.addApiView(new ApiView(VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH));
        Stream.of(VIEW_HOME_DIRECTORY, VIEW_OPTION_PROXY_CHAIN_SKIP_NAME, VIEW_OPTION_PROXY_EXCLUDED_DOMAINS, VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED).map(ApiView::new).peek(t -> t.setDeprecated(true)).forEach(this::addApiView);
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERT, new String[]{PARAM_ID})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT, PARAM_RISK})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERTS_SUMMARY, null, new String[]{PARAM_BASE_URL})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_RISK})));
        this.addApiView(new ApiView(VIEW_LOGGING, new String[0], new String[]{"name"}));
        this.addApiOthers(this.deprecatedNetworkApi(new ApiOther(OTHER_PROXY_PAC, false)));
        this.addApiOthers(this.deprecatedNetworkApi(new ApiOther(OTHER_ROOT_CERT, false)));
        this.addApiOthers(this.deprecatedNetworkApi(new ApiOther(OTHER_SET_PROXY, new String[]{PARAM_PROXY_DETAILS})));
        this.addApiOthers(this.depreciatedReportApi(new ApiOther(OTHER_XML_REPORT)));
        this.addApiOthers(this.depreciatedReportApi(new ApiOther(OTHER_HTML_REPORT)));
        this.addApiOthers(this.depreciatedReportApi(new ApiOther(OTHER_JSON_REPORT)));
        this.addApiOthers(this.depreciatedReportApi(new ApiOther(OTHER_MD_REPORT)));
        this.addApiOthers(this.depreciatedEximApi(new ApiOther(OTHER_MESSAGE_HAR, new String[]{PARAM_ID})));
        this.addApiOthers(this.depreciatedEximApi(new ApiOther(OTHER_MESSAGES_HAR, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT})));
        this.addApiOthers(this.depreciatedEximApi(new ApiOther(OTHER_MESSAGES_HAR_BY_ID, new String[]{PARAM_IDS})));
        this.addApiOthers(this.depreciatedEximApi(new ApiOther(OTHER_SEND_HAR_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS})));
        this.addApiOthers(new ApiOther(OTHER_FILE_DOWNLOAD, new String[]{PARAM_FILENAME}));
        this.addApiOthers(new ApiOther(OTHER_FILE_UPLOAD, "POST", List.of(PARAM_FILENAME, PARAM_CONTENTS), List.of()));
        this.addApiShortcut(OTHER_SCRIPT_JS);
        Stream.of("optionDefaultUserAgent", "optionDnsTtlSuccessfulQueries", "optionHttpState", "optionHttpStateEnabled", "optionProxyChainName", "optionProxyChainPassword", "optionProxyChainPort", "optionProxyChainPrompt", "optionProxyChainRealm", "optionProxyChainUserName", "optionSingleCookieRequestHeader", "optionTimeoutInSecs", "optionUseProxyChain", "optionUseProxyChainAuth", "optionUseSocksProxy").forEach(name -> this.addApiView(this.deprecatedNetworkApi(new ApiView((String)name))));
        this.getApiView("optionSingleCookieRequestHeader").setDeprecatedDescription(Constant.messages.getString("api.deprecated.option.endpoint"));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionDefaultUserAgent", PARAMS_STRING)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionDnsTtlSuccessfulQueries", PARAMS_INTEGER)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionHttpStateEnabled", PARAMS_BOOLEAN)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainName", PARAMS_STRING)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainPassword", PARAMS_STRING)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainPort", PARAMS_INTEGER)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainPrompt", PARAMS_BOOLEAN)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainRealm", PARAMS_STRING)));
        this.addApiAction(this.depreciatedApi(new ApiAction("setOptionProxyChainSkipName", PARAMS_STRING), Constant.messages.getString("api.deprecated.option.endpoint")));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionProxyChainUserName", PARAMS_STRING)));
        this.addApiAction(this.depreciatedApi(new ApiAction("setOptionSingleCookieRequestHeader", PARAMS_BOOLEAN), Constant.messages.getString("api.deprecated.option.endpoint")));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionTimeoutInSecs", PARAMS_INTEGER)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionUseProxyChain", PARAMS_BOOLEAN)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionUseProxyChainAuth", PARAMS_BOOLEAN)));
        this.addApiAction(this.deprecatedNetworkApi(new ApiAction("setOptionUseSocksProxy", PARAMS_BOOLEAN)));
    }

    private <T extends ApiElement> T deprecatedNetworkApi(T element) {
        return this.depreciatedApi(element, Constant.messages.getString("core.api.deprecated.network"));
    }

    private <T extends ApiElement> T depreciatedAlertApi(T element) {
        return this.depreciatedApi(element, Constant.messages.getString("core.api.depreciated.alert"));
    }

    private <T extends ApiElement> T depreciatedReportApi(T element) {
        return this.depreciatedApi(element, Constant.messages.getString("core.api.depreciated.report"));
    }

    private <T extends ApiElement> T depreciatedEximApi(T element) {
        return this.depreciatedApi(element, Constant.messages.getString("core.api.deprecated.exim"));
    }

    private <T extends ApiElement> T depreciatedApi(T element, String description) {
        element.setDeprecated(true);
        element.setDeprecatedDescription(description);
        return element;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        Session session = Model.getSingleton().getSession();
        if (ACTION_ACCESS_URL.equals(name)) {
            URI uri;
            try {
                uri = new URI(params.getString(PARAM_URL), true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
            try {
                HttpMessage request = new HttpMessage(new HttpRequestHeader("GET", uri, "HTTP/1.1"));
                return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
        }
        if (ACTION_SHUTDOWN.equals(name)) {
            Thread thread = new Thread("ZAP-Shutdown"){

                @Override
                public void run() {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Control.getSingleton().shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                        LOGGER.info("{} terminated.", (Object)Constant.PROGRAM_TITLE);
                    }
                    catch (Throwable e) {
                        LOGGER.error("An error occurred while shutting down:", e);
                    }
                    finally {
                        System.exit(Control.getSingleton().getExitStatus());
                    }
                }
            };
            thread.start();
            return ApiResponseElement.OK;
        }
        if (ACTION_SAVE_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = CoreAPI.getSessionPath(params.getString("name"));
            String filename = sessionPath.toAbsolutePath().toString();
            boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
            if (Files.exists(sessionPath, new LinkOption[0])) {
                boolean sameSession = false;
                if (overwrite && !session.isNewState()) {
                    try {
                        sameSession = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), sessionPath);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to check if same session path:", (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                }
                if (!overwrite || sameSession) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
                }
            }
            this.savingSession = true;
            try {
                Control.getSingleton().saveSession(filename, this);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save the session:", (Throwable)e);
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            LOGGER.debug("Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_SNAPSHOT_SESSION.equalsIgnoreCase(name)) {
            if (session.isNewState()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            List<String> actions = Control.getSingleton().getExtensionLoader().getActiveActions();
            if (!actions.isEmpty()) {
                throw new ApiException(ApiException.Type.BAD_STATE, "Active actions prevent the session snapshot: " + String.valueOf(actions));
            }
            Object fileName = ApiUtils.getOptionalStringParam(params, "name");
            if (fileName == null || ((String)fileName).isEmpty()) {
                fileName = session.getFileName();
                if (((String)fileName).endsWith(".session")) {
                    fileName = ((String)fileName).substring(0, ((String)fileName).length() - 8);
                }
                fileName = (String)fileName + "-" + this.dateFormat.format(new Date()) + ".session";
            } else {
                Path sessionPath = CoreAPI.getSessionPath((String)fileName);
                fileName = sessionPath.toAbsolutePath().toString();
                if (Files.exists(sessionPath, new LinkOption[0])) {
                    boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
                    boolean sameSession = false;
                    try {
                        sameSession = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), sessionPath);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to check if same session path:", (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                    if (!overwrite || sameSession) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, (String)fileName);
                    }
                }
            }
            this.savingSession = true;
            try {
                Control.getSingleton().snapshotSession((String)fileName, this);
            }
            catch (Exception e) {
                LOGGER.error("Failed to snapshot the session:", (Throwable)e);
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            LOGGER.debug("Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = CoreAPI.getSessionPath(params.getString("name"));
            String filename = sessionPath.toAbsolutePath().toString();
            if (!Files.exists(sessionPath, new LinkOption[0])) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, filename);
            }
            try {
                Control.getSingleton().runCommandLineOpenSession(filename);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                LOGGER.error("Failed to load the session:", (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_NEW_SESSION.equalsIgnoreCase(name)) {
            String sessionName = null;
            try {
                sessionName = params.getString("name");
            }
            catch (Exception filename) {
                // empty catch block
            }
            if (sessionName == null || sessionName.length() == 0) {
                Control.getSingleton().discardSession();
                try {
                    Control.getSingleton().newSession();
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create a new session:", (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            } else {
                Path sessionPath = CoreAPI.getSessionPath(sessionName);
                String filename = sessionPath.toAbsolutePath().toString();
                boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
                if (Files.exists(sessionPath, new LinkOption[0]) && !overwrite) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
                }
                try {
                    Control.getSingleton().runCommandLineNewSession(filename);
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create a new session:", (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
        }
        if (ACTION_CLEAR_EXCLUDED_FROM_PROXY.equals(name)) {
            try {
                session.setExcludeFromProxyRegexs(new ArrayList<String>());
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_EXCLUDE_FROM_PROXY.equals(name)) {
            String regex = params.getString(PARAM_REGEX);
            try {
                session.addExcludeFromProxyRegex(regex);
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            catch (PatternSyntaxException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
            }
        }
        if (ACTION_SET_HOME_DIRECTORY.equals(name)) {
            File f = new File(params.getString(PARAM_DIR));
            if (!f.exists() || !f.isDirectory()) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_DIR);
            Model.getSingleton().getOptionsParam().setUserDirectory(f);
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_MODE.equals(name)) {
            try {
                Control.Mode mode = Control.Mode.valueOf(params.getString("mode").toLowerCase());
                if (View.isInitialised()) {
                    View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(mode);
                    View.getSingleton().getMainFrame().getMainMenuBar().setMode(mode);
                    return ApiResponseElement.OK;
                }
                Control.getSingleton().setMode(mode);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "mode");
            }
        }
        if (ACTION_GENERATE_ROOT_CA.equals(name)) {
            return CoreAPI.getNetworkImplementor().handleApiAction("generateRootCaCert", params);
        }
        if (ACTION_SEND_REQUEST.equals(name)) {
            HttpMessage request;
            try {
                request = CoreAPI.createRequest(params.getString(PARAM_REQUEST));
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
            }
            CoreAPI.validateForCurrentMode(request);
            return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
        }
        if (ACTION_DELETE_ALL_ALERTS.equals(name)) {
            return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiAction(name, params);
        }
        if (ACTION_DELETE_ALERT.equals(name)) {
            return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiAction(name, params);
        }
        if (ACTION_COLLECT_GARBAGE.equals(name)) {
            System.gc();
            return ApiResponseElement.OK;
        }
        if (ACTION_DELETE_SITE_NODE.equals(name)) {
            try {
                String url = params.getString(PARAM_URL);
                String method = this.getParam(params, PARAM_METHOD, "GET");
                String postData = this.getParam(params, PARAM_POST_DATA, "");
                URI uri = new URI(url, true);
                SiteMap siteMap = session.getSiteTree();
                SiteNode siteNode = siteMap.findNode(uri, method, postData);
                if (siteNode == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_URL);
                }
                if (CoreAPI.getExtHistory() == null) return ApiResponseElement.OK;
                CoreAPI.getExtHistory().purge(siteMap, siteNode);
                return ApiResponseElement.OK;
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
        }
        if (ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                List<DomainMatcher> domains = CoreAPI.getProxyExcludedDomains();
                String value = params.getString(PARAM_VALUE);
                DomainMatcher domain = this.getParam(params, PARAM_IS_REGEX, false) ? new DomainMatcher(DomainMatcher.createPattern(value)) : new DomainMatcher(value);
                domain.setEnabled(this.getParam(params, PARAM_IS_ENABLED, true));
                domains.add(domain);
                CoreAPI.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
            }
        } else if (ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                List<DomainMatcher> domains = CoreAPI.getProxyExcludedDomains();
                int idx = params.getInt(PARAM_IDX);
                if (idx < 0 || idx >= domains.size()) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                }
                DomainMatcher oldDomain = domains.get(idx);
                String value = this.getParam(params, PARAM_VALUE, oldDomain.getValue());
                if (value.isEmpty()) {
                    value = oldDomain.getValue();
                }
                DomainMatcher newDomain = this.getParam(params, PARAM_IS_REGEX, oldDomain.isRegex()) ? new DomainMatcher(DomainMatcher.createPattern(value)) : new DomainMatcher(value);
                newDomain.setEnabled(this.getParam(params, PARAM_IS_ENABLED, oldDomain.isEnabled()));
                if (oldDomain.equals(newDomain)) return ApiResponseElement.OK;
                domains.set(idx, newDomain);
                CoreAPI.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
            }
        } else if (ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                List<DomainMatcher> domains = CoreAPI.getProxyExcludedDomains();
                int idx = params.getInt(PARAM_IDX);
                if (idx < 0 || idx >= domains.size()) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                }
                domains.remove(idx);
                CoreAPI.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
            }
        } else if (ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name)) {
            this.setProxyChainExcludedDomainsEnabled(true);
            return ApiResponseElement.OK;
        } else if (ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name)) {
            this.setProxyChainExcludedDomainsEnabled(false);
            return ApiResponseElement.OK;
        } else if (ACTION_OPTION_MAXIMUM_ALERT_INSTANCES.equals(name)) {
            try {
                this.getAlertParam(ApiException.Type.BAD_ACTION).setMaximumInstances(params.getInt(PARAM_NUMBER_OF_INSTANCES));
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_NUMBER_OF_INSTANCES, e);
            }
        } else if (ACTION_OPTION_MERGE_RELATED_ALERTS.equals(name)) {
            try {
                this.getAlertParam(ApiException.Type.BAD_ACTION).setMergeRelatedIssues(params.getBoolean(PARAM_ENABLED));
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ENABLED, e);
            }
        } else {
            if (ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH.equals(name)) {
                File file;
                String filePath = this.getParam(params, PARAM_FILE_PATH, "");
                if (!(filePath.isEmpty() || (file = new File(filePath)).isFile() && file.canRead())) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE_PATH);
                }
                this.getAlertParam(ApiException.Type.BAD_ACTION).setOverridesFilename(filePath);
                if (Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class).reloadOverridesFile()) return ApiResponseElement.OK;
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE_PATH);
            }
            if (ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE.equals(name)) {
                return CoreAPI.getNetworkImplementor().handleApiAction("addPkcs12ClientCertificate", params);
            }
            if (ACTION_DISABLE_CLIENT_CERTIFICATE.equals(name)) {
                JSONObject newParams = new JSONObject();
                params.put((Object)"use", (Object)false);
                return CoreAPI.getNetworkImplementor().handleApiAction("setUseClientCertificate", newParams);
            }
            if (ACTION_CREATE_SBOM_ZIP.equals(name)) {
                File sbomFile = new File(params.getString(PARAM_FILE_PATH));
                if (sbomFile.exists()) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, PARAM_FILE_PATH);
                }
                try {
                    ZapSupportUtils.saveSbomZip(sbomFile);
                    return ApiResponseElement.OK;
                }
                catch (IOException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                }
            } else {
                if (!ACTION_LOGGING.equals(name)) throw new ApiException(ApiException.Type.BAD_ACTION);
                String logName = ApiUtils.getNonEmptyStringParam(params, "name");
                String newLevel = ApiUtils.getNonEmptyStringParam(params, PARAM_LEVEL);
                Level logLevel = Level.toLevel((String)newLevel, null);
                if (logLevel == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Invalid log level: \"" + newLevel + "\"");
                }
                Configurator.setLevel((String)logName, (Level)logLevel);
            }
        }
        return ApiResponseElement.OK;
    }

    protected static Path getChildPath(String parent, String child) throws ApiException {
        Path parentPath;
        Path childPath = Paths.get(parent, child).normalize();
        if (!childPath.startsWith(parentPath = Paths.get(parent, new String[0]).normalize())) {
            LOGGER.error("Detected path traversal attack {}", (Object)childPath);
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILENAME);
        }
        return childPath;
    }

    private static Path getSessionPath(String path) throws ApiException {
        try {
            return SessionUtils.getSessionPath(path);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "name", e);
        }
    }

    private static ApiImplementor getNetworkImplementor() throws ApiException {
        return API.getInstance().getImplementors().get("network");
    }

    private void setProxyChainExcludedDomainsEnabled(boolean enabled) {
        List<DomainMatcher> domains = CoreAPI.getProxyExcludedDomains();
        for (DomainMatcher domain : domains) {
            domain.setEnabled(enabled);
        }
        CoreAPI.setProxyExcludedDomains(domains);
    }

    private static List<DomainMatcher> getProxyExcludedDomains() {
        return Model.getSingleton().getOptionsParam().getConnectionParam().getProxyExcludedDomains();
    }

    private static void setProxyExcludedDomains(List<DomainMatcher> domains) {
        Model.getSingleton().getOptionsParam().getConnectionParam().setProxyExcludedDomains(domains);
    }

    private AlertParam getAlertParam(ApiException.Type type) throws ApiException {
        AlertParam alertOptions = Model.getSingleton().getOptionsParam().getParamSet(AlertParam.class);
        if (alertOptions == null) {
            throw new ApiException(type);
        }
        return alertOptions;
    }

    private static void validateForCurrentMode(HttpMessage request) throws ApiException {
        if (!CoreAPI.isValidForCurrentMode(request.getRequestHeader().getURI())) {
            throw new ApiException(ApiException.Type.MODE_VIOLATION);
        }
    }

    private static boolean isValidForCurrentMode(URI uri) {
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return false;
            }
            case protect: {
                return Model.getSingleton().getSession().isInScope(uri.toString());
            }
        }
        return true;
    }

    private ApiResponse sendHttpMessage(HttpMessage request, boolean followRedirects, String apiResponseName) throws ApiException {
        final ApiResponseList resultList = new ApiResponseList(apiResponseName);
        try {
            CoreAPI.sendRequest(request, followRedirects, new Processor<HttpMessage>(){

                @Override
                public void process(HttpMessage msg) {
                    int id = -1;
                    int type = -1;
                    HistoryReference hRef = msg.getHistoryRef();
                    if (hRef != null) {
                        id = hRef.getHistoryId();
                        type = hRef.getHistoryType();
                    }
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(id, type, msg));
                }
            });
            return resultList;
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to send the HTTP request:", (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
    }

    private static ExtensionHistory getExtHistory() {
        if (extHistory == null) {
            extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return extHistory;
    }

    private static HttpMessage createRequest(String request) throws HttpMalformedHeaderException {
        HttpMessage requestMsg = new HttpMessage();
        String[] parts = request.split(Pattern.quote("\r\n\r\n"), 2);
        requestMsg.setRequestHeader(parts[0]);
        if (parts.length > 1) {
            requestMsg.setRequestBody(parts[1]);
        } else {
            requestMsg.setRequestBody("");
        }
        return requestMsg;
    }

    private static void sendRequest(HttpMessage request, boolean followRedirects, Processor<HttpMessage> processor) throws IOException, ApiException {
        HttpSender sender = new HttpSender(6);
        if (followRedirects) {
            ModeRedirectionValidator redirector = new ModeRedirectionValidator(processor);
            sender.sendAndReceive(request, HttpRequestConfig.builder().setRedirectionValidator(redirector).build());
            if (!redirector.isRequestValid()) {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
        } else {
            sender.sendAndReceive(request, false);
            CoreAPI.persistMessage(request);
            processor.process(request);
        }
    }

    private static void persistMessage(final HttpMessage message) {
        HistoryReference historyRef;
        try {
            historyRef = new HistoryReference(Model.getSingleton().getSession(), 15, message);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return;
        }
        if (CoreAPI.getExtHistory() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreAPI.getExtHistory().addHistory(historyRef);
                    Model.getSingleton().getSession().getSiteTree().addPath(historyRef, message);
                }
            });
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result = null;
        Model model = Model.getSingleton();
        Session session = model.getSession();
        if (VIEW_HOSTS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = session.getSiteTree().getRoot();
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                String site = ((SiteNode)en.nextElement()).getNodeName();
                if (site.indexOf("//") >= 0) {
                    site = site.substring(site.indexOf("//") + 2);
                }
                if (site.indexOf(":") >= 0) {
                    site = site.substring(0, site.indexOf(":"));
                }
                result.addItem(new ApiResponseElement("host", site));
            }
        } else if (VIEW_SITES.equals(name)) {
            ApiResponseList sitesList = new ApiResponseList(name);
            StructuralNode root = SessionStructure.getRootNode(model);
            if (root != null) {
                Iterator<StructuralNode> it = root.getChildIterator();
                while (it.hasNext()) {
                    sitesList.addItem(new ApiResponseElement("site", it.next().getName()));
                }
            }
            result = sitesList;
        } else if (VIEW_URLS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = session.getSiteTree().getRoot();
            CoreAPI.addUrlsToList(this.getParam(params, PARAM_BASE_URL, ""), root, new HashSet<String>(), result);
        } else if (VIEW_CHILD_NODES.equals(name)) {
            StructuralNode node;
            String url = this.getParam(params, PARAM_URL, "");
            if (url.trim().length() == 0) {
                node = SessionStructure.getRootNode(model);
            } else {
                try {
                    node = SessionStructure.find(Model.getSingleton(), new URI(url, false), null, null);
                }
                catch (URIException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                }
            }
            if (node == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_URL);
            }
            result = new ApiResponseList(name);
            Iterator<StructuralNode> iter = node.getChildIterator();
            while (iter.hasNext()) {
                result.addItem(this.structuralNodeToResponse(iter.next()));
            }
        } else {
            if (VIEW_ALERT.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_ALERTS.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_NUMBER_OF_ALERTS.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_ALERTS_SUMMARY.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_MESSAGE.equals(name)) {
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                RecordHistory recordHistory = this.getRecordHistory(tableHistory, this.getParam(params, PARAM_ID, -1));
                result = new ApiResponseElement(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
            } else if (VIEW_MESSAGES.equals(name)) {
                final ApiResponseList resultList = new ApiResponseList(name);
                this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                    @Override
                    public void process(RecordHistory recordHistory) {
                        resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
                    }
                });
                result = resultList;
            } else if (VIEW_NUMBER_OF_MESSAGES.equals(name)) {
                CounterProcessor<RecordHistory> counter = new CounterProcessor<RecordHistory>();
                this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), counter);
                result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
            } else if (VIEW_MESSAGES_BY_ID.equals(name)) {
                ApiResponseList resultList = new ApiResponseList(name);
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                for (Integer id : CoreAPI.getIds(params)) {
                    RecordHistory recordHistory = this.getRecordHistory(tableHistory, id);
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
                }
                result = resultList;
            } else if ("mode".equals(name)) {
                result = new ApiResponseElement(name, Control.getSingleton().getMode().name());
            } else if (VIEW_VERSION.equals(name)) {
                result = new ApiResponseElement(name, Constant.PROGRAM_VERSION);
            } else if (VIEW_EXCLUDED_FROM_PROXY.equals(name)) {
                result = new ApiResponseList(name);
                List<String> regexs = session.getExcludeFromProxyRegexs();
                for (String regex : regexs) {
                    result.addItem(new ApiResponseElement(PARAM_REGEX, regex));
                }
            } else if (VIEW_HOME_DIRECTORY.equals(name)) {
                result = new ApiResponseElement(name, Model.getSingleton().getOptionsParam().getUserDirectory().getAbsolutePath());
            } else if (VIEW_SESSION_LOCATION.equals(name)) {
                result = new ApiResponseElement(name, session.getFileName());
            } else if (VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name) || VIEW_OPTION_PROXY_EXCLUDED_DOMAINS.equals(name) || VIEW_OPTION_PROXY_CHAIN_SKIP_NAME.equals(name) || VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED.equals(name)) {
                result = this.proxyChainExcludedDomainsToApiResponseList(name, VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED.equals(name));
            } else if (VIEW_ZAP_HOME_PATH.equals(name)) {
                result = new ApiResponseElement(name, Constant.getZapHome());
            } else if (VIEW_OPTION_MAXIMUM_ALERT_INSTANCES.equals(name)) {
                result = new ApiResponseElement(name, String.valueOf(this.getAlertParam(ApiException.Type.BAD_VIEW).getMaximumInstances()));
            } else if (VIEW_OPTION_MERGE_RELATED_ALERTS.equals(name)) {
                result = new ApiResponseElement(name, String.valueOf(this.getAlertParam(ApiException.Type.BAD_VIEW).isMergeRelatedIssues()));
            } else if (VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH.equals(name)) {
                result = new ApiResponseElement(name, this.getAlertParam(ApiException.Type.BAD_VIEW).getOverridesFilename());
            } else if (VIEW_LOGGING.equals(name)) {
                String logName = this.getParam(params, "name", "");
                TreeMap<String, String> loggerDetails = new TreeMap<String, String>();
                for (Logger logger : LoggerContext.getContext().getLoggers()) {
                    if (!logName.isEmpty() && (logName.isEmpty() || !StringUtils.startsWithIgnoreCase((CharSequence)logger.getName(), (CharSequence)logName))) continue;
                    loggerDetails.put(logger.getName(), logger.getLevel().name());
                }
                result = new ApiResponseSet(name, loggerDetails);
            } else {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }

    private RecordHistory getRecordHistory(TableHistory tableHistory, Integer id) throws ApiException {
        RecordHistory recordHistory;
        try {
            recordHistory = tableHistory.read(id);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error("Failed to read the history record:", (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
        if (recordHistory == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, Integer.toString(id));
        }
        return recordHistory;
    }

    private ApiResponseSet<Object> structuralNodeToResponse(StructuralNode node) {
        HashMap<String, Object> nodeData = new HashMap<String, Object>();
        nodeData.put("name", node.getName());
        nodeData.put(PARAM_METHOD, node.getMethod());
        nodeData.put("uri", node.getURI().toString());
        nodeData.put("isLeaf", node.isLeaf());
        nodeData.put("hrefId", node.getHistoryReference().getHistoryId());
        return new ApiResponseSet<Object>("node", nodeData);
    }

    private ApiResponse proxyChainExcludedDomainsToApiResponseList(String name, boolean excludeDisabled) {
        List<DomainMatcher> domains = CoreAPI.getProxyExcludedDomains();
        ApiResponseList apiResponse = new ApiResponseList(name);
        for (int i = 0; i < domains.size(); ++i) {
            DomainMatcher domain = domains.get(i);
            if (!domain.isEnabled() && excludeDisabled) continue;
            HashMap<String, Object> domainData = new HashMap<String, Object>();
            domainData.put(PARAM_IDX, i);
            domainData.put(PARAM_VALUE, domain.getValue());
            domainData.put(PARAM_REGEX, domain.isRegex());
            domainData.put(PARAM_ENABLED, domain.isEnabled());
            apiResponse.addItem(new ApiResponseSet("domain", domainData));
        }
        return apiResponse;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) {
        try {
            return this.handleApiOtherImpl(msg, name, params);
        }
        catch (ApiException e) {
            msg.setResponseBody(e.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8));
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", msg.getResponseBody().length()));
            }
            catch (HttpMalformedHeaderException e2) {
                LOGGER.error("Failed to create response header: {}", (Object)e2.getMessage(), (Object)e2);
            }
            return msg;
        }
    }

    private HttpMessage handleApiOtherImpl(HttpMessage msg, String name, JSONObject params) throws ApiException {
        if (OTHER_PROXY_PAC.equals(name)) {
            return CoreAPI.getNetworkImplementor().handleApiOther(msg, OTHER_PROXY_PAC, params);
        }
        if (OTHER_SET_PROXY.equals(name)) {
            return CoreAPI.getNetworkImplementor().handleApiOther(msg, "setProxy", params);
        }
        if (OTHER_ROOT_CERT.equals(name)) {
            return CoreAPI.getNetworkImplementor().handleApiOther(msg, "rootCaCert", params);
        }
        if (OTHER_XML_REPORT.equals(name)) {
            CoreAPI.generateReport(msg, ScanReportType.XML);
            return msg;
        }
        if (OTHER_HTML_REPORT.equals(name)) {
            CoreAPI.generateReport(msg, ScanReportType.HTML);
            return msg;
        }
        if (OTHER_JSON_REPORT.equals(name)) {
            CoreAPI.generateReport(msg, ScanReportType.JSON);
            return msg;
        }
        if (OTHER_MD_REPORT.equals(name)) {
            CoreAPI.generateReport(msg, ScanReportType.MD);
            return msg;
        }
        if (OTHER_MESSAGE_HAR.equals(name)) {
            byte[] responseBody;
            try {
                HarEntries entries = new HarEntries();
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                RecordHistory recordHistory = this.getRecordHistory(tableHistory, this.getParam(params, PARAM_ID, -1));
                CoreAPI.addHarEntry(entries, recordHistory);
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_MESSAGES_HAR_BY_ID.equals(name) || OTHER_MESSAGES_HAR.equals(name)) {
            byte[] responseBody;
            try {
                HarEntries entries = new HarEntries();
                if (OTHER_MESSAGES_HAR_BY_ID.equals(name)) {
                    TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                    for (Integer id : CoreAPI.getIds(params)) {
                        RecordHistory recordHistory = this.getRecordHistory(tableHistory, id);
                        CoreAPI.addHarEntry(entries, recordHistory);
                    }
                } else {
                    this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), rh -> CoreAPI.addHarEntry(entries, rh));
                }
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_SEND_HAR_REQUEST.equals(name)) {
            byte[] responseBody = new byte[]{};
            HttpMessage request = null;
            try {
                request = HarUtils.createHttpMessage(params.getString(PARAM_REQUEST));
            }
            catch (IOException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
            }
            if (request != null) {
                if (!CoreAPI.isValidForCurrentMode(request.getRequestHeader().getURI())) {
                    throw new ApiException(ApiException.Type.MODE_VIOLATION);
                }
                boolean followRedirects = this.getParam(params, PARAM_FOLLOW_REDIRECTS, false);
                try {
                    HarEntries entries = new HarEntries();
                    CoreAPI.sendRequest(request, followRedirects, httpMessage -> {
                        HistoryReference hRef = httpMessage.getHistoryRef();
                        entries.addEntry(HarUtils.createHarEntry(hRef.getHistoryId(), hRef.getHistoryType(), httpMessage));
                    });
                    HarLog harLog = HarUtils.createZapHarLog();
                    harLog.setEntries(entries);
                    responseBody = HarUtils.harLogToByteArray(harLog);
                }
                catch (ApiException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_SCRIPT_JS.equals(name)) {
            try {
                msg.setResponseBody(API_SCRIPT);
                msg.setResponseHeader(API.getDefaultResponseHeader("text/javascript", API_SCRIPT.length(), true));
                msg.getResponseHeader().addHeader("cache-control", API_SCRIPT_CACHE_CONTROL);
            }
            catch (HttpMalformedHeaderException e) {
                LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
            }
            return msg;
        }
        if (OTHER_FILE_DOWNLOAD.equals(name)) {
            OptionsParamApi apiParam = Model.getSingleton().getOptionsParam().getApiParam();
            if (!apiParam.isFileTransferAllowed()) {
                throw new ApiException(ApiException.Type.BAD_OTHER, "File transfer not enabled");
            }
            Path filePath = CoreAPI.getChildPath(apiParam.getTransferDir(), this.getParam(params, PARAM_FILENAME, ""));
            try {
                if (!filePath.toFile().canRead()) {
                    LOGGER.error("Cannot access specified file {}", (Object)filePath);
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILENAME);
                }
                msg.setResponseBody(Files.readAllBytes(filePath));
                try {
                    msg.setResponseHeader(API.getDefaultResponseHeader(null, msg.getResponseBody().length()));
                }
                catch (HttpMalformedHeaderException e) {
                    LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
                }
                LOGGER.debug("Downloaded file {}", (Object)filePath);
                return msg;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create file {}", (Object)filePath, (Object)e);
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILENAME, e);
            }
        }
        if (OTHER_FILE_UPLOAD.equals(name)) {
            OptionsParamApi apiParam = Model.getSingleton().getOptionsParam().getApiParam();
            if (!apiParam.isFileTransferAllowed()) {
                throw new ApiException(ApiException.Type.BAD_OTHER, "File transfer not enabled");
            }
            if (!"POST".equals(msg.getRequestHeader().getMethod())) {
                throw new ApiException(ApiException.Type.BAD_OTHER, "File upload must use POST");
            }
            Path filePath = CoreAPI.getChildPath(apiParam.getTransferDir(), this.getParam(params, PARAM_FILENAME, ""));
            try {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.writeString(filePath, (CharSequence)this.getParam(params, PARAM_CONTENTS, ""), new OpenOption[0]);
                LOGGER.debug("Uploaded file to {}", (Object)filePath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to upload file {}", (Object)filePath, (Object)e);
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILENAME, e);
            }
            ApiResponseElement response = new ApiResponseElement("Uploaded", filePath.toString());
            msg.setResponseBody(((ApiResponse)response).toJSON().toString().getBytes());
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", msg.getResponseBody().length()));
            }
            catch (HttpMalformedHeaderException e2) {
                LOGGER.error("Failed to create response header: {}", (Object)e2.getMessage(), (Object)e2);
            }
            return msg;
        }
        throw new ApiException(ApiException.Type.BAD_OTHER, name);
    }

    private static List<Integer> getIds(JSONObject params) throws ApiException {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (String id : params.getString(PARAM_IDS).split(",")) {
            try {
                listIds.add(Integer.valueOf(id.trim()));
            }
            catch (NumberFormatException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDS, e);
            }
        }
        if (listIds.isEmpty()) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_IDS);
        }
        return listIds;
    }

    private static void addHarEntry(HarEntries entries, RecordHistory recordHistory) {
        entries.addEntry(HarUtils.createHarEntry(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private static void generateReport(HttpMessage msg, ScanReportType reportType) throws ApiException {
        try {
            String template;
            ApiImplementor reportApi = API.getInstance().getImplementors().get("reports");
            if (reportApi == null) {
                throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "Reports add-on not installed");
            }
            File xmlFile = File.createTempFile("ZAP-report", switch (reportType) {
                case ScanReportType.HTML -> {
                    msg.setResponseHeader(API.getDefaultResponseHeader("text/html; charset=UTF-8"));
                    msg.getResponseHeader().setHeader("Content-Security-Policy", "default-src 'none'; script-src 'self'; connect-src 'self'; child-src 'self'; img-src 'self' data:; font-src 'self' data:; style-src 'unsafe-inline'");
                    template = "traditional-html";
                    yield ".html";
                }
                case ScanReportType.JSON -> {
                    msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8"));
                    template = "traditional-json";
                    yield ".json";
                }
                case ScanReportType.MD -> {
                    msg.setResponseHeader(API.getDefaultResponseHeader("text/markdown; charset=UTF-8"));
                    template = "traditional-md";
                    yield ".md";
                }
                case ScanReportType.XML -> {
                    msg.setResponseHeader(API.getDefaultResponseHeader("text/xml; charset=UTF-8"));
                    template = "traditional-xml";
                    yield ".xml";
                }
                default -> throw new ApiException(ApiException.Type.INTERNAL_ERROR, "Unsupported format: " + String.valueOf((Object)reportType));
            });
            JSONObject reportParams = new JSONObject();
            reportParams.put((Object)"template", (Object)template);
            reportParams.put((Object)"reportDir", (Object)xmlFile.getParentFile().getAbsolutePath());
            reportParams.put((Object)"reportFileName", (Object)xmlFile.getName());
            reportParams.put((Object)"title", (Object)"ZAP Scanning Report");
            reportApi.handleApiAction("generate", reportParams);
            msg.setResponseBody(new String(Files.readAllBytes(xmlFile.toPath()), StandardCharsets.UTF_8));
            msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
            if (!xmlFile.delete()) {
                LOGGER.debug("Failed to delete temporary report file {}", (Object)xmlFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage msg) throws ApiException {
        try {
            if (msg.getRequestHeader().getURI().getPath().startsWith("/script.js")) {
                return this.handleApiOther(msg, OTHER_SCRIPT_JS, new JSONObject());
            }
        }
        catch (URIException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, msg.getRequestHeader().getURI().toString());
    }

    private static void addUrlsToList(String baseUrl, SiteNode parent, Set<String> addedUrls, ApiResponseList list) {
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            SiteNode child = (SiteNode)en.nextElement();
            String uri = child.getHistoryReference().getURI().toString();
            if (!addedUrls.contains(uri) && (baseUrl.isEmpty() || uri.startsWith(baseUrl))) {
                list.addItem(new ApiResponseElement(PARAM_URL, uri));
                addedUrls.add(uri);
            }
            CoreAPI.addUrlsToList(baseUrl, child, addedUrls, list);
        }
    }

    private void processHttpMessages(String baseUrl, int start, int count, Processor<RecordHistory> processor) throws ApiException {
        try {
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            List<Integer> historyIds = tableHistory.getHistoryIds(Model.getSingleton().getSession().getSessionId());
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (Integer id : historyIds) {
                HttpMessage msg;
                RecordHistory recHistory = tableHistory.read(id);
                if (recHistory == null || (msg = recHistory.getHttpMessage()).getRequestHeader().isImage() || msg.getResponseHeader().isImage() || baseUrl != null && !msg.getRequestHeader().getURI().toString().startsWith(baseUrl)) continue;
                pcc.recordProcessed();
                if (!pcc.hasPageStarted()) continue;
                processor.process(recHistory);
                if (!pcc.hasPageEnded()) continue;
                break;
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    @Override
    public void sessionOpened(File file, Exception e) {
    }

    @Override
    public void sessionSaved(Exception e) {
        LOGGER.debug("Saved session notification");
        this.savingSession = false;
    }

    @Override
    public void sessionSnapshot(Exception e) {
        LOGGER.debug("Snapshot session notification");
        this.savingSession = false;
    }

    private static interface Processor<T> {
        public void process(T var1);
    }

    private static class ModeRedirectionValidator
    implements HttpRedirectionValidator {
        private final Processor<HttpMessage> processor;
        private boolean isRequestValid;

        public ModeRedirectionValidator(Processor<HttpMessage> processor) {
            this.processor = processor;
            this.isRequestValid = true;
        }

        @Override
        public void notifyMessageReceived(HttpMessage message) {
            CoreAPI.persistMessage(message);
            this.processor.process(message);
        }

        @Override
        public boolean isValid(URI redirection) {
            this.isRequestValid = CoreAPI.isValidForCurrentMode(redirection);
            return this.isRequestValid;
        }

        public boolean isRequestValid() {
            return this.isRequestValid;
        }
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T object) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static enum ScanReportType {
        HTML,
        JSON,
        XML,
        MD;

    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int start, int count) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + count - 1 : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }
}

