/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.Iterator;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanData;
import org.zaproxy.zap.extension.pscan.PassiveScanTaskHelper;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.utils.Stats;

@Deprecated(forRemoval=true, since="2.16.0")
public class PassiveScanTask
implements Runnable {
    private HistoryReference href;
    private PassiveScanTaskHelper helper;
    private PassiveScanThread psThread;
    private int maxBodySize;
    private Boolean completed = null;
    private boolean shutdown = false;
    private PassiveScanner currentScanner;
    private long startTime;
    private long stopTime;
    private static final Logger LOGGER = LogManager.getLogger(PassiveScanTask.class);

    public PassiveScanTask(HistoryReference hr, PassiveScanTaskHelper helper) {
        this.href = hr;
        this.helper = helper;
        this.psThread = new PassiveScanThread(helper, this.href);
        this.maxBodySize = helper.getMaxBodySizeInBytesToScan();
        helper.addTaskToList(this);
    }

    public Boolean hasCompleted() {
        return this.completed;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public PassiveScanner getCurrentScanner() {
        return this.currentScanner;
    }

    public URI getURI() {
        return this.href.getURI();
    }

    public HistoryReference getHistoryReference() {
        return this.href;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            boolean scanned = false;
            this.startTime = System.currentTimeMillis();
            this.completed = false;
            try {
                HttpMessage msg = this.href.getHttpMessage();
                Source src = new Source((CharSequence)msg.getResponseBody().toString());
                PassiveScanData passiveScanData = new PassiveScanData(msg);
                Iterator<PassiveScanner> iterator = this.helper.getPassiveScanRuleManager().getScanRules().iterator();
                while (iterator.hasNext()) {
                    PassiveScanner scanner;
                    block25: {
                        this.currentScanner = scanner = iterator.next();
                        if (!this.shutdown) break block25;
                        return;
                    }
                    try {
                        int hrefHistoryType = this.href.getHistoryType();
                        if (!scanner.isEnabled() || !scanner.appliesToHistoryType(hrefHistoryType) && !PassiveScanTaskHelper.getOptedInHistoryTypes().contains(hrefHistoryType)) continue;
                        if (scanner instanceof PluginPassiveScanner) {
                            PluginPassiveScanner pps = ((PluginPassiveScanner)scanner).copy();
                            pps.setHelper(passiveScanData);
                            scanner = pps;
                        }
                        scanner.setParent(this.psThread);
                        scanner.setTaskHelper(this.helper);
                        LOGGER.debug("Running scan rule, URL {} plugin {}", (Object)msg.getRequestHeader().getURI(), (Object)scanner.getName());
                        long scanRuleStartTime = System.currentTimeMillis();
                        if (this.maxBodySize <= 0 || msg.getRequestBody().length() < this.maxBodySize) {
                            scanner.scanHttpRequestSend(msg, this.href.getHistoryId());
                            scanned = true;
                        } else {
                            Stats.incCounter("stats.pscan.reqBodyTooBig");
                            LOGGER.debug("Request to {} body size {} larger than max configured {}", (Object)msg.getRequestHeader().getURI(), (Object)msg.getRequestBody().length(), (Object)this.maxBodySize);
                        }
                        if (msg.isResponseFromTargetHost()) {
                            if (this.maxBodySize <= 0 || msg.getResponseBody().length() < this.maxBodySize) {
                                scanner.scanHttpResponseReceive(msg, this.href.getHistoryId(), src);
                                scanned = true;
                            } else {
                                Stats.incCounter("stats.pscan.respBodyTooBig");
                                LOGGER.debug("Response from {} body size {} larger than max configured {}", (Object)msg.getRequestHeader().getURI(), (Object)msg.getResponseBody().length(), (Object)this.maxBodySize);
                            }
                        }
                        if (!scanned) continue;
                        long timeTaken = System.currentTimeMillis() - scanRuleStartTime;
                        if (scanner instanceof PluginPassiveScanner) {
                            PluginPassiveScanner pps = (PluginPassiveScanner)scanner;
                            Stats.incCounter("stats.pscan." + pps.getPluginId() + ".time", timeTaken);
                        }
                        Stats.incCounter("stats.pscan." + scanner.getName(), timeTaken);
                        if (timeTaken <= 5000L) continue;
                        Object responseInfo = "";
                        if (msg.isResponseFromTargetHost()) {
                            responseInfo = msg.getResponseHeader().getHeader("content-type") + " " + msg.getResponseBody().length();
                        }
                        LOGGER.warn("Passive Scan rule {} took {} seconds to scan {} {}", (Object)scanner.getName(), (Object)(timeTaken / 1000L), (Object)msg.getRequestHeader().getURI(), responseInfo);
                    }
                    catch (Exception e) {
                        LOGGER.error("Scan rule '{}' failed on record {} from History table: {} {}", (Object)scanner.getName(), (Object)this.href.getHistoryId(), (Object)this.href.getMethod(), (Object)this.href.getURI(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                if (HistoryReference.getTemporaryTypes().contains(this.href.getHistoryType())) {
                    LOGGER.debug("Temporary record {} no longer available:", (Object)this.href.getHistoryId(), (Object)e);
                    break block26;
                }
                RecordHistory rec = null;
                try {
                    rec = Model.getSingleton().getDb().getTableHistory().read(this.href.getHistoryId());
                }
                catch (DatabaseException | HttpMalformedHeaderException passiveScanData) {
                    // empty catch block
                }
                if (rec == null) {
                    return;
                }
                LOGGER.error("Parser failed on record {} from History table", (Object)this.href.getHistoryId(), (Object)e);
                try {
                    HttpMessage msg = this.href.getHttpMessage();
                    LOGGER.error("Req Header {}", (Object)msg.getRequestHeader(), (Object)e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.completed = true;
                this.stopTime = System.currentTimeMillis();
                this.helper.removeTaskFromList(this);
            }
        }
    }
}

