/*
 * Decompiled with CFR 0.152.
 */
package lzma.streams;

import java.io.IOException;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;
import lzma.streams.LzmaEncoderWrapper;
import org.cservenak.streams.CoderOutputStream;

public class LzmaOutputStream
extends CoderOutputStream {
    public LzmaOutputStream(OutputStream out, LzmaEncoderWrapper wrapper) throws IOException {
        super(out, wrapper);
    }

    public LzmaOutputStream(OutputStream out, Encoder lzmaEncoder) throws IOException {
        this(out, new LzmaEncoderWrapper(lzmaEncoder));
    }

    public static class Builder {
        private final OutputStream out;
        private int dictionnarySize = 0x800000;
        private boolean endMarkerMode = true;
        private int matchFinder = 1;
        private int numFastBytes = 32;

        public Builder(OutputStream out) {
            this.out = out;
        }

        public Builder useMaximalDictionarySize() {
            this.dictionnarySize = 0x10000000;
            return this;
        }

        public Builder useMediumDictionarySize() {
            this.dictionnarySize = 32768;
            return this;
        }

        public Builder useMinimalDictionarySize() {
            this.dictionnarySize = 1;
            return this;
        }

        public Builder useEndMarkerMode(boolean endMarkerMode) {
            this.endMarkerMode = endMarkerMode;
            return this;
        }

        public Builder useBT4MatchFinder() {
            this.matchFinder = 1;
            return this;
        }

        public Builder useBT2MatchFinder() {
            this.matchFinder = 0;
            return this;
        }

        public Builder useMinimalFastBytes() {
            this.numFastBytes = 5;
            return this;
        }

        public Builder useMediumFastBytes() {
            this.numFastBytes = 32;
            return this;
        }

        public Builder useMaximalFastBytes() {
            this.numFastBytes = 273;
            return this;
        }

        public LzmaOutputStream build() throws IOException {
            Encoder encoder = new Encoder();
            encoder.setDictionarySize(this.dictionnarySize);
            encoder.setEndMarkerMode(this.endMarkerMode);
            encoder.setMatchFinder(this.matchFinder);
            encoder.setNumFastBytes(this.numFastBytes);
            return new LzmaOutputStream(this.out, encoder);
        }
    }
}

