/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.videobridge.AudioSubscription;
import org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u001a\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0006J\u0014\u0010\u001f\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/videobridge/AudioSubscriptionManager;", "", "<init>", "()V", "audioSubscriptions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jitsi/videobridge/AudioSubscription;", "subscribedLocalAudioSources", "", "lock", "setEndpointAudioSubscription", "", "endpointId", "subscription", "Lorg/jitsi/videobridge/message/ReceiverAudioSubscriptionMessage;", "audioSources", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "isEndpointAudioWanted", "", "ssrc", "", "isExplicitlySubscribed", "sourceName", "updateSubscribedLocalAudioSourcesForEndpoint", "onSourcesAdded", "sources", "", "removeEndpoint", "id", "removeSources", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAudioSubscriptionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSubscriptionManager.kt\norg/jitsi/videobridge/AudioSubscriptionManager\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n72#2,2:132\n72#2,2:138\n1#3:134\n1#3:140\n1#3:156\n1869#4,2:135\n1869#4:137\n1870#4:141\n1869#4,2:142\n1869#4,2:144\n1617#4,9:146\n1869#4:155\n1870#4:157\n1626#4:158\n1869#4,2:159\n*S KotlinDebug\n*F\n+ 1 AudioSubscriptionManager.kt\norg/jitsi/videobridge/AudioSubscriptionManager\n*L\n46#1:132,2\n91#1:138,2\n46#1:134\n91#1:140\n125#1:156\n84#1:135,2\n90#1:137\n90#1:141\n105#1:142,2\n117#1:144,2\n125#1:146,9\n125#1:155\n125#1:157\n125#1:158\n126#1:159,2\n*E\n"})
public final class AudioSubscriptionManager {
    @NotNull
    private final ConcurrentHashMap<String, AudioSubscription> audioSubscriptions = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, Set<String>> subscribedLocalAudioSources = new ConcurrentHashMap();
    @NotNull
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setEndpointAudioSubscription(@NotNull String endpointId, @NotNull ReceiverAudioSubscriptionMessage subscription, @NotNull List<AudioSourceDesc> audioSources) {
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(audioSources, (String)"audioSources");
        Object object = this.lock;
        synchronized (object) {
            void $this$getOrPut$iv;
            boolean bl = false;
            ConcurrentMap concurrentMap = this.audioSubscriptions;
            String key$iv = endpointId;
            boolean $i$f$getOrPut = false;
            Object object2 = $this$getOrPut$iv.get(key$iv);
            if (object2 == null) {
                boolean bl2 = false;
                AudioSubscription default$iv = new AudioSubscription();
                boolean bl3 = false;
                object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object2 == null) {
                    object2 = default$iv;
                }
            }
            AudioSubscription audioSubscription = (AudioSubscription)object2;
            this.updateSubscribedLocalAudioSourcesForEndpoint(endpointId, subscription);
            audioSubscription.updateSubscription(subscription, audioSources);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isEndpointAudioWanted(@NotNull String endpointId, long ssrc) {
        AudioSubscription subscription;
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        AudioSubscription audioSubscription = subscription = this.audioSubscriptions.get(endpointId);
        return audioSubscription != null ? audioSubscription.isSsrcWanted(ssrc) : true;
    }

    public final boolean isExplicitlySubscribed(@Nullable String sourceName) {
        return ((Map)this.subscribedLocalAudioSources).containsKey(sourceName);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSubscribedLocalAudioSourcesForEndpoint(String endpointId, ReceiverAudioSubscriptionMessage subscription) {
        Collection<Set<String>> collection = this.subscribedLocalAudioSources.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set endpointSet = (Set)element$iv;
            boolean bl = false;
            endpointSet.remove(endpointId);
        }
        this.subscribedLocalAudioSources.entrySet().removeIf(arg_0 -> AudioSubscriptionManager.updateSubscribedLocalAudioSourcesForEndpoint$lambda$2(AudioSubscriptionManager::updateSubscribedLocalAudioSourcesForEndpoint$lambda$1, arg_0));
        if (subscription instanceof ReceiverAudioSubscriptionMessage.Include) {
            Iterable $this$forEach$iv2 = ((ReceiverAudioSubscriptionMessage.Include)subscription).getList();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                void $this$getOrPut$iv;
                String sourceName = (String)element$iv;
                boolean bl = false;
                ConcurrentMap concurrentMap = this.subscribedLocalAudioSources;
                String key$iv = sourceName;
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl2 = false;
                    Set default$iv = new LinkedHashSet();
                    boolean bl3 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ((Set)object).add(endpointId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSourcesAdded(@NotNull Set<AudioSourceDesc> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Collection<AudioSubscription> collection = this.audioSubscriptions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AudioSubscription subscription = (AudioSubscription)element$iv;
                boolean bl2 = false;
                subscription.onConferenceSourceAdded(sources);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final AudioSubscription removeEndpoint(@NotNull String id) {
        AudioSubscription audioSubscription;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Collection<Set<String>> collection = this.subscribedLocalAudioSources.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set endpointSet = (Set)element$iv;
                boolean bl2 = false;
                endpointSet.remove(id);
            }
            this.subscribedLocalAudioSources.entrySet().removeIf(arg_0 -> AudioSubscriptionManager.removeEndpoint$lambda$0$2(AudioSubscriptionManager::removeEndpoint$lambda$0$1, arg_0));
            audioSubscription = this.audioSubscriptions.remove(id);
        }
        return audioSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void removeSources(@NotNull Set<AudioSourceDesc> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Object object = this.lock;
        synchronized (object) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            boolean bl = false;
            Iterable iterable = sources;
            ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.subscribedLocalAudioSources.keySet();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                AudioSourceDesc it = (AudioSourceDesc)element$iv$iv;
                boolean bl3 = false;
                if (it.getSourceName() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            keySetView.removeAll((Collection)((List)destination$iv$iv));
            Collection<AudioSubscription> collection = this.audioSubscriptions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                AudioSubscription subscription = (AudioSubscription)element$iv;
                boolean bl5 = false;
                subscription.onConferenceSourceRemoved(sources);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean updateSubscribedLocalAudioSourcesForEndpoint$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Set)it.getValue()).isEmpty();
    }

    private static final boolean updateSubscribedLocalAudioSourcesForEndpoint$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEndpoint$lambda$0$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Set)it.getValue()).isEmpty();
    }

    private static final boolean removeEndpoint$lambda$0$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

