/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.BoxParser;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriter;

public class FreeBox
implements ParsableBox {
    public static final String TYPE = "free";
    ByteBuffer data;
    List<ParsableBox> replacers = new LinkedList<ParsableBox>();
    private Container parent;
    private long offset;

    public FreeBox() {
        this.data = ByteBuffer.wrap(new byte[0]);
    }

    public FreeBox(int size) {
        this.data = ByteBuffer.allocate(size);
    }

    public ByteBuffer getData() {
        if (this.data != null) {
            return (ByteBuffer)((Buffer)this.data.duplicate()).rewind();
        }
        return null;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        for (ParsableBox replacer : this.replacers) {
            replacer.getBox(os);
        }
        ByteBuffer header = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt32(header, 8 + this.data.limit());
        header.put(TYPE.getBytes());
        ((Buffer)header).rewind();
        os.write(header);
        ((Buffer)header).rewind();
        ((Buffer)this.data).rewind();
        os.write(this.data);
        ((Buffer)this.data).rewind();
    }

    @Override
    public long getSize() {
        long size = 8L;
        for (ParsableBox replacer : this.replacers) {
            size += replacer.getSize();
        }
        return size += (long)this.data.limit();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        int b;
        this.data = ByteBuffer.allocate(CastUtils.l2i(contentSize));
        int bytesRead = 0;
        while ((long)((b = dataSource.read(this.data)) + bytesRead) < contentSize) {
            bytesRead += b;
        }
    }

    public void addAndReplace(ParsableBox parsableBox) {
        ((Buffer)this.data).position(CastUtils.l2i(parsableBox.getSize()));
        this.data = this.data.slice();
        this.replacers.add(parsableBox);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeBox freeBox = (FreeBox)o;
        return !(this.getData() != null ? !this.getData().equals(freeBox.getData()) : freeBox.getData() != null);
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }
}

