/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.kiulian.downloader.jackson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JSONArray {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ArrayNode array;

    public JSONArray() {
        this.array = MAPPER.createArrayNode();
    }

    public JSONArray(String string) throws Exception {
        this.array = (ArrayNode)MAPPER.readTree(string);
    }

    public JSONArray(ArrayNode arrayNode) {
        this.array = arrayNode;
    }

    public static JSONArray parseArray(String string) throws Exception {
        return new JSONArray(string);
    }

    public void add(Object object) {
        this.array.addPOJO(object);
    }

    public void addAll(JSONArray jSONArray) {
        this.array.addAll(jSONArray.array);
    }

    public JSONObject getJSONObject(int n) {
        JsonNode jsonNode = this.array.get(n);
        if (jsonNode != null && jsonNode.isObject()) {
            return new JSONObject((ObjectNode)jsonNode);
        }
        return null;
    }

    public String getString(int n) {
        JsonNode jsonNode = this.array.get(n);
        return jsonNode != null ? jsonNode.asText() : null;
    }

    public int size() {
        return this.array.size();
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (JsonNode jsonNode : this.array) {
            try {
                arrayList.add(MAPPER.treeToValue((TreeNode)jsonNode, clazz));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public Stream<JSONObject> stream() {
        return StreamSupport.stream(this.array.spliterator(), false).filter(JsonNode::isObject).map(jsonNode -> new JSONObject((ObjectNode)jsonNode));
    }

    public String toString() {
        return this.array.toString();
    }
}

