/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class CriteriaValidator
implements Validator {
    private final CriteriaDefinition criteria;

    private CriteriaValidator(CriteriaDefinition criteria) {
        this.criteria = criteria;
    }

    static CriteriaValidator of(CriteriaDefinition criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null");
        return new CriteriaValidator(criteria);
    }

    @Override
    public Document toDocument() {
        return this.criteria.getCriteriaObject();
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteriaValidator that = (CriteriaValidator)o;
        return ObjectUtils.nullSafeEquals((Object)this.criteria, (Object)that.criteria);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.criteria);
    }
}

