/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.ArrayList;
import java.util.Collection;
import org.ahocorasick.trie.DefaultToken;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.PayloadEmit;
import org.ahocorasick.trie.PayloadToken;
import org.ahocorasick.trie.PayloadTrie;
import org.ahocorasick.trie.Token;
import org.ahocorasick.trie.handler.EmitHandler;
import org.ahocorasick.trie.handler.PayloadEmitDelegateHandler;
import org.ahocorasick.trie.handler.StatefulEmitHandler;
import org.ahocorasick.trie.handler.StatefulPayloadEmitDelegateHandler;

public class Trie {
    private final PayloadTrie<String> payloadTrie;

    private Trie(PayloadTrie<String> payloadTrie) {
        this.payloadTrie = payloadTrie;
    }

    public Collection<Token> tokenize(String text) {
        Collection<PayloadToken<String>> tokens = this.payloadTrie.tokenize(text);
        return Trie.asTokens(tokens);
    }

    private static Collection<Token> asTokens(Collection<PayloadToken<String>> tokens) {
        ArrayList<Token> result = new ArrayList<Token>();
        for (PayloadToken<String> payloadToken : tokens) {
            result.add(new DefaultToken(payloadToken));
        }
        return result;
    }

    private static Collection<Emit> asEmits(Collection<PayloadEmit<String>> emits) {
        ArrayList<Emit> result = new ArrayList<Emit>();
        for (PayloadEmit<String> emit : emits) {
            result.add(Trie.asEmit(emit));
        }
        return result;
    }

    private static Emit asEmit(PayloadEmit<String> payloadEmit) {
        return new Emit(payloadEmit.getStart(), payloadEmit.getEnd(), payloadEmit.getKeyword());
    }

    public Collection<Emit> parseText(CharSequence text) {
        Collection<PayloadEmit<String>> parsedText = this.payloadTrie.parseText(text);
        return Trie.asEmits(parsedText);
    }

    public Collection<Emit> parseText(CharSequence text, StatefulEmitHandler emitHandler) {
        Collection<PayloadEmit<String>> parsedText = this.payloadTrie.parseText(text, new StatefulPayloadEmitDelegateHandler(emitHandler));
        return Trie.asEmits(parsedText);
    }

    public boolean containsMatch(CharSequence text) {
        return this.firstMatch(text) != null;
    }

    public void parseText(CharSequence text, EmitHandler emitHandler) {
        this.payloadTrie.parseText(text, new PayloadEmitDelegateHandler(emitHandler));
    }

    public Emit firstMatch(CharSequence text) {
        PayloadEmit<String> payload = this.payloadTrie.firstMatch(text);
        return payload == null ? null : new Emit(payload.getStart(), payload.getEnd(), payload.getKeyword());
    }

    public static TrieBuilder builder() {
        return new TrieBuilder();
    }

    public static class TrieBuilder {
        private final PayloadTrie.PayloadTrieBuilder<String> delegate = PayloadTrie.builder();

        private TrieBuilder() {
        }

        public TrieBuilder ignoreCase() {
            this.delegate.ignoreCase();
            return this;
        }

        public TrieBuilder ignoreOverlaps() {
            this.delegate.ignoreOverlaps();
            return this;
        }

        public TrieBuilder addKeyword(String keyword) {
            this.delegate.addKeyword(keyword, null);
            return this;
        }

        public TrieBuilder addKeywords(String ... keywords) {
            for (String keyword : keywords) {
                this.delegate.addKeyword(keyword, null);
            }
            return this;
        }

        public TrieBuilder addKeywords(Collection<String> keywords) {
            for (String keyword : keywords) {
                this.delegate.addKeyword(keyword, null);
            }
            return this;
        }

        public TrieBuilder onlyWholeWords() {
            this.delegate.onlyWholeWords();
            return this;
        }

        public TrieBuilder onlyWholeWordsWhiteSpaceSeparated() {
            this.delegate.onlyWholeWordsWhiteSpaceSeparated();
            return this;
        }

        public TrieBuilder stopOnHit() {
            this.delegate.stopOnHit();
            return this;
        }

        public Trie build() {
            PayloadTrie<String> payloadTrie = this.delegate.build();
            return new Trie(payloadTrie);
        }

        public TrieBuilder caseInsensitive() {
            return this.ignoreCase();
        }

        public TrieBuilder removeOverlaps() {
            return this.ignoreOverlaps();
        }
    }
}

