/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.mschap;

import com.axlradius.misc.a;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.radutil.Rand;
import com.axlradius.radclient4.radutil.Util;
import com.axlradius.radclient4.radutil.b;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class MSChap {
    public static final int NTHASH_PASSWORD_LENGTH = 16;
    public static final int PASSWORD_HASH_HASH_LENGTH = 16;
    public static final int CHALLENGE_LENGTH = 8;
    public static final int MAX_ERROR_RESPONSE = 48;
    public static final int NTRESPONSE_LENGTH = 24;
    public static final int LMRESPONSE_LENGTH = 24;
    public static final int RESPONSE_CHAP_IDENT_LENGTH = 1;
    public static final int RESPONSE_IDENT_POSN = 0;
    public static final int RESPONSE_FLAGS_LENGTH = 1;
    public static final int RESPONSE_FLAGS_POSN = 1;
    public static final int MS_CHAP_Response_Length = 50;
    private static final byte[] R = "KGS!@#$%".getBytes();
    public static final String DefaultErrorResponse = "E=691 R=1";
    private Cipher b;
    private b a = new b();

    protected MSChap(byte by) {
    }

    public MSChap() throws RADIUSException {
        try {
            this.b = Cipher.getInstance("DES");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RADIUSException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RADIUSException(noSuchPaddingException.getMessage());
        }
    }

    public final byte[] LmChallengeResponse(byte[] byArray, byte[] byArray2) throws RADIUSException {
        byArray2 = this.LmPasswordHash(byArray2);
        return this.ChallengeResponse(byArray, byArray2);
    }

    public final byte[] LmPasswordHash(byte[] byArray) throws RADIUSException {
        byte[] byArray2 = Util.toUTF8(Util.toUTF8(byArray).toUpperCase());
        byArray = new byte[14];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length >= 14 ? 14 : byArray2.length);
        byArray2 = byArray;
        byArray = new byte[7];
        System.arraycopy(byArray2, 0, byArray, 0, 7);
        byte[] byArray3 = this.DesHash(byArray);
        System.arraycopy(byArray2, 7, byArray, 0, 7);
        byArray = this.DesHash(byArray);
        byArray2 = new byte[16];
        System.arraycopy(byArray3, 0, byArray2, 0, 8);
        System.arraycopy(byArray, 0, byArray2, 8, 8);
        Util.clean(byArray3);
        Util.clean(byArray);
        return byArray2;
    }

    public final byte[] DesHash(byte[] byArray) throws RADIUSException {
        return this.DesEncrypt(R, byArray);
    }

    public final byte[] DesEncrypt(byte[] byArray, byte[] object) throws RADIUSException {
        byte[] byArray2 = this.parityKey((byte[])object);
        object = new byte[8];
        int n2 = byArray2.length > 8 ? 8 : byArray2.length;
        System.arraycopy(byArray2, 0, object, 0, n2);
        Util.clean(byArray2);
        try {
            object = new SecretKeySpec((byte[])object, "DES");
            this.b = Cipher.getInstance("DES");
            this.b.init(1, (Key)object);
            object = new byte[this.b.getOutputSize(byArray.length)];
            this.b.doFinal(byArray, 0, byArray.length, (byte[])object, 0);
            byArray = new byte[8];
            System.arraycopy(object, 0, byArray, 0, 8);
            Util.clean(object);
            return byArray;
        }
        catch (Exception exception) {
            throw new RADIUSException(exception.getMessage());
        }
    }

    public final byte[] NtChallengeResponse(byte[] byArray, byte[] byArray2, PasswordType object) throws RADIUSException {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = new byte[]{};
        }
        if (object == PasswordType.PLAINTEXT) {
            object = this.toUnicode(byArray2);
            byArray2 = this.NtPasswordHash((byte[])object);
            Util.clean((byte[])object);
        }
        return this.ChallengeResponse(byArray, byArray2);
    }

    public final byte[] NtPasswordHash(byte[] byArray) {
        byte[] byArray2;
        boolean bl = false;
        if (byArray.length > 256) {
            byArray2 = new byte[256];
            System.arraycopy(byArray, 0, byArray2, 0, 256);
            byArray = byArray2;
            bl = true;
        }
        this.a.reset();
        this.a.update(byArray);
        byArray2 = this.a.digest();
        if (bl) {
            Util.clean(byArray);
        }
        return byArray2;
    }

    public static byte[] createChallenge() {
        byte[] byArray = new byte[8];
        Rand.nextBytes(byArray);
        return byArray;
    }

    public final byte[] ChallengeResponse(byte[] byArray, byte[] byArray2) throws RADIUSException {
        byArray2 = this.a(byArray2, PasswordType.NTHASH);
        byte[] byArray3 = new byte[21];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byte[] byArray4 = new byte[7];
        System.arraycopy(byArray3, 0, byArray4, 0, 7);
        byte[] byArray5 = this.DesEncrypt(byArray, byArray4);
        System.arraycopy(byArray3, 7, byArray4, 0, 7);
        byte[] byArray6 = this.DesEncrypt(byArray, byArray4);
        System.arraycopy(byArray3, 14, byArray4, 0, 7);
        byArray = this.DesEncrypt(byArray, byArray4);
        byArray3 = new byte[24];
        System.arraycopy(byArray5, 0, byArray3, 0, 8);
        System.arraycopy(byArray6, 0, byArray3, 8, 8);
        System.arraycopy(byArray, 0, byArray3, 16, 8);
        Util.clean(byArray5);
        Util.clean(byArray);
        Util.clean(byArray);
        Util.clean(byArray4);
        Util.clean(byArray2);
        return byArray3;
    }

    public final byte[] LmEncryptedPasswordHash(byte[] byArray, byte[] byArray2) throws RADIUSException {
        byte[] byArray3;
        if (byArray.length > 256) {
            byArray3 = new byte[256];
            System.arraycopy(byArray, 0, byArray3, 0, 256);
            byArray = byArray3;
        }
        byArray3 = this.LmPasswordHash(byArray);
        return this.PasswordHashEncryptedWithBlock(byArray3, byArray2);
    }

    public final byte[] PasswordHashEncryptedWithBlock(byte[] byArray, byte[] byArray2) throws RADIUSException {
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 0, byArray3, 0, 8);
        byte[] byArray4 = new byte[7];
        System.arraycopy(byArray2, 0, byArray4, 0, 7);
        byArray2 = this.DesEncrypt(byArray3, byArray4);
        System.arraycopy(byArray, 0, byArray3, 8, 8);
        byArray = this.DesEncrypt(byArray3, byArray4);
        byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray, 0, byArray3, 8, 8);
        Util.clean(byArray2);
        Util.clean(byArray);
        return byArray3;
    }

    public final byte[] NtEncryptedPasswordHash(byte[] byArray, byte[] byArray2, PasswordType object) throws RADIUSException {
        byArray = this.a(byArray, (PasswordType)((Object)object));
        if (object == PasswordType.PLAINTEXT) {
            object = this.toUnicode(byArray);
            byArray = this.NtPasswordHash((byte[])object);
            Util.clean((byte[])object);
        }
        object = this.PasswordHashEncryptedWithBlock(byArray, byArray2);
        Util.clean(byArray);
        return object;
    }

    public final byte[] HashNtPasswordHash(byte[] byArray) {
        this.a.reset();
        this.a.update(byArray);
        return this.a.digest();
    }

    public final byte[] parityKey(byte[] object) {
        object = new a((byte[])object);
        a a2 = new a(64);
        int n2 = 0;
        a a3 = new a(7);
        for (int i2 = 0; i2 < 56; i2 += 7) {
            for (int i3 = 0; i3 < 7; ++i3) {
                a2.set(n2++, ((a)object).get(i2 + i3));
                a3.set(i3, ((a)object).get(i2 + i3));
            }
            if (a3.cardinality() % 2 == 0) {
                a2.set(n2);
            }
            ++n2;
            a3.clear();
        }
        ((a)object).clear();
        byte[] byArray = a2.toByteArray();
        a2.clear();
        return byArray;
    }

    public final byte[] toUnicode(byte[] byArray) {
        Object object;
        try {
            object = new String(byArray, "UTF-8");
            object = new String((String)object).getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new byte[byArray.length << 1];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                object[(i2 << 1) + 1] = false;
                object[i2 << 1] = byArray[i2];
            }
        }
        return object;
    }

    public final byte getIdent(byte by) {
        byte by2;
        while ((by2 = Rand.nextByte()) == by) {
        }
        return by2;
    }

    public final byte[] toNtPassword(byte[] byArray) {
        return this.NtPasswordHash(this.toUnicode(byArray));
    }

    protected final byte[] a(byte[] byArray, PasswordType passwordType) {
        if (passwordType == PasswordType.PLAINTEXT) {
            return byArray;
        }
        if (byArray.length != 16) {
            return this.NtPasswordHash(byArray);
        }
        return byArray;
    }

    public static enum PasswordType {
        NTHASH,
        PLAINTEXT;

    }
}

