/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EncryptionOptions {
    private final String algorithm;
    private final EncryptionKey key;

    public EncryptionOptions(String algorithm, EncryptionKey key) {
        Assert.hasText((String)algorithm, (String)"Algorithm must not be empty");
        Assert.notNull((Object)key, (String)"EncryptionKey must not be empty");
        this.key = key;
        this.algorithm = algorithm;
    }

    public EncryptionKey key() {
        return this.key;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionOptions that = (EncryptionOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.algorithm, (Object)that.algorithm)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.algorithm);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.key);
        return result;
    }

    public String toString() {
        return "EncryptionOptions{algorithm='" + this.algorithm + "', key=" + String.valueOf(this.key) + "}";
    }
}

