// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Retrieves capacity usage metrics for your EC2 resources. Returns time-series
//
// data for metrics like unused capacity, utilization rates, and costs across
// On-Demand, Spot, and Capacity Reservations. Data can be grouped and filtered by
// various dimensions such as region, account, and instance family.
func (c *Client) GetCapacityManagerMetricData(ctx context.Context, params *GetCapacityManagerMetricDataInput, optFns ...func(*Options)) (*GetCapacityManagerMetricDataOutput, error) {
	if params == nil {
		params = &GetCapacityManagerMetricDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCapacityManagerMetricData", params, optFns, c.addOperationGetCapacityManagerMetricDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCapacityManagerMetricDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCapacityManagerMetricDataInput struct {

	//  The end time for the metric data query, in ISO 8601 format. If the end time is
	// beyond the latest ingested data, it will be automatically adjusted to the latest
	// available data point.
	//
	// This member is required.
	EndTime *time.Time

	//  The names of the metrics to retrieve. Maximum of 10 metrics per request.
	//
	// This member is required.
	MetricNames []types.Metric

	//  The granularity, in seconds, of the returned data points.
	//
	// This member is required.
	Period *int32

	//  The start time for the metric data query, in ISO 8601 format. The time range
	// (end time - start time) must be a multiple of the specified period.
	//
	// This member is required.
	StartTime *time.Time

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	//  Conditions to filter the metric data. Each filter specifies a dimension,
	// comparison operator ('equals', 'in'), and values to match against.
	FilterBy []types.CapacityManagerCondition

	//  The dimensions by which to group the metric data. This determines how the data
	// is aggregated and returned.
	GroupBy []types.GroupBy

	//  The maximum number of data points to return. Valid range is 1 to 100,000. Use
	// with NextToken for pagination of large result sets.
	MaxResults *int32

	//  The token for the next page of results. Use this value in a subsequent call to
	// retrieve additional data points.
	NextToken *string

	noSmithyDocumentSerde
}

type GetCapacityManagerMetricDataOutput struct {

	//  The metric data points returned by the query. Each result contains dimension
	// values, timestamp, and metric values with their associated statistics.
	MetricDataResults []types.MetricDataResult

	//  The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCapacityManagerMetricDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetCapacityManagerMetricData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetCapacityManagerMetricData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCapacityManagerMetricData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCapacityManagerMetricDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCapacityManagerMetricData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetCapacityManagerMetricDataPaginatorOptions is the paginator options for
// GetCapacityManagerMetricData
type GetCapacityManagerMetricDataPaginatorOptions struct {
	//  The maximum number of data points to return. Valid range is 1 to 100,000. Use
	// with NextToken for pagination of large result sets.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCapacityManagerMetricDataPaginator is a paginator for
// GetCapacityManagerMetricData
type GetCapacityManagerMetricDataPaginator struct {
	options   GetCapacityManagerMetricDataPaginatorOptions
	client    GetCapacityManagerMetricDataAPIClient
	params    *GetCapacityManagerMetricDataInput
	nextToken *string
	firstPage bool
}

// NewGetCapacityManagerMetricDataPaginator returns a new
// GetCapacityManagerMetricDataPaginator
func NewGetCapacityManagerMetricDataPaginator(client GetCapacityManagerMetricDataAPIClient, params *GetCapacityManagerMetricDataInput, optFns ...func(*GetCapacityManagerMetricDataPaginatorOptions)) *GetCapacityManagerMetricDataPaginator {
	if params == nil {
		params = &GetCapacityManagerMetricDataInput{}
	}

	options := GetCapacityManagerMetricDataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCapacityManagerMetricDataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCapacityManagerMetricDataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCapacityManagerMetricData page.
func (p *GetCapacityManagerMetricDataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCapacityManagerMetricDataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetCapacityManagerMetricData(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetCapacityManagerMetricDataAPIClient is a client that implements the
// GetCapacityManagerMetricData operation.
type GetCapacityManagerMetricDataAPIClient interface {
	GetCapacityManagerMetricData(context.Context, *GetCapacityManagerMetricDataInput, ...func(*Options)) (*GetCapacityManagerMetricDataOutput, error)
}

var _ GetCapacityManagerMetricDataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetCapacityManagerMetricData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCapacityManagerMetricData",
	}
}
