// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// WorkloadBindingApplyConfiguration represents a declarative configuration of the WorkloadBinding type for use
// with apply.
type WorkloadBindingApplyConfiguration struct {
	Group      *string                                     `json:"group,omitempty"`
	Resource   *string                                     `json:"resource,omitempty"`
	Name       *string                                     `json:"name,omitempty"`
	Namespace  *string                                     `json:"namespace,omitempty"`
	Conditions []ConfigResourceConditionApplyConfiguration `json:"conditions,omitempty"`
}

// WorkloadBindingApplyConfiguration constructs a declarative configuration of the WorkloadBinding type for use with
// apply.
func WorkloadBinding() *WorkloadBindingApplyConfiguration {
	return &WorkloadBindingApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *WorkloadBindingApplyConfiguration) WithGroup(value string) *WorkloadBindingApplyConfiguration {
	b.Group = &value
	return b
}

// WithResource sets the Resource field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resource field is set to the value of the last call.
func (b *WorkloadBindingApplyConfiguration) WithResource(value string) *WorkloadBindingApplyConfiguration {
	b.Resource = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *WorkloadBindingApplyConfiguration) WithName(value string) *WorkloadBindingApplyConfiguration {
	b.Name = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *WorkloadBindingApplyConfiguration) WithNamespace(value string) *WorkloadBindingApplyConfiguration {
	b.Namespace = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *WorkloadBindingApplyConfiguration) WithConditions(values ...*ConfigResourceConditionApplyConfiguration) *WorkloadBindingApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}
