// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ScopeProfiles is a collection of profiles from a LibraryInstrumentation.
type ScopeProfiles struct {
	Scope     InstrumentationScope
	Profiles  []*Profile
	SchemaUrl string
}

var (
	protoPoolScopeProfiles = sync.Pool{
		New: func() any {
			return &ScopeProfiles{}
		},
	}
)

func NewScopeProfiles() *ScopeProfiles {
	if !UseProtoPooling.IsEnabled() {
		return &ScopeProfiles{}
	}
	return protoPoolScopeProfiles.Get().(*ScopeProfiles)
}

func DeleteScopeProfiles(orig *ScopeProfiles, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteInstrumentationScope(&orig.Scope, false)
	for i := range orig.Profiles {
		DeleteProfile(orig.Profiles[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolScopeProfiles.Put(orig)
	}
}

func CopyScopeProfiles(dest, src *ScopeProfiles) *ScopeProfiles {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewScopeProfiles()
	}
	CopyInstrumentationScope(&dest.Scope, &src.Scope)

	dest.Profiles = CopyProfilePtrSlice(dest.Profiles, src.Profiles)

	dest.SchemaUrl = src.SchemaUrl

	return dest
}

func CopyScopeProfilesSlice(dest, src []ScopeProfiles) []ScopeProfiles {
	var newDest []ScopeProfiles
	if cap(dest) < len(src) {
		newDest = make([]ScopeProfiles, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeProfiles(&dest[i], false)
		}
	}
	for i := range src {
		CopyScopeProfiles(&newDest[i], &src[i])
	}
	return newDest
}

func CopyScopeProfilesPtrSlice(dest, src []*ScopeProfiles) []*ScopeProfiles {
	var newDest []*ScopeProfiles
	if cap(dest) < len(src) {
		newDest = make([]*ScopeProfiles, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeProfiles()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeProfiles(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeProfiles()
		}
	}
	for i := range src {
		CopyScopeProfiles(newDest[i], src[i])
	}
	return newDest
}

func (orig *ScopeProfiles) Reset() {
	*orig = ScopeProfiles{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ScopeProfiles) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	orig.Scope.MarshalJSON(dest)
	if len(orig.Profiles) > 0 {
		dest.WriteObjectField("profiles")
		dest.WriteArrayStart()
		orig.Profiles[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Profiles); i++ {
			dest.WriteMore()
			orig.Profiles[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ScopeProfiles) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "scope":

			orig.Scope.UnmarshalJSON(iter)
		case "profiles":
			for iter.ReadArray() {
				orig.Profiles = append(orig.Profiles, NewProfile())
				orig.Profiles[len(orig.Profiles)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ScopeProfiles) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Scope.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Profiles {
		l = orig.Profiles[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ScopeProfiles) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Scope.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Profiles) - 1; i >= 0; i-- {
		l = orig.Profiles[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *ScopeProfiles) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Scope.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Profiles", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Profiles = append(orig.Profiles, NewProfile())
			err = orig.Profiles[len(orig.Profiles)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestScopeProfiles() *ScopeProfiles {
	orig := NewScopeProfiles()
	orig.Scope = *GenTestInstrumentationScope()
	orig.Profiles = []*Profile{{}, GenTestProfile()}
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

func GenTestScopeProfilesPtrSlice() []*ScopeProfiles {
	orig := make([]*ScopeProfiles, 5)
	orig[0] = NewScopeProfiles()
	orig[1] = GenTestScopeProfiles()
	orig[2] = NewScopeProfiles()
	orig[3] = GenTestScopeProfiles()
	orig[4] = NewScopeProfiles()
	return orig
}

func GenTestScopeProfilesSlice() []ScopeProfiles {
	orig := make([]ScopeProfiles, 5)
	orig[1] = *GenTestScopeProfiles()
	orig[3] = *GenTestScopeProfiles()
	return orig
}
