/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.export;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.mediajson.Event;
import org.jitsi.mediajson.TranscriptionResultEvent;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.OptionalConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.export.Exporter;
import org.jitsi.videobridge.export.MediaJsonSerializer;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001&\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0006H\u0002J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\u00020\f2\u0006\u00102\u001a\u000203J\u0012\u00105\u001a\u00020\f2\b\b\u0002\u00106\u001a\u00020.H\u0002J\b\u00107\u001a\u00020\fH\u0002J\b\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u00020\fJ\u0006\u0010;\u001a\u00020\fJ\u0006\u0010<\u001a\u00020=R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jitsi/videobridge/export/Exporter;", "", "url", "Ljava/net/URI;", "httpHeaders", "", "", "logger", "Lorg/jitsi/utils/logging2/Logger;", "handleTranscriptionResult", "Lkotlin/Function1;", "Lorg/jitsi/mediajson/TranscriptionResultEvent;", "", "<init>", "(Ljava/net/URI;Ljava/util/Map;Lorg/jitsi/utils/logging2/Logger;Lkotlin/jvm/functions/Function1;)V", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "isShuttingDown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "reconnectAttempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "reconnectFuture", "Ljava/util/concurrent/ScheduledFuture;", "instancePacketsSent", "Ljava/util/concurrent/atomic/AtomicLong;", "instanceWebSocketFailures", "instanceWebSocketInternalErrors", "instanceStarts", "instanceTranscriptsReceived", "instanceOtherMessagesReceived", "instanceParseFailures", "queue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "getQueue", "()Lorg/jitsi/nlj/util/PacketInfoQueue;", "queue$delegate", "Lkotlin/Lazy;", "recorderWebSocket", "org/jitsi/videobridge/export/Exporter$recorderWebSocket$1", "Lorg/jitsi/videobridge/export/Exporter$recorderWebSocket$1;", "serializer", "Lorg/jitsi/videobridge/export/MediaJsonSerializer;", "initSerializer", "ws", "Lorg/eclipse/jetty/websocket/api/WebSocketAdapter;", "isConnected", "", "handleIncomingMessage", "message", "doHandlePacket", "packet", "Lorg/jitsi/nlj/PacketInfo;", "send", "scheduleReconnect", "maxDelay", "cancelReconnect", "createUpgradeRequest", "Lorg/eclipse/jetty/websocket/client/ClientUpgradeRequest;", "start", "stop", "debugState", "Lorg/json/simple/JSONObject;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exporter.kt\norg/jitsi/videobridge/export/Exporter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,298:1\n216#2,2:299\n103#3,6:301\n68#3,6:307\n68#3,6:313\n*S KotlinDebug\n*F\n+ 1 Exporter.kt\norg/jitsi/videobridge/export/Exporter\n*L\n202#1:299,2\n278#1:301,6\n282#1:307,6\n286#1:313,6\n*E\n"})
public final class Exporter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final URI url;
    @NotNull
    private final Map<String, String> httpHeaders;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function1<TranscriptionResultEvent, Unit> handleTranscriptionResult;
    @NotNull
    private final AtomicBoolean isShuttingDown;
    @NotNull
    private final AtomicInteger reconnectAttempts;
    @Nullable
    private ScheduledFuture<?> reconnectFuture;
    @NotNull
    private final AtomicLong instancePacketsSent;
    @NotNull
    private final AtomicLong instanceWebSocketFailures;
    @NotNull
    private final AtomicLong instanceWebSocketInternalErrors;
    @NotNull
    private final AtomicLong instanceStarts;
    @NotNull
    private final AtomicLong instanceTranscriptsReceived;
    @NotNull
    private final AtomicLong instanceOtherMessagesReceived;
    @NotNull
    private final AtomicLong instanceParseFailures;
    @NotNull
    private final Lazy queue$delegate;
    @NotNull
    private final recorderWebSocket.1 recorderWebSocket;
    @Nullable
    private MediaJsonSerializer serializer;
    @NotNull
    private static final WebSocketClient webSocketClient;
    @NotNull
    private static final CounterMetric webSocketFailures;
    @NotNull
    private static final CounterMetric webSocketInternalErrors;
    @NotNull
    private static final CounterMetric startsCount;
    @NotNull
    private static final CounterMetric packetsSentCount;
    @NotNull
    private static final CounterMetric transcriptsReceivedCount;
    @NotNull
    private static final CounterMetric otherMessagesReceivedCount;
    @NotNull
    private static final CounterMetric parseFailuresCount;
    @NotNull
    private static final OptionalConfigDelegate<Integer> maxReconnectAttempts$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> baseDelay$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> maxDelay$delegate;

    public Exporter(@NotNull URI url, @NotNull Map<String, String> httpHeaders, @NotNull Logger logger, @NotNull Function1<? super TranscriptionResultEvent, Unit> handleTranscriptionResult) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(handleTranscriptionResult, (String)"handleTranscriptionResult");
        this.url = url;
        this.httpHeaders = httpHeaders;
        this.logger = logger;
        this.handleTranscriptionResult = handleTranscriptionResult;
        this.isShuttingDown = new AtomicBoolean(false);
        this.reconnectAttempts = new AtomicInteger(0);
        this.instancePacketsSent = new AtomicLong(0L);
        this.instanceWebSocketFailures = new AtomicLong(0L);
        this.instanceWebSocketInternalErrors = new AtomicLong(0L);
        this.instanceStarts = new AtomicLong(0L);
        this.instanceTranscriptsReceived = new AtomicLong(0L);
        this.instanceOtherMessagesReceived = new AtomicLong(0L);
        this.instanceParseFailures = new AtomicLong(0L);
        this.queue$delegate = LazyKt.lazy(() -> Exporter.queue_delegate$lambda$0(this));
        this.recorderWebSocket = new WebSocketAdapter(this){
            final /* synthetic */ Exporter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebSocketClose(int statusCode, String reason) {
                boolean internalError;
                super.onWebSocketClose(statusCode, reason);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().info((Object)("Websocket closed with status " + statusCode + ", reason: " + reason));
                boolean bl2 = internalError = statusCode == 1011;
                if (internalError) {
                    CounterMetric.inc$default((CounterMetric)Exporter.access$getWebSocketInternalErrors$cp(), null, (int)1, null);
                    Exporter.access$getInstanceWebSocketInternalErrors$p(exporter).incrementAndGet();
                }
                if (!Exporter.access$isShuttingDown$p(exporter).get()) {
                    Exporter.access$scheduleReconnect(exporter, internalError);
                }
            }

            public void onWebSocketConnect(Session session) {
                super.onWebSocketConnect(session);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().info((Object)("Websocket connected: " + this.isConnected()));
                Exporter.access$setSerializer$p(exporter, Exporter.access$initSerializer(exporter, this));
                Exporter.access$getReconnectAttempts$p(exporter).set(0);
                Exporter.access$cancelReconnect(exporter);
            }

            public void onWebSocketError(Throwable cause) {
                super.onWebSocketError(cause);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().error((Object)"Websocket error", cause);
                CounterMetric.inc$default((CounterMetric)Exporter.access$getWebSocketFailures$cp(), null, (int)1, null);
                Exporter.access$getInstanceWebSocketFailures$p(exporter).incrementAndGet();
                if (!Exporter.access$isShuttingDown$p(exporter).get()) {
                    Exporter.scheduleReconnect$default(exporter, false, 1, null);
                }
            }

            public void onWebSocketText(String message) {
                block0: {
                    super.onWebSocketText(message);
                    Unit unit = Unit.INSTANCE;
                    Exporter exporter = this.this$0;
                    Unit it = unit;
                    boolean bl = false;
                    String string = message;
                    if (string == null) break block0;
                    String it2 = string;
                    boolean bl2 = false;
                    Exporter.access$handleIncomingMessage(exporter, it2);
                }
            }
        };
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final PacketInfoQueue getQueue() {
        Lazy lazy = this.queue$delegate;
        return (PacketInfoQueue)lazy.getValue();
    }

    private final MediaJsonSerializer initSerializer(WebSocketAdapter ws) {
        return new MediaJsonSerializer((Function1<? super Event, Unit>)((Function1)arg_0 -> Exporter.initSerializer$lambda$0(ws, this, arg_0)));
    }

    public final boolean isConnected() {
        return this.recorderWebSocket.isConnected();
    }

    private final void handleIncomingMessage(String message) {
        try {
            Event event = Event.Companion.parse(message);
            this.logger.debug(() -> Exporter.handleIncomingMessage$lambda$0(event));
            if (event instanceof TranscriptionResultEvent) {
                CounterMetric.inc$default((CounterMetric)transcriptsReceivedCount, null, (int)1, null);
                this.instanceTranscriptsReceived.incrementAndGet();
                this.handleTranscriptionResult.invoke((Object)event);
            } else {
                CounterMetric.inc$default((CounterMetric)otherMessagesReceivedCount, null, (int)1, null);
                this.instanceOtherMessagesReceived.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to parse incoming websocket message: " + message), (Throwable)e);
            CounterMetric.inc$default((CounterMetric)parseFailuresCount, null, (int)1, null);
            this.instanceParseFailures.incrementAndGet();
        }
    }

    private final boolean doHandlePacket(PacketInfo packet) {
        if (this.recorderWebSocket.isConnected()) {
            MediaJsonSerializer mediaJsonSerializer = this.serializer;
            if (mediaJsonSerializer != null) {
                AudioRtpPacket audioRtpPacket = (AudioRtpPacket)packet.packetAs();
                String string = packet.getEndpointId();
                Intrinsics.checkNotNull((Object)string);
                mediaJsonSerializer.encode(audioRtpPacket, string);
            }
            CounterMetric.inc$default((CounterMetric)packetsSentCount, null, (int)1, null);
            this.instancePacketsSent.incrementAndGet();
        }
        ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        return true;
    }

    public final void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.recorderWebSocket.isConnected()) {
            this.getQueue().add((Object)packet);
        } else {
            ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        }
    }

    private final void scheduleReconnect(boolean maxDelay) {
        if (this.isShuttingDown.get()) {
            return;
        }
        int attempt = this.reconnectAttempts.incrementAndGet();
        Integer n = Exporter.Companion.getMaxReconnectAttempts();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (attempt > it) {
                this.logger.warn((Object)("Max reconnection attempts (" + it + ") reached, giving up"));
                return;
            }
        }
        long delayMs = maxDelay ? Duration.getInWholeMilliseconds-impl((long)Exporter.Companion.getMaxDelay-UwyO8pc()) : Exporter.Companion.getDelayMs(attempt);
        this.logger.info((Object)("Scheduling reconnection attempt " + attempt + " in " + delayMs + " ms"));
        this.cancelReconnect();
        this.reconnectFuture = TaskPools.SCHEDULED_POOL.schedule(() -> Exporter.scheduleReconnect$lambda$1(this, attempt), delayMs, TimeUnit.MILLISECONDS);
    }

    static /* synthetic */ void scheduleReconnect$default(Exporter exporter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        exporter.scheduleReconnect(bl);
    }

    private final void cancelReconnect() {
        ScheduledFuture<?> scheduledFuture = this.reconnectFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.reconnectFuture = null;
    }

    private final ClientUpgradeRequest createUpgradeRequest() {
        ClientUpgradeRequest clientUpgradeRequest;
        ClientUpgradeRequest $this$createUpgradeRequest_u24lambda_u240 = clientUpgradeRequest = new ClientUpgradeRequest();
        boolean bl = false;
        Map<String, String> $this$forEach$iv = this.httpHeaders;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String name = entry.getKey();
            String value = entry.getValue();
            $this$createUpgradeRequest_u24lambda_u240.setHeader(name, value);
        }
        return clientUpgradeRequest;
    }

    public final void start() {
        this.isShuttingDown.set(false);
        CounterMetric.inc$default((CounterMetric)startsCount, null, (int)1, null);
        this.instanceStarts.incrementAndGet();
        webSocketClient.connect((Object)this.recorderWebSocket, this.url, this.createUpgradeRequest());
    }

    public final void stop() {
        this.isShuttingDown.set(true);
        this.cancelReconnect();
        Session session = this.recorderWebSocket.getSession();
        if (session != null) {
            session.close(1001, "closing");
        }
        Session session2 = this.recorderWebSocket.getSession();
        if (session2 != null) {
            session2.disconnect();
        }
        this.getQueue().close();
    }

    @NotNull
    public final JSONObject debugState() {
        JSONObject jSONObject;
        JSONObject $this$debugState_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$debugState_u24lambda_u240.put((Object)"url", (Object)this.url.toString());
        $this$debugState_u24lambda_u240.put((Object)"is_connected", (Object)this.isConnected());
        $this$debugState_u24lambda_u240.put((Object)"is_shutting_down", (Object)this.isShuttingDown.get());
        $this$debugState_u24lambda_u240.put((Object)"reconnect_attempts", (Object)this.reconnectAttempts.get());
        $this$debugState_u24lambda_u240.put((Object)"packets_sent", (Object)this.instancePacketsSent.get());
        $this$debugState_u24lambda_u240.put((Object)"websocket_failures", (Object)this.instanceWebSocketFailures.get());
        $this$debugState_u24lambda_u240.put((Object)"websocket_internal_errors", (Object)this.instanceWebSocketInternalErrors.get());
        $this$debugState_u24lambda_u240.put((Object)"starts", (Object)this.instanceStarts.get());
        $this$debugState_u24lambda_u240.put((Object)"transcripts_received", (Object)this.instanceTranscriptsReceived.get());
        $this$debugState_u24lambda_u240.put((Object)"other_messages_received", (Object)this.instanceOtherMessagesReceived.get());
        $this$debugState_u24lambda_u240.put((Object)"parse_failures", (Object)this.instanceParseFailures.get());
        $this$debugState_u24lambda_u240.put((Object)"queue_size", (Object)this.getQueue().size());
        return jSONObject;
    }

    private static final PacketInfoQueue queue_delegate$lambda$0(Exporter this$0) {
        String string = this$0.getClass().getSimpleName() + "-packet-queue";
        ExecutorService executorService = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"IO_POOL");
        return new PacketInfoQueue(string, executorService, (Function1)new Function1<PacketInfo, Boolean>((Object)this$0){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Exporter.access$doHandlePacket((Exporter)this.receiver, p0);
            }
        }, 1024);
    }

    private static final Unit initSerializer$lambda$0(WebSocketAdapter $ws, Exporter this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($ws.isConnected()) {
            RemoteEndpoint remoteEndpoint = $ws.getRemote();
            if (remoteEndpoint != null) {
                remoteEndpoint.sendString(it.toJson());
            } else {
                this$0.logger.warn((Object)"Websocket is connected, but remote is null");
            }
        } else {
            this$0.logger.warn((Object)("Not connected, cannot send event: " + it));
        }
        return Unit.INSTANCE;
    }

    private static final String handleIncomingMessage$lambda$0(Event $event) {
        return "Received message from websocket: " + $event.toJson();
    }

    private static final void scheduleReconnect$lambda$1(Exporter this$0, int $attempt) {
        if (!this$0.isShuttingDown.get()) {
            try {
                this$0.logger.info((Object)("Attempting reconnection (attempt " + $attempt + ")"));
                webSocketClient.connect((Object)this$0.recorderWebSocket, this$0.url, this$0.createUpgradeRequest());
            }
            catch (Exception e) {
                this$0.logger.warn((Object)("Reconnection attempt " + $attempt + " failed"), (Throwable)e);
                Exporter.scheduleReconnect$default(this$0, false, 1, null);
            }
        }
    }

    public static final /* synthetic */ boolean access$doHandlePacket(Exporter $this, PacketInfo packet) {
        return $this.doHandlePacket(packet);
    }

    public static final /* synthetic */ CounterMetric access$getWebSocketInternalErrors$cp() {
        return webSocketInternalErrors;
    }

    public static final /* synthetic */ AtomicLong access$getInstanceWebSocketInternalErrors$p(Exporter $this) {
        return $this.instanceWebSocketInternalErrors;
    }

    public static final /* synthetic */ AtomicBoolean access$isShuttingDown$p(Exporter $this) {
        return $this.isShuttingDown;
    }

    public static final /* synthetic */ void access$scheduleReconnect(Exporter $this, boolean maxDelay) {
        $this.scheduleReconnect(maxDelay);
    }

    public static final /* synthetic */ void access$setSerializer$p(Exporter $this, MediaJsonSerializer mediaJsonSerializer) {
        $this.serializer = mediaJsonSerializer;
    }

    public static final /* synthetic */ MediaJsonSerializer access$initSerializer(Exporter $this, WebSocketAdapter ws) {
        return $this.initSerializer(ws);
    }

    public static final /* synthetic */ AtomicInteger access$getReconnectAttempts$p(Exporter $this) {
        return $this.reconnectAttempts;
    }

    public static final /* synthetic */ void access$cancelReconnect(Exporter $this) {
        $this.cancelReconnect();
    }

    public static final /* synthetic */ CounterMetric access$getWebSocketFailures$cp() {
        return webSocketFailures;
    }

    public static final /* synthetic */ AtomicLong access$getInstanceWebSocketFailures$p(Exporter $this) {
        return $this.instanceWebSocketFailures;
    }

    public static final /* synthetic */ void access$handleIncomingMessage(Exporter $this, String message) {
        $this.handleIncomingMessage(message);
    }

    static {
        SupplierBuilder supplierBuilder;
        WebSocketClient webSocketClient;
        Companion = new Companion(null);
        WebSocketClient $this$webSocketClient_u24lambda_u240 = webSocketClient = new WebSocketClient();
        boolean bl = false;
        $this$webSocketClient_u24lambda_u240.setIdleTimeout(WebsocketServiceConfig.config.getIdleTimeout());
        $this$webSocketClient_u24lambda_u240.start();
        Exporter.webSocketClient = webSocketClient;
        webSocketFailures = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_websocket_failures", (String)"Number of websocket connection failures from Exporter", (long)0L, null, (int)12, null);
        webSocketInternalErrors = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_websocket_internal_errors", (String)"Number of websocket connection which were connected but closed with code 1011", (long)0L, null, (int)12, null);
        startsCount = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_starts", (String)"Number of times Exporter has been started", (long)0L, null, (int)12, null);
        packetsSentCount = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_packets_sent", (String)"Number of packets sent by Exporter", (long)0L, null, (int)12, null);
        transcriptsReceivedCount = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_transcripts_received", (String)"Number of transcription results received by Exporter", (long)0L, null, (int)12, null);
        otherMessagesReceivedCount = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_other_messages_received", (String)"Number of non-transcription messages received by Exporter", (long)0L, null, (int)12, null);
        parseFailuresCount = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"exporter_parse_failures", (String)"Number of messages that failed to parse", (long)0L, null, (int)12, null);
        boolean $i$f$optionalconfig = false;
        SupplierBuilder $this$maxReconnectAttempts_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl2 = false;
        $this$maxReconnectAttempts_delegate_u24lambda_u240.from("videobridge.exporter.max-reconnect-attempts", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        maxReconnectAttempts$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new OptionalConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new OptionalConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        boolean $i$f$config = false;
        SupplierBuilder $this$baseDelay_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl3 = false;
        $this$baseDelay_delegate_u24lambda_u240.from("videobridge.exporter.base-delay", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        baseDelay$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$maxDelay_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl4 = false;
        $this$maxDelay_delegate_u24lambda_u240.from("videobridge.exporter.max-delay", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        maxDelay$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/jitsi/videobridge/export/Exporter$Companion;", "", "<init>", "()V", "webSocketClient", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "webSocketFailures", "Lorg/jitsi/metrics/CounterMetric;", "webSocketInternalErrors", "startsCount", "packetsSentCount", "transcriptsReceivedCount", "otherMessagesReceivedCount", "parseFailuresCount", "maxReconnectAttempts", "", "getMaxReconnectAttempts", "()Ljava/lang/Integer;", "maxReconnectAttempts$delegate", "Lorg/jitsi/metaconfig/OptionalConfigDelegate;", "baseDelay", "Lkotlin/time/Duration;", "getBaseDelay-UwyO8pc", "()J", "baseDelay$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "maxDelay", "getMaxDelay-UwyO8pc", "maxDelay$delegate", "getDelayMs", "", "attempt", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Integer getMaxReconnectAttempts() {
            return (Integer)maxReconnectAttempts$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final long getBaseDelay-UwyO8pc() {
            return ((Duration)baseDelay$delegate.getValue((Object)this, $$delegatedProperties[1])).unbox-impl();
        }

        private final long getMaxDelay-UwyO8pc() {
            return ((Duration)maxDelay$delegate.getValue((Object)this, $$delegatedProperties[2])).unbox-impl();
        }

        private final long getDelayMs(int attempt) {
            return attempt == 1 ? 0L : Math.min(Duration.getInWholeMilliseconds-impl((long)this.getBaseDelay-UwyO8pc()) * (long)Math.pow(2.0, attempt - 2), Duration.getInWholeMilliseconds-impl((long)this.getMaxDelay-UwyO8pc()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "maxReconnectAttempts", "getMaxReconnectAttempts()Ljava/lang/Integer;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "baseDelay", "getBaseDelay-UwyO8pc()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "maxDelay", "getMaxDelay-UwyO8pc()J", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

