/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PartitionHeader {
    ExtentAD unallocatedSpaceTable;
    ExtentAD unallocatedSpaceBitmap;
    ExtentAD partitionIntegrityTable;
    ExtentAD freedSpaceTable;
    ExtentAD freedSpaceBitmap;
    public static final int LENGTH = 128;

    public PartitionHeader(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
    }

    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 128) {
            throw new InvalidDescriptor("Partition header allocation descriptor too short");
        }
        this.unallocatedSpaceTable = new ExtentAD(UDFUtil.getBytes(byArray, 0, 8));
        this.unallocatedSpaceBitmap = new ExtentAD(UDFUtil.getBytes(byArray, 8, 8));
        this.partitionIntegrityTable = new ExtentAD(UDFUtil.getBytes(byArray, 16, 8));
        this.freedSpaceTable = new ExtentAD(UDFUtil.getBytes(byArray, 24, 8));
        this.freedSpaceBitmap = new ExtentAD(UDFUtil.getBytes(byArray, 32, 8));
    }
}

