/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb.entities;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.BaseJsonEntity;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.imdb.entities.ImdbEpisodeListEpisode;
import org.tinymediamanager.scraper.imdb.entities.ImdbEpisodeListEpisodes;
import org.tinymediamanager.scraper.imdb.entities.ImdbIdValueType;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbEpisodeList
extends BaseJsonEntity {
    public ImdbEpisodeListEpisodes episodes = null;
    public List<ImdbIdValueType> seasons = null;
    public List<ImdbIdValueType> years = null;

    public List<MediaMetadata> getEpisodes() {
        ArrayList<MediaMetadata> eps = new ArrayList<MediaMetadata>();
        if (this.episodes != null) {
            for (ImdbEpisodeListEpisode ep : ListUtils.nullSafe(this.episodes.items)) {
                MediaMetadata md = new MediaMetadata("imdb");
                md.setTitle(ep.titleText);
                md.setPlot(ep.plot);
                md.setId("imdb", ep.id);
                MediaEpisodeGroup eg = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                int s = MetadataUtil.parseInt(ep.season, -1);
                int e = MetadataUtil.parseInt(ep.episode, -1);
                if (e < 0 || s < 0) continue;
                md.setEpisodeNumber(new MediaEpisodeNumber(eg, s, e));
                if (ep.image != null) {
                    MediaArtwork img = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.THUMB);
                    img.setOriginalUrl(ep.image.url);
                    img.setSeason(s);
                    img.addImageSize(ep.image.getWidth(), ep.image.getHeight(), ep.image.url, MediaArtwork.ThumbSizes.getSizeOrder(ep.image.getWidth()));
                    md.addMediaArt(img);
                }
                if (ep.aggregateRating > 0.0) {
                    MediaRating rat = new MediaRating("imdb");
                    rat.setMaxValue(10);
                    rat.setRating(ep.aggregateRating);
                    rat.setVotes(ep.voteCount);
                    md.addRating(rat);
                }
                md.setYear(ep.releaseYear);
                if (ep.releaseDate != null) {
                    md.setReleaseDate(ep.releaseDate.toDate());
                }
                eps.add(md);
            }
        }
        return eps;
    }
}

