/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MoviePostProcessExecutor;
import org.tinymediamanager.core.threading.NullTasksMenu;
import org.tinymediamanager.license.License;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmLazyMenuAdapter;
import org.tinymediamanager.ui.components.MenuScroller;
import org.tinymediamanager.ui.components.tabbedpane.MainTabbedPane;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.actions.DebugDumpMovieAction;
import org.tinymediamanager.ui.movies.actions.MovieAddDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieAspectRatioDetectAction;
import org.tinymediamanager.ui.movies.actions.MovieAssignMovieSetAction;
import org.tinymediamanager.ui.movies.actions.MovieBulkEditAction;
import org.tinymediamanager.ui.movies.actions.MovieChangeDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieChecksumAction;
import org.tinymediamanager.ui.movies.actions.MovieCleanUpFilesAction;
import org.tinymediamanager.ui.movies.actions.MovieClearImageCacheAction;
import org.tinymediamanager.ui.movies.actions.MovieCopyToAction;
import org.tinymediamanager.ui.movies.actions.MovieCreateOfflineAction;
import org.tinymediamanager.ui.movies.actions.MovieDeleteAction;
import org.tinymediamanager.ui.movies.actions.MovieDownloadActorImagesAction;
import org.tinymediamanager.ui.movies.actions.MovieDownloadMissingArtworkAction;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.actions.MovieExportAction;
import org.tinymediamanager.ui.movies.actions.MovieFetchImdbTop250;
import org.tinymediamanager.ui.movies.actions.MovieFetchRatingsAction;
import org.tinymediamanager.ui.movies.actions.MovieFindMissingAction;
import org.tinymediamanager.ui.movies.actions.MovieLockAction;
import org.tinymediamanager.ui.movies.actions.MovieMediaInformationAction;
import org.tinymediamanager.ui.movies.actions.MovieOpenFolderAction;
import org.tinymediamanager.ui.movies.actions.MoviePlayAction;
import org.tinymediamanager.ui.movies.actions.MovieReadNfoAction;
import org.tinymediamanager.ui.movies.actions.MovieRebuildImageCacheAction;
import org.tinymediamanager.ui.movies.actions.MovieRebuildMediainfoXmlAction;
import org.tinymediamanager.ui.movies.actions.MovieRemoveAction;
import org.tinymediamanager.ui.movies.actions.MovieRenameAction;
import org.tinymediamanager.ui.movies.actions.MovieRenamePreviewAction;
import org.tinymediamanager.ui.movies.actions.MovieResetNewFlagAction;
import org.tinymediamanager.ui.movies.actions.MovieRewriteNfoAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeMetadataAction;
import org.tinymediamanager.ui.movies.actions.MovieSingleScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleSearchAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedCollectionTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedRatingTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedWatchedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieToggleWatchedFlagAction;
import org.tinymediamanager.ui.movies.actions.MovieTrailerDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieTraktTvRemoveFromCollectionAction;
import org.tinymediamanager.ui.movies.actions.MovieTraktTvRemoveFromWatchedAction;
import org.tinymediamanager.ui.movies.actions.MovieUndoRenameAction;
import org.tinymediamanager.ui.movies.actions.MovieUnlockAction;
import org.tinymediamanager.ui.movies.actions.MovieUnscrapedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateSingleDatasourceAction;
import org.tinymediamanager.ui.movies.dialogs.MovieFilterDialog;
import org.tinymediamanager.ui.movies.panels.MovieArtworkPanel;
import org.tinymediamanager.ui.movies.panels.MovieCastPanel;
import org.tinymediamanager.ui.movies.panels.MovieInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieListPanel;
import org.tinymediamanager.ui.movies.panels.MovieMediaInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieTrailerPanel;
import org.tinymediamanager.ui.movies.settings.MovieSettingsNode;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;

public class MovieUIModule
extends AbstractTmmUIModule {
    private static final String ID = "movies";
    private static MovieUIModule instance = null;
    private final MovieListPanel listPanel = new MovieListPanel();
    private final JPanel detailPanel;
    private final MovieSelectionModel selectionModel = this.listPanel.getSelectionModel();
    private final MovieFilterDialog movieFilterDialog;
    private final TmmSettingsNode settingsNode;

    private MovieUIModule() {
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[grow]"));
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)dataPanel, "cell 0 0, grow");
        MainTabbedPane tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(TmmResourceBundle.getString("metatag.details"), new MovieInformationPanel(this.selectionModel));
        tabbedPane.add(TmmResourceBundle.getString("metatag.cast"), new MovieCastPanel(this.selectionModel));
        tabbedPane.add(TmmResourceBundle.getString("metatag.mediafiles"), new MovieMediaInformationPanel(this.selectionModel));
        tabbedPane.add(TmmResourceBundle.getString("metatag.artwork"), new MovieArtworkPanel(this.selectionModel));
        tabbedPane.add(TmmResourceBundle.getString("metatag.trailer"), new MovieTrailerPanel(this.selectionModel));
        dataPanel.add(tabbedPane);
        this.movieFilterDialog = new MovieFilterDialog(this.selectionModel);
        this.createActions();
        this.createMenus();
        this.createPopupMenu();
        this.registerAccelerators();
        this.settingsNode = new MovieSettingsNode();
        this.init();
    }

    private void init() {
        if (MovieModuleManager.getInstance().getSettings().isStoreUiFilters()) {
            SwingUtilities.invokeLater(() -> {
                MovieModuleManager.getInstance().getMovieList().searchDuplicates();
                this.selectionModel.setFilterValues(MovieModuleManager.getInstance().getSettings().getUiFilters());
            });
        }
        this.listPanel.init();
    }

    public static MovieUIModule getInstance() {
        if (instance == null) {
            instance = new MovieUIModule();
        }
        return instance;
    }

    public MovieSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void createActions() {
        this.searchAction = this.createAndRegisterAction(MovieSingleScrapeAction.class);
        this.editAction = this.createAndRegisterAction(MovieEditAction.class);
        this.updateAction = this.createAndRegisterAction(MovieUpdateDatasourceAction.class);
        this.renameAction = this.createAndRegisterAction(MovieRenameAction.class);
    }

    private void createMenus() {
        this.updatePopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.update"));
        this.updatePopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.update"));
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieUpdateDatasourceAction.class));
        JMenu datasourcesMenu = new JMenu(TmmResourceBundle.getString("metatag.datasource"));
        datasourcesMenu.setIcon(IconManager.MENU);
        MenuScroller.setScrollerFor(datasourcesMenu, 20, 50, 0, 0);
        datasourcesMenu.getPopupMenu().addPopupMenuListener(new TmmLazyMenuAdapter(){

            @Override
            protected void menuWillBecomeVisible(JMenu menu) {
                menu.removeAll();
                for (String ds : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
                    menu.add(new MovieUpdateSingleDatasourceAction(ds));
                }
            }
        });
        this.updatePopupMenu.add(datasourcesMenu);
        this.updatePopupMenu.addSeparator();
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieUpdateAction.class));
        this.updatePopupMenu.addSeparator();
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieFindMissingAction.class));
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieCreateOfflineAction.class));
        this.updatePopupMenu.addSeparator();
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieAddDatasourceAction.class));
        this.searchPopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.search"));
        this.searchPopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.search"));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSingleScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeMetadataAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieUnscrapedScrapeAction.class));
        this.editPopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.edit"));
        this.editPopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.edit"));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieBulkEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieLockAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieUnlockAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieToggleWatchedFlagAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieFetchRatingsAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieFetchImdbTop250.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieAssignMovieSetAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieChangeDatasourceAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRewriteNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieReadNfoAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieMediaInformationAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRebuildMediainfoXmlAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieAspectRatioDetectAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRebuildImageCacheAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieResetNewFlagAction.class));
        this.editPopupMenu.addSeparator();
        JMenu downloadMenu = new JMenu(TmmResourceBundle.getString("tmm.download"));
        downloadMenu.setIcon(IconManager.MENU);
        downloadMenu.add(this.createAndRegisterAction(MovieDownloadMissingArtworkAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieDownloadActorImagesAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieTrailerDownloadAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieSubtitleSearchAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieSubtitleDownloadAction.class));
        this.editPopupMenu.add(downloadMenu);
        this.editPopupMenu.addSeparator();
        JMenu traktMenu = new JMenu("Trakt.tv");
        traktMenu.setIcon(IconManager.MENU);
        traktMenu.add(this.createAndRegisterAction(MovieSyncTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedCollectionTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedWatchedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedRatingTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(MovieTraktTvRemoveFromCollectionAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieTraktTvRemoveFromWatchedAction.class));
        this.editPopupMenu.add(traktMenu);
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieExportAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieCopyToAction.class));
        this.renamePopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.rename"));
        this.renamePopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.rename"));
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieRenameAction.class));
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieRenamePreviewAction.class));
        this.renamePopupMenu.addSeparator();
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieUndoRenameAction.class));
        this.renamePopupMenu.addSeparator();
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieCleanUpFilesAction.class));
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieClearImageCacheAction.class));
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createAndRegisterAction(MovieSingleScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeMetadataAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieUnscrapedScrapeAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieUpdateAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieReadNfoAction.class));
        JMenu updateDatasourcesMenu = new JMenu(TmmResourceBundle.getString("Toolbar.update"));
        updateDatasourcesMenu.setIcon(IconManager.MENU);
        updateDatasourcesMenu.add(this.createAndRegisterAction(MovieUpdateDatasourceAction.class));
        JMenu datasourcesMenu = new JMenu(TmmResourceBundle.getString("metatag.datasource"));
        datasourcesMenu.setIcon(IconManager.MENU);
        MenuScroller.setScrollerFor(datasourcesMenu, 20, 50, 2, 5);
        datasourcesMenu.getPopupMenu().addPopupMenuListener(new TmmLazyMenuAdapter(){

            @Override
            protected void menuWillBecomeVisible(JMenu menu) {
                menu.removeAll();
                for (String ds : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
                    menu.add(new MovieUpdateSingleDatasourceAction(ds));
                }
            }
        });
        updateDatasourcesMenu.add(datasourcesMenu);
        updateDatasourcesMenu.addSeparator();
        updateDatasourcesMenu.add(this.createAndRegisterAction(MovieFindMissingAction.class));
        updateDatasourcesMenu.add(this.createAndRegisterAction(MovieCreateOfflineAction.class));
        updateDatasourcesMenu.addSeparator();
        updateDatasourcesMenu.add(this.createAndRegisterAction(MovieAddDatasourceAction.class));
        this.popupMenu.add(updateDatasourcesMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieEditAction.class));
        JMenu enhancededitPopupMenu = new JMenu(TmmResourceBundle.getString("edit.enhanced"));
        enhancededitPopupMenu.setIcon(IconManager.MENU);
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieBulkEditAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieLockAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieUnlockAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieToggleWatchedFlagAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieFetchRatingsAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieFetchImdbTop250.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieAssignMovieSetAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieChangeDatasourceAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieRewriteNfoAction.class));
        enhancededitPopupMenu.addSeparator();
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieMediaInformationAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieRebuildMediainfoXmlAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieAspectRatioDetectAction.class));
        enhancededitPopupMenu.addSeparator();
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieRebuildImageCacheAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieResetNewFlagAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(MovieChecksumAction.class));
        this.popupMenu.add(enhancededitPopupMenu);
        JMenu downloadMenu = new JMenu(TmmResourceBundle.getString("tmm.download"));
        downloadMenu.setIcon(IconManager.MENU);
        downloadMenu.add(this.createAndRegisterAction(MovieDownloadMissingArtworkAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieDownloadActorImagesAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieTrailerDownloadAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieSubtitleSearchAction.class));
        downloadMenu.add(this.createAndRegisterAction(MovieSubtitleDownloadAction.class));
        this.popupMenu.add(downloadMenu);
        JMenu renamePopupMenu = new JMenu(TmmResourceBundle.getString("Toolbar.rename"));
        renamePopupMenu.setIcon(IconManager.MENU);
        renamePopupMenu.add(this.createAndRegisterAction(MovieRenameAction.class));
        renamePopupMenu.add(this.createAndRegisterAction(MovieRenamePreviewAction.class));
        renamePopupMenu.addSeparator();
        renamePopupMenu.add(this.createAndRegisterAction(MovieUndoRenameAction.class));
        renamePopupMenu.addSeparator();
        renamePopupMenu.add(this.createAndRegisterAction(MovieCleanUpFilesAction.class));
        renamePopupMenu.add(this.createAndRegisterAction(MovieClearImageCacheAction.class));
        this.popupMenu.add(renamePopupMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieExportAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieCopyToAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MoviePlayAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieOpenFolderAction.class));
        this.popupMenu.addSeparator();
        final JMenu traktMenu = new JMenu("Trakt.tv");
        traktMenu.setIcon(IconManager.MENU);
        traktMenu.add(this.createAndRegisterAction(MovieSyncTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedCollectionTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedWatchedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSyncSelectedRatingTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(MovieTraktTvRemoveFromCollectionAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieTraktTvRemoveFromWatchedAction.class));
        this.popupMenu.add(traktMenu);
        final JMenu kodiRPCMenu = KodiRPCMenu.createMenuKodiMenuRightClickMovies();
        this.popupMenu.add(kodiRPCMenu);
        final JMenu postProcessingMenu = new JMenu(TmmResourceBundle.getString("Settings.postprocessing"));
        postProcessingMenu.setIcon(IconManager.MENU);
        this.popupMenu.add(postProcessingMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieRemoveAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieDeleteAction.class));
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpMovieAction());
            debugMenu.add(NullTasksMenu.createTaskManagerTestMenu());
            this.popupMenu.addSeparator();
            this.popupMenu.add(debugMenu);
        }
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                    kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                    kodiRPCMenu.setEnabled(true);
                } else {
                    kodiRPCMenu.setText("Kodi");
                    kodiRPCMenu.setEnabled(false);
                }
                if (License.getInstance().isValidLicense() && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getTraktAccessToken())) {
                    traktMenu.setEnabled(true);
                } else {
                    traktMenu.setEnabled(false);
                }
                postProcessingMenu.removeAll();
                for (PostProcess process : new ArrayList<PostProcess>(MovieModuleManager.getInstance().getSettings().getPostProcess())) {
                    JMenuItem menuItem = new JMenuItem(process.getName(), IconManager.APPLY);
                    menuItem.addActionListener(pp -> new MoviePostProcessExecutor(process).execute());
                    postProcessingMenu.add(menuItem);
                }
                if (postProcessingMenu.getItemCount() == 0) {
                    postProcessingMenu.setEnabled(false);
                } else {
                    postProcessingMenu.setEnabled(true);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.listPanel.setPopupMenu(this.popupMenu);
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.listPanel;
    }

    @Override
    public String getTabTitle() {
        return TmmResourceBundle.getString("tmm.movies");
    }

    @Override
    public ImageIcon getMenuIcon() {
        return IconManager.MENU_MOVIES;
    }

    @Override
    public ImageIcon getMenuActiveIcon() {
        return IconManager.MENU_MOVIES_ACTIVE;
    }

    @Override
    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    public void setFilterDialogVisible(boolean selected) {
        this.movieFilterDialog.setVisible(selected);
    }
}

