/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.List;

public interface ScraperMetadataConfig {
    public Type getType();

    public String getDescription();

    public String getToolTip();

    default public boolean isMetaData() {
        return this.getType() == Type.METADATA;
    }

    default public boolean isArtwork() {
        return this.getType() == Type.ARTWORK;
    }

    default public boolean isCast() {
        return this.getType() == Type.CAST;
    }

    public static boolean containsAnyMetadata(List<? extends ScraperMetadataConfig> config) {
        for (ScraperMetadataConfig scraperMetadataConfig : config) {
            if (!scraperMetadataConfig.isMetaData()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyArtwork(List<? extends ScraperMetadataConfig> config) {
        for (ScraperMetadataConfig scraperMetadataConfig : config) {
            if (!scraperMetadataConfig.isArtwork()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyCast(List<? extends ScraperMetadataConfig> config) {
        for (ScraperMetadataConfig scraperMetadataConfig : config) {
            if (!scraperMetadataConfig.isCast()) continue;
            return true;
        }
        return false;
    }

    public static enum Type {
        METADATA,
        CAST,
        ARTWORK,
        THEME,
        DEPRECATED;

    }
}

