/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.mediainfo;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.mediainfo.MediaInfoFile;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaInfoXmlCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoXmlCreator.class);
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    private static final Pattern FIRST_CHARACTER_DIGIT_PATTERN = Pattern.compile("^\\d");
    private Document document;
    private final MediaFile mediaFile;
    private final List<MediaInfoFile> mediaInfoFiles;

    public MediaInfoXmlCreator(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        this.mediaFile = mediaFile;
        this.mediaInfoFiles = mediaInfoFiles;
    }

    public void write() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.document = factory.newDocumentBuilder().newDocument();
        this.document.setXmlStandalone(true);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dat = formatter.format((Object)new Date());
        this.document.appendChild(this.document.createComment("created on " + dat + " - tinyMediaManager " + Settings.getInstance().getVersion()));
        Element mediaInfo = this.document.createElement("MediaInfo");
        mediaInfo.setAttribute("xmlns", "https://mediaarea.net/mediainfo");
        mediaInfo.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        mediaInfo.setAttribute("version", "2.0");
        this.document.appendChild(mediaInfo);
        Element creatingLibrary = this.document.createElement("creatingLibrary");
        creatingLibrary.setAttribute("version", ReleaseInfo.getVersion());
        creatingLibrary.setAttribute("url", "https://www.tinymediamanager.org");
        creatingLibrary.setTextContent("tinyMediaManager");
        mediaInfo.appendChild(creatingLibrary);
        boolean hasValidTracks = false;
        for (MediaInfoFile mediaInfoFile : this.mediaInfoFiles) {
            Element media = this.document.createElement("media");
            File file = new File(mediaInfoFile.getPath(), mediaInfoFile.getFilename());
            media.setAttribute("ref", file.getAbsolutePath());
            for (Map.Entry<MediaInfo.StreamKind, List<Map<String, String>>> entry : mediaInfoFile.getSnapshot().entrySet()) {
                for (Map<String, String> map : entry.getValue()) {
                    Element track = this.document.createElement("track");
                    track.setAttribute("type", entry.getKey().name());
                    switch (MediaInfo.StreamKind.valueOf(entry.getKey().name())) {
                        case Audio: 
                        case Video: 
                        case Text: {
                            hasValidTracks = true;
                            break;
                        }
                    }
                    String streamKindPos = map.get("StreamKindPos");
                    if (StringUtils.isNotBlank((CharSequence)streamKindPos)) {
                        track.setAttribute("typeorder", streamKindPos);
                    }
                    map.forEach((tag, content) -> this.addItems(track, (String)tag, (String)content));
                    media.appendChild(track);
                }
            }
            mediaInfo.appendChild(media);
        }
        if (!hasValidTracks) {
            return;
        }
        File file = new File(this.mediaFile.getPath(), this.mediaFile.getMediaInfoXmlFilename());
        try (FileWriter out = new FileWriter(file);){
            this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
        }
    }

    private void addItems(Element track, String tag, String textContent) {
        try {
            Element item = this.document.createElement(this.cleanTag(tag));
            item.setTextContent(this.cleanTextContent(tag, textContent));
            track.appendChild(item);
        }
        catch (Exception e) {
            LOGGER.trace("Could not write tag {}={} - {}", new Object[]{tag, textContent, e.getMessage()});
        }
    }

    private String cleanTag(String tag) {
        Object normalizedTag = tag.replace("(", "");
        normalizedTag = ((String)normalizedTag).replace(")", "");
        normalizedTag = ((String)normalizedTag).replace('/', '_');
        normalizedTag = ((String)normalizedTag).replace('*', '_');
        normalizedTag = ((String)normalizedTag).replace(':', '_');
        normalizedTag = ((String)normalizedTag).replace('.', '_');
        normalizedTag = ((String)normalizedTag).replace(' ', '_');
        if (FIRST_CHARACTER_DIGIT_PATTERN.matcher((CharSequence)(normalizedTag = ((String)normalizedTag).replace("&", "_"))).find()) {
            normalizedTag = "_" + (String)normalizedTag;
        }
        return normalizedTag;
    }

    private String cleanTextContent(String tag, String textContent) {
        if ("duration".equalsIgnoreCase(tag)) {
            try {
                double value = Double.parseDouble(textContent);
                return String.format(Locale.US, "%.3f", value /= 1000.0);
            }
            catch (Exception e) {
                LOGGER.trace("could not re-format duration - {}", (Object)e.getMessage());
            }
        }
        return this.stripNonValidXMLCharacters(textContent);
    }

    public String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    private Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transformer;
    }
}

