/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableColumnModel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.ConnectorTableModel;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableModel;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCheckRenderDataProvider;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableModel;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableRenderDataProvider;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableTreePathSupport;

public class TmmTreeTable
extends TmmTable {
    protected final TmmTreeDataProvider<TmmTreeNode> dataProvider;
    protected final Set<ITmmTreeFilter<TmmTreeNode>> treeFilters;
    protected TmmTreeTableRenderDataProvider renderDataProvider = null;
    protected int selectedRow = -1;
    protected Boolean cachedRootVisible = true;
    protected ITmmTreeTableModel treeTableModel;
    protected PropertyChangeListener filterChangeListener;
    private int[] lastEditPosition;

    public TmmTreeTable(TmmTreeDataProvider<TmmTreeNode> dataProvider, TmmTreeTableFormat<TmmTreeNode> tableFormat) {
        this.dataProvider = dataProvider;
        this.treeFilters = new CopyOnWriteArraySet<ITmmTreeFilter<TmmTreeNode>>();
        this.treeTableModel = new TmmTreeTableModel(new TmmTreeModelConnector<TmmTreeNode>(dataProvider), tableFormat);
        this.filterChangeListener = evt -> {
            this.updateFiltering();
            this.storeFilters();
        };
        this.setModel(this.treeTableModel);
        this.initTreeTable();
    }

    @Override
    public void addColumn(@NotNull TableColumn aColumn) {
        if (aColumn.getIdentifier() == null && this.getModel() instanceof TmmTreeTableModel) {
            aColumn.setHeaderRenderer(new TmmTable.SortableIconHeaderRenderer());
            TmmTreeTableModel tableModel = (TmmTreeTableModel)this.getModel();
            tableModel.setUpColumn(aColumn);
        }
        super.addColumn(aColumn);
    }

    protected void initTreeTable() {
        this.getSelectionModel().addListSelectionListener(e -> {
            this.selectedRow = this.getSelectedRowCount() == 1 ? this.getSelectedRow() : -1;
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.addKeyListener(new TmmTreeTableKeyAdapter(this));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn;
        TableCellRenderer renderer;
        int c = this.convertColumnIndexToModel(column);
        TableCellRenderer result = c == 0 ? ((renderer = (tableColumn = this.getColumnModel().getColumn(column)).getCellRenderer()) == null ? this.getDefaultRenderer(Object.class) : renderer) : super.getCellRenderer(row, column);
        return result;
    }

    public TmmTreeTableRenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public void setRenderDataProvider(TmmTreeTableRenderDataProvider provider) {
        if (provider != this.renderDataProvider) {
            TmmTreeTableRenderDataProvider old = this.renderDataProvider;
            this.renderDataProvider = provider;
            this.firePropertyChange("renderDataProvider", old, provider);
        }
    }

    TmmTreeTableTreePathSupport getTreePathSupport() {
        TmmTreeTableModel mdl = this.getTreeTableModel();
        if (mdl != null) {
            return mdl.getTreePathSupport();
        }
        return null;
    }

    public TmmTreeTableModel getTreeTableModel() {
        TableModel mdl = this.getModel();
        if (mdl instanceof TmmTreeTableModel) {
            return (TmmTreeTableModel)this.getModel();
        }
        return null;
    }

    @Override
    public void setDefaultColumnVisibility() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof TmmTableColumnModel) {
            TmmTableColumnModel tmmTableColumnModel = (TmmTableColumnModel)tableColumnModel;
            if (this.getModel() instanceof TmmTreeTableModel) {
                TmmTreeTableModel tableModel = (TmmTreeTableModel)this.getModel();
                TmmTableFormat tableFormat = tableModel.getTableModel().getTableFormat();
                ArrayList<String> hiddenColumns = new ArrayList<String>();
                for (int i = 0; i < tableFormat.getColumnCount(); ++i) {
                    if (!tableFormat.isColumnDefaultHidden(i)) continue;
                    hiddenColumns.add(tableFormat.getColumnIdentifier(i));
                }
                tmmTableColumnModel.setHiddenColumns(hiddenColumns);
                this.adjustColumnPreferredWidths(3);
            }
        }
    }

    @Override
    @Deprecated
    public void setDefaultHiddenColumns() {
        this.setDefaultColumnVisibility();
    }

    @Override
    protected boolean useColumnConfigurator() {
        return this.getModel() instanceof TmmTreeTableModel;
    }

    public DefaultMutableTreeNode getTreeNode(int row) {
        return this.getTreeTableModel().getTreeNode(row);
    }

    public void expandRow(int row) {
        this.expandPath(this.getRowPath(row));
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getRowPath(row));
    }

    public void expandPath(TreePath path) {
        this.getTreePathSupport().expandPath(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.getTreePathSupport().isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return this.isExpanded(this.getRowPath(row));
    }

    public boolean isCollapsed(int row) {
        return !this.isExpanded(row);
    }

    public boolean isLeaf(TreePath path) {
        return this.getTreePathSupport().isLeaf(path);
    }

    public boolean isLeaf(int row) {
        return this.isLeaf(this.getRowPath(row));
    }

    public boolean isBranch(int row) {
        return !this.isLeaf(row);
    }

    public void collapsePath(TreePath path) {
        this.getTreePathSupport().collapsePath(path);
    }

    TreePath getRowPath(int row) {
        return this.treeTableModel.getLayout().getPathForRow(row);
    }

    TreePath[] getSelectedTreePaths() {
        return (TreePath[])IntStream.of(this.getSelectedRows()).mapToObj(this::getRowPath).toArray(TreePath[]::new);
    }

    boolean isTreeColumnIndex(int column) {
        int columnIndex = this.convertColumnIndexToModel(column);
        return columnIndex == 0;
    }

    public final AbstractLayoutCache getLayoutCache() {
        TmmTreeTableModel model = this.getTreeTableModel();
        if (model != null) {
            return model.getLayout();
        }
        return null;
    }

    public void setRootVisible(boolean val) {
        AbstractLayoutCache layoutCache;
        if (this.getTreeTableModel() == null) {
            this.cachedRootVisible = val;
        }
        if (val != this.isRootVisible() && (layoutCache = this.getLayoutCache()) != null) {
            TreePath rootPath;
            layoutCache.setRootVisible(val);
            if (layoutCache.getRowCount() > 0 && null != (rootPath = layoutCache.getPathForRow(0))) {
                layoutCache.treeStructureChanged(new TreeModelEvent((Object)this, rootPath));
            }
            this.firePropertyChange("rootVisible", !val, val);
        }
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible;
        }
        return this.getLayoutCache().isRootVisible();
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean isTreeColumn = this.isTreeColumnIndex(column);
        if (isTreeColumn && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            AbstractLayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache != null) {
                TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                if (path != null && !this.getTreeTableModel().isLeaf(path.getLastPathComponent())) {
                    int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
                    Insets ins = this.getInsets();
                    int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                    if (nd < 0) {
                        nd = 0;
                    }
                    int handleStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth();
                    int handleEnd = ins.left + handleStart + handleWidth;
                    int columnStart = this.getCellRect((int)row, (int)column, (boolean)false).x;
                    TableColumn tableColumn = this.getColumnModel().getColumn(column);
                    if (me.getX() > ins.left && me.getX() >= (handleStart += columnStart) && me.getX() <= (handleEnd += columnStart)) {
                        boolean expanded = layoutCache.isExpanded(path);
                        if (!expanded) {
                            this.getTreePathSupport().expandPath(path);
                            Object ourObject = path.getLastPathComponent();
                            int cCount = this.getTreeTableModel().getChildCount(ourObject);
                            if (cCount > 0) {
                                int lastRow = row;
                                for (int i = 0; i < cCount; ++i) {
                                    Object child = this.getTreeTableModel().getChild(ourObject, i);
                                    TreePath childPath = path.pathByAddingChild(child);
                                    int childRow = layoutCache.getRowForPath(childPath);
                                    if ((childRow = this.convertRowIndexToView(childRow)) <= lastRow) continue;
                                    lastRow = childRow;
                                }
                                int firstRow = row;
                                Rectangle rectLast = this.getCellRect(lastRow, 0, true);
                                Rectangle rectFirst = this.getCellRect(firstRow, 0, true);
                                Rectangle rectFull = new Rectangle(rectFirst.x, rectFirst.y, rectLast.x + rectLast.width - rectFirst.x, rectLast.y + rectLast.height - rectFirst.y);
                                this.scrollRectToVisible(rectFull);
                            }
                        } else {
                            this.getTreePathSupport().collapsePath(path);
                        }
                        return false;
                    }
                }
                if (this.checkAt(row, column, me)) {
                    return false;
                }
            }
        }
        boolean res = false;
        if (!isTreeColumn || e instanceof MouseEvent && row >= 0 && this.isEditEvent(row, column, (MouseEvent)e)) {
            res = super.editCellAt(row, column, e);
        }
        if (res && isTreeColumn && row >= 0 && null != this.getEditorComponent()) {
            this.configureTreeCellEditor(this.getEditorComponent(), row, column);
        }
        if (e == null && !res && isTreeColumn) {
            this.checkAt(row, column, null);
        }
        return res;
    }

    private boolean isEditEvent(int row, int column, MouseEvent me) {
        boolean noModifiers;
        if (me.getClickCount() > 1) {
            return true;
        }
        boolean bl = noModifiers = me.getModifiersEx() == 1024;
        if (this.lastEditPosition != null && this.selectedRow == row && noModifiers && this.lastEditPosition[0] == row && this.lastEditPosition[1] == column) {
            int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
            Insets ins = this.getInsets();
            AbstractLayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache != null) {
                TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                if (nd < 0) {
                    nd = 0;
                }
                int handleStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth();
                int handleEnd = ins.left + handleStart + handleWidth;
                int columnStart = this.getCellRect((int)row, (int)column, (boolean)false).x;
                handleStart += columnStart;
                if (me.getX() >= (handleEnd += columnStart)) {
                    this.lastEditPosition = null;
                    return true;
                }
            }
        }
        this.lastEditPosition = new int[]{row, column};
        return false;
    }

    protected final boolean checkAt(int row, int column, MouseEvent me) {
        TmmTreeTableRenderDataProvider render = this.getRenderDataProvider();
        TableCellRenderer tcr = this.getDefaultRenderer(Object.class);
        if (render instanceof TmmTreeTableCheckRenderDataProvider && tcr instanceof TmmTreeTableCellRenderer) {
            TmmTreeTableCheckRenderDataProvider crender = (TmmTreeTableCheckRenderDataProvider)render;
            TmmTreeTableCellRenderer ocr = (TmmTreeTableCellRenderer)tcr;
            Object value = this.getValueAt(row, column);
            if (value != null && crender.isCheckable(value) && crender.isCheckEnabled(value)) {
                boolean chBoxPosition = false;
                if (me == null) {
                    chBoxPosition = true;
                } else {
                    int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
                    int chWidth = ocr.getTheCheckBoxWidth();
                    Insets ins = this.getInsets();
                    AbstractLayoutCache layoutCache = this.getLayoutCache();
                    if (layoutCache != null) {
                        TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                        int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                        if (nd < 0) {
                            nd = 0;
                        }
                        int chStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth() + handleWidth;
                        int chEnd = chStart + chWidth;
                        boolean bl = chBoxPosition = me.getX() > ins.left && me.getX() >= chStart && me.getX() <= chEnd;
                    }
                }
                if (chBoxPosition) {
                    Boolean selected = crender.isSelected(value);
                    if (selected == null || Boolean.TRUE.equals(selected)) {
                        crender.setSelected(value, Boolean.FALSE);
                    } else {
                        crender.setSelected(value, Boolean.TRUE);
                    }
                    Rectangle r = this.getCellRect(row, column, true);
                    this.repaint(r.x, r.y, r.width, r.height);
                    return true;
                }
            }
        }
        return false;
    }

    protected void configureTreeCellEditor(Component editor, int row, int column) {
        if (!(editor instanceof JComponent)) {
            return;
        }
        TreeCellEditorBorder b = new TreeCellEditorBorder();
        AbstractLayoutCache layoutCache = this.getLayoutCache();
        if (layoutCache != null) {
            TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
            Object o = this.getValueAt(row, column);
            TmmTreeTableRenderDataProvider rdp = this.getRenderDataProvider();
            TableCellRenderer tcr = this.getDefaultRenderer(Object.class);
            if (rdp instanceof TmmTreeTableCheckRenderDataProvider && tcr instanceof TmmTreeTableCellRenderer) {
                TmmTreeTableCheckRenderDataProvider crender = (TmmTreeTableCheckRenderDataProvider)rdp;
                TmmTreeTableCellRenderer ocr = (TmmTreeTableCellRenderer)tcr;
                Object value = this.getValueAt(row, column);
                if (value != null && crender.isCheckable(value) && crender.isCheckEnabled(value)) {
                    b.checkWidth = ocr.getTheCheckBoxWidth();
                    b.checkBox = ocr.setUpCheckBox(crender, value, ocr.createCheckBox());
                }
            }
            b.icon = rdp.getIcon(o);
            b.nestingDepth = Math.max(0, path.getPathCount() - (this.isRootVisible() ? 1 : 2));
            b.isLeaf = this.getTreeTableModel().isLeaf(o);
            b.isExpanded = layoutCache.isExpanded(path);
            ((JComponent)editor).setBorder(b);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.calcRowHeight();
    }

    private void calcRowHeight() {
        int rHeight = 20;
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int h = Math.max(fm.getHeight() + fm.getMaxDescent(), TmmTreeTableCellRenderer.getExpansionHandleHeight());
        rHeight = Math.max(rHeight, h) + 2;
        this.setRowHeight(rHeight);
    }

    public List<ITmmTreeFilter<TmmTreeNode>> getFilters() {
        return new ArrayList<ITmmTreeFilter<TmmTreeNode>>(this.treeFilters);
    }

    public void clearFilter() {
        for (ITmmTreeFilter<TmmTreeNode> filter : this.treeFilters) {
            if (filter instanceof ITmmUIFilter) {
                ITmmUIFilter tmmUIFilter = (ITmmUIFilter)((Object)filter);
                tmmUIFilter.setFilterState(ITmmUIFilter.FilterState.INACTIVE);
                tmmUIFilter.clearFilter();
            }
            filter.removePropertyChangeListener(this.filterChangeListener);
        }
        this.updateFiltering();
        this.storeFilters();
    }

    public void addFilter(ITmmTreeFilter<TmmTreeNode> newFilter) {
        newFilter.addPropertyChangeListener("treeFilterChanged", this.filterChangeListener);
        this.treeFilters.add(newFilter);
    }

    public void removeFilter(ITmmTreeFilter<TmmTreeNode> filter) {
        filter.removePropertyChangeListener(this.filterChangeListener);
        this.treeFilters.remove(filter);
    }

    void updateFiltering() {
        HashSet<ITmmTreeFilter<ITmmTreeFilter<TmmTreeNode>>> activeTreeFilters = new HashSet<ITmmTreeFilter<ITmmTreeFilter<TmmTreeNode>>>();
        for (ITmmTreeFilter<TmmTreeNode> filter : this.treeFilters) {
            if (!filter.isActive()) continue;
            activeTreeFilters.add(filter);
        }
        this.dataProvider.setTreeFilters(activeTreeFilters);
        TreeModel model = this.treeTableModel.getTreeModel();
        if (model instanceof TmmTreeModel) {
            ((TmmTreeModel)model).invalidateFilterCache();
            ((TmmTreeModel)model).updateSortingAndFiltering();
        }
        this.firePropertyChange("filterChanged", null, this.treeFilters);
    }

    public void storeFilters() {
    }

    public void setFilterValues(List<AbstractSettings.UIFilters> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        for (ITmmTreeFilter<TmmTreeNode> filter : this.treeFilters) {
            if (!(filter instanceof ITmmUIFilter)) continue;
            ITmmUIFilter tmmUIFilter = (ITmmUIFilter)((Object)filter);
            AbstractSettings.UIFilters uiFilters = values.stream().filter(uiFilter -> uiFilter.id.equals(filter.getId())).findFirst().orElse(null);
            if (uiFilters != null) {
                tmmUIFilter.setFilterState(uiFilters.state);
                tmmUIFilter.setFilterValue(uiFilters.filterValue);
                tmmUIFilter.setFilterOption(uiFilters.option);
                continue;
            }
            tmmUIFilter.setFilterState(ITmmUIFilter.FilterState.INACTIVE);
        }
        this.updateFiltering();
    }

    public void setFiltersActive(boolean filtersActive) {
        TreeModel model = this.treeTableModel.getTreeModel();
        if (model instanceof TmmTreeModel) {
            ((TmmTreeModel)model).getDataProvider().setFiltersActive(filtersActive);
        }
        this.updateFiltering();
        this.storeFilters();
    }

    public boolean isFiltersActive() {
        TreeModel model = this.treeTableModel.getTreeModel();
        if (model instanceof TmmTreeModel) {
            return ((TmmTreeModel)model).getDataProvider().isFiltersActive();
        }
        return true;
    }

    @Override
    public String getToolTipText(@NotNull MouseEvent e) {
        if (!(this.getModel() instanceof TmmTreeTableModel)) {
            return null;
        }
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex) - 1;
        if (colIndex == 0) {
            return super.getToolTipText(e);
        }
        if (colIndex > 0) {
            TmmTreeTableModel treeTableModel = (TmmTreeTableModel)this.getModel();
            ConnectorTableModel tableModel = treeTableModel.getTableModel();
            return tableModel.getTooltipAt(rowIndex, realColumnIndex);
        }
        return null;
    }

    public boolean isAdjusting() {
        return ((TmmTreeModel)this.treeTableModel.getTreeModel()).isAdjusting();
    }

    private void setSelectedRows(int[] selectedRows) {
        ((TmmTreeModel)this.treeTableModel.getTreeModel()).setAdjusting(true);
        this.clearSelection();
        ((TmmTreeModel)this.treeTableModel.getTreeModel()).setAdjusting(false);
        for (int selectedRow : selectedRows) {
            if (selectedRow > 0) {
                this.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
                continue;
            }
            this.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    public ITmmTreeTableSortingStrategy getSortStrategy() {
        Comparator comparator = ((TmmTreeModel)this.getTreeTableModel().getTreeModel()).getDataProvider().getTreeComparator();
        if (comparator instanceof ITmmTreeTableSortingStrategy) {
            ITmmTreeTableSortingStrategy sortStrategy = (ITmmTreeTableSortingStrategy)((Object)comparator);
            return sortStrategy;
        }
        return null;
    }

    public void setSortStrategy(String stringEncoded) {
        ITmmTreeTableSortingStrategy sortingStrategy = this.getSortStrategy();
        if (sortingStrategy == null) {
            return;
        }
        sortingStrategy.fromString(stringEncoded);
        this.updateFiltering();
        this.getTableHeader().repaint();
    }

    private class TmmTreeModelConnector<E extends TmmTreeNode>
    extends TmmTreeModel<E> {
        public TmmTreeModelConnector(TmmTreeDataProvider<E> dataProvider) {
            super(null, dataProvider);
        }

        @Override
        public void updateSortingAndFiltering() {
            long now = System.currentTimeMillis();
            if (now > this.nextNodeStructureChanged) {
                TreePath[] selectedPaths = TmmTreeTable.this.getSelectedTreePaths();
                this.setAdjusting(true);
                boolean structureChanged = this.performFilteringAndSortingRecursively(this.getRoot());
                if (structureChanged) {
                    this.nodeStructureChanged();
                    this.setAdjusting(false);
                    TmmTreeTable.this.setSelectedRows(TmmTreeTable.this.treeTableModel.getLayout().getRowsForPaths(selectedPaths));
                } else {
                    this.setAdjusting(false);
                }
                long end = System.currentTimeMillis();
                this.nextNodeStructureChanged = end - now < 100L ? end + 100L : end + (end - now) * 2L;
            } else {
                this.startUpdateSortAndFilterTimer();
            }
        }
    }

    private class TmmTreeTableKeyAdapter
    extends KeyAdapter {
        final TmmTreeTable treeTable;

        TmmTreeTableKeyAdapter(TmmTreeTable treeTable) {
            this.treeTable = treeTable;
        }

        private int[] getParentRows(int[] childRows) {
            return IntStream.of(childRows).map(leafRow -> {
                TreePath leafPath = TmmTreeTable.this.getRowPath(leafRow);
                TreePath parentPath = leafPath.getParentPath();
                TreePath pathToReturn = parentPath != null ? parentPath : leafPath;
                int parentRow = TmmTreeTable.this.treeTableModel.getLayout().getRowForPath(pathToReturn);
                return parentRow > -1 ? parentRow : leafRow;
            }).toArray();
        }

        private void toggleRows(int[] rows, boolean expand) {
            int[] collapsedAndLeafRows = IntStream.of(rows).filter(this.treeTable::isCollapsed).toArray();
            if (!expand && collapsedAndLeafRows.length == rows.length) {
                int[] parentRows = this.getParentRows(rows);
                TmmTreeTable.this.setSelectedRows(parentRows);
                return;
            }
            int[] reversedBranchRows = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                reversedBranchRows[rows.length - i - 1] = rows[i];
            }
            TreePath[] selectedPaths = TmmTreeTable.this.getSelectedTreePaths();
            for (int row : reversedBranchRows) {
                if (expand) {
                    this.treeTable.expandRow(row);
                    continue;
                }
                this.treeTable.collapseRow(row);
            }
            TmmTreeTable.this.setSelectedRows(TmmTreeTable.this.treeTableModel.getLayout().getRowsForPaths(selectedPaths));
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int[] selectedRows = this.treeTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            try {
                if (e.getKeyCode() == 39) {
                    this.toggleRows(selectedRows, true);
                } else if (e.getKeyCode() == 37) {
                    this.toggleRows(selectedRows, false);
                } else if (e.getKeyCode() == 32) {
                    int[] branchRows = IntStream.of(selectedRows).filter(this.treeTable::isBranch).toArray();
                    if (branchRows.length > 0) {
                        boolean areAnyBranchesCollapsed = IntStream.of(branchRows).anyMatch(this.treeTable::isCollapsed);
                        this.toggleRows(selectedRows, areAnyBranchesCollapsed);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TreeCellEditorBorder
    implements Border {
        private final Insets insets = new Insets(0, 0, 0, 0);
        private final int iconTextGap = new JLabel().getIconTextGap();
        private boolean isLeaf;
        private boolean isExpanded;
        private Icon icon;
        private int nestingDepth;
        private int checkWidth;
        private JCheckBox checkBox;

        private TreeCellEditorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            this.insets.left = this.nestingDepth * TmmTreeTableCellRenderer.getNestingWidth() + TmmTreeTableCellRenderer.getExpansionHandleWidth() + 1;
            this.insets.left = this.insets.left + (this.checkWidth + (this.icon != null ? this.icon.getIconWidth() + this.iconTextGap : 0));
            this.insets.top = 1;
            this.insets.right = 1;
            this.insets.bottom = 1;
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int iconY;
            int iconX = this.nestingDepth * TmmTreeTableCellRenderer.getNestingWidth();
            if (!this.isLeaf) {
                Icon expIcon = this.isExpanded ? TmmTreeTableCellRenderer.getExpandedIcon() : TmmTreeTableCellRenderer.getCollapsedIcon();
                iconY = expIcon.getIconHeight() < height ? height / 2 - expIcon.getIconHeight() / 2 : 0;
                expIcon.paintIcon(c, g, iconX, iconY);
            }
            iconX += TmmTreeTableCellRenderer.getExpansionHandleWidth() + 1;
            if (null != this.checkBox) {
                Graphics chbg = g.create(iconX, y, this.checkWidth, height);
                this.checkBox.paint(chbg);
                chbg.dispose();
            }
            iconX += this.checkWidth;
            if (null != this.icon) {
                iconY = this.icon.getIconHeight() < height ? height / 2 - this.icon.getIconHeight() / 2 : 0;
                this.icon.paintIcon(c, g, iconX, iconY);
            }
        }
    }
}

