/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmOptionDialog;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRenameAction
extends TmmAction {
    public MovieRenameAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rename"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rename"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("movie.hiderenamehint")) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            int answer = TmmOptionDialog.showOptionDialog((Frame)MainWindow.getInstance(), TmmResourceBundle.getString("movie.rename"), TmmResourceBundle.getString("movie.rename.desc"), checkBox);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("movie.hiderenamehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(renameTask);
    }
}

