/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Device;
import com.ubnt.service.trace.model.common.TraceMeta;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiTraceMeta
extends TraceMeta {
    @JsonProperty(value="anonymous_controller_id")
    private String anonymousControllerId;
    @JsonProperty(value="controller.version")
    private String controllerVersion;
    @JsonProperty(value="is_default")
    private String isDefault;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="version")
    private String firmwareVersion;
    @JsonProperty(value="board_rev")
    private String boardRev;
    @JsonProperty(value="mobile_app_host_OS")
    private String mobileAppHostOs;
    @JsonProperty(value="install_type")
    private String installType;
    @JsonProperty(value="discovered_via")
    private String discoveredVia;

    private ApiTraceMeta(String string) {
        super(string);
    }

    public String getAnonymousControllerId() {
        return this.anonymousControllerId;
    }

    public String getControllerVersion() {
        return this.controllerVersion;
    }

    public String getIsDefault() {
        return this.isDefault;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public String getBoardRev() {
        return this.boardRev;
    }

    public String getMobileAppHostOs() {
        return this.mobileAppHostOs;
    }

    public String getInstallType() {
        return this.installType;
    }

    public String getDiscoveredVia() {
        return this.discoveredVia;
    }

    public static ApiTraceMeta of(String string, Device device, String string2, String string3, String string4, String string5) {
        ApiTraceMeta apiTraceMeta = new ApiTraceMeta(string);
        apiTraceMeta.anonymousControllerId = string4;
        apiTraceMeta.controllerVersion = string5;
        apiTraceMeta.isDefault = String.valueOf(false);
        apiTraceMeta.model = device.getModel().name();
        apiTraceMeta.firmwareVersion = device.getFirmwareVersion();
        apiTraceMeta.boardRev = device.getBoardRevision();
        apiTraceMeta.mobileAppHostOs = string2;
        apiTraceMeta.installType = string3;
        apiTraceMeta.discoveredVia = device.getDiscoveredVia().orElse(null);
        return apiTraceMeta;
    }
}

