/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import java.nio.file.Path;
import org.verapdf.core.utils.FileOutputMapper;
import org.verapdf.core.utils.RelativeDirectoryMapper;
import org.verapdf.core.utils.RelativeRootMapper;
import org.verapdf.core.utils.SingleOutputDirMapper;
import org.verapdf.core.utils.VersioningMapper;

public class FileOutputMappers {
    public static final FileOutputMapper sibFiles() {
        return RelativeDirectoryMapper.defaultInstance();
    }

    public static final FileOutputMapper verSibFiles() {
        return VersioningMapper.defaultInstance();
    }

    public static final FileOutputMapper sibFiles(String prefix) {
        return FileOutputMappers.sibFiles(prefix, "");
    }

    public static final FileOutputMapper verSibFiles(String prefix) {
        return FileOutputMappers.verSibFiles(prefix, "");
    }

    public static final FileOutputMapper sibFiles(String prefix, String suffix) {
        if (prefix == null) {
            throw new NullPointerException("Arg prefix can not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("Arg suffix can not be null");
        }
        return RelativeDirectoryMapper.withPrefixAndSuffix(prefix, suffix);
    }

    public static final FileOutputMapper verSibFiles(String prefix, String suffix) {
        return VersioningMapper.newInstance(FileOutputMappers.sibFiles(prefix, suffix));
    }

    public static final FileOutputMapper subFold(String relativePath) {
        return FileOutputMappers.subFold(relativePath, "veraPDF_");
    }

    public static final FileOutputMapper verSubFold(String relativePath) {
        return FileOutputMappers.verSubFold(relativePath, "veraPDF_");
    }

    public static final FileOutputMapper subFold(String relativePath, String prefix) {
        return FileOutputMappers.subFold(relativePath, prefix, "");
    }

    public static final FileOutputMapper verSubFold(String relativePath, String prefix) {
        return FileOutputMappers.verSubFold(relativePath, prefix, "");
    }

    public static final FileOutputMapper subFold(String relativePath, String prefix, String suffix) {
        if (relativePath == null) {
            throw new NullPointerException("Arg relativePath can not be null");
        }
        if (relativePath.isEmpty()) {
            throw new IllegalArgumentException("Arg relativePath can not be an empty string");
        }
        if (prefix == null) {
            throw new NullPointerException("Arg prefix can not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("Arg suffix can not be null");
        }
        return RelativeDirectoryMapper.fromValues(relativePath, prefix, suffix);
    }

    public static final FileOutputMapper verSubFold(String relativePath, String prefix, String suffix) {
        return VersioningMapper.newInstance(FileOutputMappers.subFold(relativePath, prefix, suffix));
    }

    public static final FileOutputMapper toRelativeDest(Path src, Path dest) {
        return FileOutputMappers.toRelativeDest(src, dest, "veraPDF_");
    }

    public static final FileOutputMapper toRelativeDest(Path src, Path dest, String prefix) {
        return FileOutputMappers.toRelativeDest(src, dest, prefix, "");
    }

    public static final FileOutputMapper toRelativeDest(Path src, Path dest, String prefix, String suffix) {
        if (src == null) {
            throw new NullPointerException("Arg src can not be null");
        }
        if (dest == null) {
            throw new NullPointerException("Arg dest can not be null");
        }
        if (prefix == null) {
            throw new NullPointerException("Arg prefix can not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("Arg suffix can not be null");
        }
        return RelativeRootMapper.fromValues(src, dest, prefix, suffix);
    }

    public static final FileOutputMapper fold(String path) {
        return FileOutputMappers.fold(path, "veraPDF_");
    }

    public static final FileOutputMapper verFold(String path) {
        return FileOutputMappers.verFold(path, "veraPDF_");
    }

    public static final FileOutputMapper fold(String path, String prefix) {
        return FileOutputMappers.fold(path, prefix, "");
    }

    public static final FileOutputMapper verFold(String path, String prefix) {
        return FileOutputMappers.verFold(path, prefix, "");
    }

    public static final FileOutputMapper fold(String path, String prefix, String suffix) {
        if (path == null) {
            throw new NullPointerException("Arg path can not be null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Arg path can not be an empty string");
        }
        if (prefix == null) {
            throw new NullPointerException("Arg prefix can not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("Arg suffix can not be null");
        }
        File outputDir = new File(path);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IllegalArgumentException("Can't create writeable output directory:" + path);
        }
        if (!(outputDir.isDirectory() && outputDir.canWrite() || outputDir.mkdirs())) {
            throw new IllegalArgumentException(path + " is not a writeable output directory.");
        }
        return SingleOutputDirMapper.fromValues(outputDir, prefix, suffix);
    }

    public static final FileOutputMapper verFold(String path, String prefix, String suffix) {
        if (path == null) {
            throw new NullPointerException("Arg path can not be null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Arg path can not be an empty string");
        }
        if (prefix == null) {
            throw new NullPointerException("Arg prefix can not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("Arg suffix can not be null");
        }
        File outputDir = new File(path);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IllegalArgumentException("Can't create writeable output directory:" + path);
        }
        if (!(outputDir.isDirectory() && outputDir.canWrite() || outputDir.mkdirs())) {
            throw new IllegalArgumentException(path + " is not a writeable output directory.");
        }
        return VersioningMapper.newInstance(SingleOutputDirMapper.fromValues(outputDir, prefix, suffix));
    }
}

