/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class UnionEnumeration
implements SequenceIterator,
LookaheadIterator {
    private final SequenceIterator e1;
    private final SequenceIterator e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private final Comparator<? super NodeInfo> comparer;

    public UnionEnumeration(SequenceIterator p1, SequenceIterator p2, Comparator<? super NodeInfo> comparer) throws XPathException {
        this.e1 = p1;
        this.e2 = p2;
        this.comparer = comparer;
        this.nextNode1 = this.nextNode(this.e1);
        this.nextNode2 = this.nextNode(this.e2);
    }

    private NodeInfo nextNode(SequenceIterator iter) {
        return (NodeInfo)iter.next();
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextNode1 != null || this.nextNode2 != null;
    }

    @Override
    public NodeInfo next() {
        if (this.nextNode1 != null && this.nextNode2 != null) {
            int c = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (c < 0) {
                NodeInfo current = this.nextNode1;
                this.nextNode1 = this.nextNode(this.e1);
                return current;
            }
            if (c > 0) {
                NodeInfo current = this.nextNode2;
                this.nextNode2 = this.nextNode(this.e2);
                return current;
            }
            NodeInfo current = this.nextNode2;
            this.nextNode2 = this.nextNode(this.e2);
            this.nextNode1 = this.nextNode(this.e1);
            return current;
        }
        if (this.nextNode1 != null) {
            NodeInfo current = this.nextNode1;
            this.nextNode1 = this.nextNode(this.e1);
            return current;
        }
        if (this.nextNode2 != null) {
            NodeInfo current = this.nextNode2;
            this.nextNode2 = this.nextNode(this.e2);
            return current;
        }
        return null;
    }

    @Override
    public void close() {
        this.e1.close();
        this.e2.close();
    }

    @Override
    public void discharge() {
        this.e1.discharge();
        this.e2.discharge();
    }
}

