/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaWildcardType;
import com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.List;

public class DefaultJavaWildcardType
extends DefaultJavaType
implements JavaWildcardType {
    private BoundType boundType;
    private List<JavaType> bounds = Collections.emptyList();

    public DefaultJavaWildcardType() {
        super("?");
    }

    public DefaultJavaWildcardType(JavaType type, BoundType boundType) {
        this();
        this.bounds = Collections.singletonList(type);
        this.boundType = boundType;
    }

    @Override
    public JavaType[] getUpperBounds() {
        switch (this.boundType) {
            case SUPER: {
                return new JavaType[]{new DefaultJavaClass("java.lang.Object")};
            }
            case EXTENDS: {
                return this.bounds.toArray(new JavaType[0]);
            }
        }
        return new JavaType[0];
    }

    @Override
    public JavaType[] getLowerBounds() {
        switch (this.boundType) {
            case SUPER: {
                return this.bounds.toArray(new JavaType[0]);
            }
        }
        return new JavaType[0];
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getFullyQualifiedName());
        }
        return builder.toString();
    }

    @Override
    public String getGenericValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericValue());
        }
        return builder.toString();
    }

    @Override
    public String getGenericFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericFullyQualifiedName());
        }
        return builder.toString();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getCanonicalName());
        }
        return builder.toString();
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericCanonicalName());
        }
        return builder.toString();
    }

    @Override
    public String getValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getValue());
        }
        return builder.toString();
    }

    @Override
    public String toGenericString() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.toGenericString());
        }
        return builder.toString();
    }

    private StringBuilder getPreparedStringBuilder() {
        StringBuilder builder = new StringBuilder("?");
        if (BoundType.EXTENDS.equals((Object)this.boundType)) {
            builder.append(" extends ");
        } else if (BoundType.SUPER.equals((Object)this.boundType)) {
            builder.append(" super ");
        }
        return builder;
    }

    public static enum BoundType {
        EXTENDS,
        SUPER;

    }
}

