/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Label pixels that are connected to one set of seeds but not another.


IsolatedConnectedImageFilter finds the optimal threshold to separate two regions. It has two
modes, one to separate dark regions surrounded by bright regions by
automatically finding a minimum isolating upper threshold, and another
to separate bright regions surrounded by dark regions by automatically
finding a maximum lower isolating threshold. The mode can be chosen by
setting FindUpperThresholdOn() /Off(). In both cases, the isolating threshold is retrieved with GetIsolatedValue() .

The algorithm labels pixels with ReplaceValue that are connected to
Seeds1 AND NOT connected to Seeds2. When finding the threshold to
separate two dark regions surrounded by bright regions, given a fixed
lower threshold, the filter adjusts the upper threshold until the two
sets of seeds are not connected. The algorithm uses a binary search to
adjust the upper threshold, starting at Upper. The reverse is true for
finding the threshold to separate two bright regions. Lower defaults
to the smallest possible value for the InputImagePixelType, and Upper
defaults to the largest possible value for the InputImagePixelType.

The user can also supply the Lower and Upper values to restrict the
search. However, if the range is too restrictive, it could happen that
no isolating threshold can be found between the user specified Lower
and Upper values. Therefore, unless the user is sure of the bounds to
set, it is recommended that the user set these values to the lowest
and highest intensity values in the image, respectively.

The user can specify more than one seed for both regions to separate.
The algorithm will try find the threshold that ensures that all of the
first seeds are contained in the resulting segmentation and all of the
second seeds are not contained in the segmentation.

It is possible that the algorithm may not be able to find the
isolating threshold because no such threshold exists. The user can
check for this by querying the GetThresholdingFailed() flag.
See:
 itk::simple::IsolatedConnected for the procedural interface

 itk::IsolatedConnectedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsolatedConnectedImageFilter.h
*/
public class IsolatedConnectedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected IsolatedConnectedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.IsolatedConnectedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(IsolatedConnectedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(IsolatedConnectedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::IsolatedConnectedImageFilter::~IsolatedConnectedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_IsolatedConnectedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::IsolatedConnectedImageFilter::IsolatedConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  IsolatedConnectedImageFilter() {
    this(SimpleITKJNI.new_IsolatedConnectedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetSeed1(std::vector&lt; unsigned int &gt; Seed1)

     Set a single seed point 1.

This seed will be isolated from Seed2 (if possible). All pixels
connected to this seed will be replaced with ReplaceValue.

*/
public  void setSeed1(VectorUInt32 Seed1) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setSeed1(swigCPtr, this, VectorUInt32.getCPtr(Seed1), Seed1);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::IsolatedConnectedImageFilter::GetSeed1() const
*/
public  VectorUInt32 getSeed1() {
    return new VectorUInt32(SimpleITKJNI.IsolatedConnectedImageFilter_getSeed1(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetSeed2(std::vector&lt; unsigned int &gt; Seed2)

     Set a single seed point 2.

This seed will be isolated from Seed1 (if possible).

*/
public  void setSeed2(VectorUInt32 Seed2) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setSeed2(swigCPtr, this, VectorUInt32.getCPtr(Seed2), Seed2);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::IsolatedConnectedImageFilter::GetSeed2() const
*/
public  VectorUInt32 getSeed2() {
    return new VectorUInt32(SimpleITKJNI.IsolatedConnectedImageFilter_getSeed2(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetLower(double Lower)

Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.

*/
public  void setLower(double Lower) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setLower(swigCPtr, this, Lower);
  }

  /**
double itk::simple::IsolatedConnectedImageFilter::GetLower() const

Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.

*/
public  double getLower() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getLower(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetUpper(double Upper)

Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.

*/
public  void setUpper(double Upper) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setUpper(swigCPtr, this, Upper);
  }

  /**
double itk::simple::IsolatedConnectedImageFilter::GetUpper() const

Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.

*/
public  double getUpper() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getUpper(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.

*/
public  void setReplaceValue(short ReplaceValue) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setReplaceValue(swigCPtr, this, ReplaceValue);
  }

  /**
uint8_t itk::simple::IsolatedConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.

*/
public  short getReplaceValue() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getReplaceValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetIsolatedValueTolerance(double IsolatedValueTolerance)

Set/Get the precision required for the intensity threshold value. The
default is 1.

*/
public  void setIsolatedValueTolerance(double IsolatedValueTolerance) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setIsolatedValueTolerance(swigCPtr, this, IsolatedValueTolerance);
  }

  /**
double itk::simple::IsolatedConnectedImageFilter::GetIsolatedValueTolerance() const

Set/Get the precision required for the intensity threshold value. The
default is 1.

*/
public  double getIsolatedValueTolerance() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getIsolatedValueTolerance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::SetFindUpperThreshold(bool FindUpperThreshold)

Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).

*/
public  void setFindUpperThreshold(boolean FindUpperThreshold) {
    SimpleITKJNI.IsolatedConnectedImageFilter_setFindUpperThreshold(swigCPtr, this, FindUpperThreshold);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOn()

Set the value of FindUpperThreshold to true or false respectfully.

*/
public  void findUpperThresholdOn() {
    SimpleITKJNI.IsolatedConnectedImageFilter_findUpperThresholdOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOff()
*/
public  void findUpperThresholdOff() {
    SimpleITKJNI.IsolatedConnectedImageFilter_findUpperThresholdOff(swigCPtr, this);
  }

  /**
bool itk::simple::IsolatedConnectedImageFilter::GetFindUpperThreshold() const

Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).

*/
public  boolean getFindUpperThreshold() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getFindUpperThreshold(swigCPtr, this);
  }

  /**
bool itk::simple::IsolatedConnectedImageFilter::GetThresholdingFailed() const

Get the flag that tells whether the algorithm failed to find a
threshold.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  boolean getThresholdingFailed() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getThresholdingFailed(swigCPtr, this);
  }

  /**
double itk::simple::IsolatedConnectedImageFilter::GetIsolatedValue() const

Get value that isolates the two seeds.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getIsolatedValue() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getIsolatedValue(swigCPtr, this);
  }

  /**
std::string itk::simple::IsolatedConnectedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::IsolatedConnectedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.IsolatedConnectedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::IsolatedConnectedImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.IsolatedConnectedImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
