/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.Converter;
import org.hibernate.type.CharBooleanConverter;

@Converter
public class YesNoConverter
extends CharBooleanConverter {
    public static final YesNoConverter INSTANCE = new YesNoConverter();
    private static final String[] VALUES = new String[]{"N", "Y"};

    @Override
    protected String[] getValues() {
        return VALUES;
    }

    @Override
    public Boolean toDomainValue(Character relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        switch (relationalForm.charValue()) {
            case 'Y': {
                return true;
            }
            case 'N': {
                return false;
            }
        }
        return null;
    }

    @Override
    public Character toRelationalValue(Boolean domainForm) {
        if (domainForm == null) {
            return null;
        }
        return Character.valueOf(domainForm != false ? (char)'Y' : 'N');
    }
}

