/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;

final class LongDistanceFeatureQuery
extends Query {
    private final String field;
    private final long origin;
    private final long pivotDistance;

    LongDistanceFeatureQuery(String field, long origin, long pivotDistance) {
        this.field = Objects.requireNonNull(field);
        this.origin = origin;
        if (pivotDistance <= 0L) {
            throw new IllegalArgumentException("pivotDistance must be > 0, got " + pivotDistance);
        }
        this.pivotDistance = pivotDistance;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((LongDistanceFeatureQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(LongDistanceFeatureQuery other) {
        return Objects.equals(this.field, other.field) && this.origin == other.origin && this.pivotDistance == other.pivotDistance;
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Long.hashCode(this.origin);
        h2 = 31 * h2 + Long.hashCode(this.pivotDistance);
        return h2;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(field=" + field + ",origin=" + this.origin + ",pivotDistance=" + this.pivotDistance + ")";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                SortedNumericDocValues multiDocValues = DocValues.getSortedNumeric(context.reader(), LongDistanceFeatureQuery.this.field);
                if (!multiDocValues.advanceExact(doc)) {
                    return Explanation.noMatch("Document " + doc + " doesn't have a value for field " + LongDistanceFeatureQuery.this.field, new Explanation[0]);
                }
                long value = this.selectValue(multiDocValues);
                long distance = Math.max(value, LongDistanceFeatureQuery.this.origin) - Math.min(value, LongDistanceFeatureQuery.this.origin);
                if (distance < 0L) {
                    distance = Long.MAX_VALUE;
                }
                float score = (float)((double)boost * ((double)LongDistanceFeatureQuery.this.pivotDistance / ((double)LongDistanceFeatureQuery.this.pivotDistance + (double)distance)));
                return Explanation.match((Number)Float.valueOf(score), "Distance score, computed as weight * pivotDistance / (pivotDistance + abs(value - origin)) from:", Explanation.match((Number)Float.valueOf(boost), "weight", new Explanation[0]), Explanation.match((Number)LongDistanceFeatureQuery.this.pivotDistance, "pivotDistance", new Explanation[0]), Explanation.match((Number)LongDistanceFeatureQuery.this.origin, "origin", new Explanation[0]), Explanation.match((Number)value, "current value", new Explanation[0]));
            }

            private long selectValue(SortedNumericDocValues multiDocValues) throws IOException {
                int count = multiDocValues.docValueCount();
                long next = multiDocValues.nextValue();
                if (count == 1 || next >= LongDistanceFeatureQuery.this.origin) {
                    return next;
                }
                long previous = next;
                for (int i = 1; i < count; ++i) {
                    next = multiDocValues.nextValue();
                    if (next >= LongDistanceFeatureQuery.this.origin) {
                        if (Long.compareUnsigned(LongDistanceFeatureQuery.this.origin - previous, next - LongDistanceFeatureQuery.this.origin) < 0) {
                            return previous;
                        }
                        return next;
                    }
                    previous = next;
                }
                assert (next < LongDistanceFeatureQuery.this.origin);
                return next;
            }

            private NumericDocValues selectValues(final SortedNumericDocValues multiDocValues) {
                NumericDocValues singleton = DocValues.unwrapSingleton(multiDocValues);
                if (singleton != null) {
                    return singleton;
                }
                return new NumericDocValues(){
                    long value;

                    @Override
                    public long longValue() throws IOException {
                        return this.value;
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (multiDocValues.advanceExact(target)) {
                            this.value = this.selectValue(multiDocValues);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return multiDocValues.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return multiDocValues.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return multiDocValues.advance(target);
                    }

                    @Override
                    public long cost() {
                        return multiDocValues.cost();
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final PointValues pointValues = context.reader().getPointValues(LongDistanceFeatureQuery.this.field);
                if (pointValues == null) {
                    return null;
                }
                SortedNumericDocValues multiDocValues = DocValues.getSortedNumeric(context.reader(), LongDistanceFeatureQuery.this.field);
                final NumericDocValues docValues = this.selectValues(multiDocValues);
                final 1 weight = this;
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return new DistanceScorer(weight, context.reader().maxDoc(), leadCost, boost, pointValues, docValues);
                    }

                    @Override
                    public long cost() {
                        return docValues.cost();
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }
        };
    }

    private class DistanceScorer
    extends Scorer {
        private final int maxDoc;
        private DocIdSetIterator it;
        private int doc;
        private final long leadCost;
        private final float boost;
        private final PointValues pointValues;
        private final NumericDocValues docValues;
        private long maxDistance;
        private int setMinCompetitiveScoreCounter;

        protected DistanceScorer(Weight weight, int maxDoc, long leadCost, float boost, PointValues pointValues, NumericDocValues docValues) {
            super(weight);
            this.doc = -1;
            this.maxDistance = Long.MAX_VALUE;
            this.setMinCompetitiveScoreCounter = 0;
            this.maxDoc = maxDoc;
            this.leadCost = leadCost;
            this.boost = boost;
            this.pointValues = pointValues;
            this.docValues = docValues;
            this.it = docValues;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private float score(long distance) {
            return (float)((double)this.boost * ((double)LongDistanceFeatureQuery.this.pivotDistance / ((double)LongDistanceFeatureQuery.this.pivotDistance + (double)distance)));
        }

        private long computeMaxDistance(float minScore, long previousMaxDistance) {
            assert (this.score(0L) >= minScore);
            if (this.score(previousMaxDistance) >= minScore) {
                return previousMaxDistance;
            }
            assert (this.score(previousMaxDistance) < minScore);
            long min2 = 0L;
            long max = previousMaxDistance;
            while (max - min2 > 1L) {
                long mid = min2 + max >>> 1;
                float score = this.score(mid);
                if (score >= minScore) {
                    min2 = mid;
                    continue;
                }
                max = mid;
            }
            assert (this.score(min2) >= minScore);
            assert (min2 == Long.MAX_VALUE || this.score(min2 + 1L) < minScore);
            return min2;
        }

        @Override
        public float score() throws IOException {
            if (!this.docValues.advanceExact(this.docID())) {
                return 0.0f;
            }
            long v = this.docValues.longValue();
            long distance = Math.max(v, LongDistanceFeatureQuery.this.origin) - Math.min(v, LongDistanceFeatureQuery.this.origin);
            if (distance < 0L) {
                distance = Long.MAX_VALUE;
            }
            return this.score(distance);
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                @Override
                public int nextDoc() throws IOException {
                    DistanceScorer.this.doc = DistanceScorer.this.it.nextDoc();
                    return DistanceScorer.this.doc;
                }

                @Override
                public int docID() {
                    return DistanceScorer.this.doc;
                }

                @Override
                public long cost() {
                    return DistanceScorer.this.it.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    DistanceScorer.this.doc = DistanceScorer.this.it.advance(target);
                    return DistanceScorer.this.doc;
                }
            };
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.boost;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            long maxValue;
            if (minScore > this.boost) {
                this.it = DocIdSetIterator.empty();
                return;
            }
            ++this.setMinCompetitiveScoreCounter;
            if (this.setMinCompetitiveScoreCounter > 256 && (this.setMinCompetitiveScoreCounter & 0x1F) != 31) {
                return;
            }
            long previousMaxDistance = this.maxDistance;
            this.maxDistance = this.computeMaxDistance(minScore, this.maxDistance);
            if (this.maxDistance == previousMaxDistance) {
                return;
            }
            long minValue = LongDistanceFeatureQuery.this.origin - this.maxDistance;
            if (minValue > LongDistanceFeatureQuery.this.origin) {
                minValue = Long.MIN_VALUE;
            }
            if ((maxValue = LongDistanceFeatureQuery.this.origin + this.maxDistance) < LongDistanceFeatureQuery.this.origin) {
                maxValue = Long.MAX_VALUE;
            }
            final long min2 = minValue;
            final long max = maxValue;
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            final int doc = this.docID();
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= doc) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    if (docID <= doc) {
                        return;
                    }
                    long docValue = NumericUtils.sortableBytesToLong(packedValue, 0);
                    if (docValue < min2 || docValue > max) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    long minDocValue = NumericUtils.sortableBytesToLong(minPackedValue, 0);
                    long maxDocValue = NumericUtils.sortableBytesToLong(maxPackedValue, 0);
                    if (minDocValue > max || maxDocValue < min2) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (minDocValue < min2 || maxDocValue > max) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long currentQueryCost = Math.min(this.leadCost, this.it.cost());
            long threshold = currentQueryCost >>> 3;
            long estimatedNumberOfMatches = this.pointValues.estimatePointCount(visitor);
            if (estimatedNumberOfMatches >= threshold) {
                return;
            }
            this.pointValues.intersect(visitor);
            this.it = result.build().iterator();
        }
    }
}

