/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Similarity;

abstract class IntervalScoreFunction {
    IntervalScoreFunction() {
    }

    static IntervalScoreFunction saturationFunction(float pivot) {
        if (pivot <= 0.0f || !Float.isFinite(pivot)) {
            throw new IllegalArgumentException("pivot must be > 0, got: " + pivot);
        }
        return new SaturationFunction(pivot);
    }

    static IntervalScoreFunction sigmoidFunction(float pivot, float exp) {
        if (pivot <= 0.0f || !Float.isFinite(pivot)) {
            throw new IllegalArgumentException("pivot must be > 0, got: " + pivot);
        }
        if (exp <= 0.0f || !Float.isFinite(exp)) {
            throw new IllegalArgumentException("exp must be > 0, got: " + exp);
        }
        return new SigmoidFunction(pivot, exp);
    }

    public abstract Similarity.SimScorer scorer(float var1);

    public abstract Explanation explain(String var1, float var2, float var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private static class SigmoidFunction
    extends IntervalScoreFunction {
        private final float pivot;
        private final float a;
        private final double pivotPa;

        private SigmoidFunction(float pivot, float a) {
            this.pivot = pivot;
            this.a = a;
            this.pivotPa = Math.pow(pivot, a);
        }

        @Override
        public Similarity.SimScorer scorer(final float weight) {
            return new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return (float)((double)weight * (1.0 - pivotPa / (Math.pow(freq, a) + pivotPa)));
                }
            };
        }

        @Override
        public Explanation explain(String interval, float weight, float sloppyFreq) {
            float score = this.scorer(weight).score(sloppyFreq, 1L);
            return Explanation.match((Number)Float.valueOf(score), "Sigmoid function on interval frequency, computed as w * S^a / (S^a + k^a) from:", Explanation.match((Number)Float.valueOf(weight), "w, weight of this function", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.pivot), "k, pivot feature value that would give a score contribution equal to w/2", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.a), "a, exponent, higher values make the function grow slower before k and faster after k", new Explanation[0]), Explanation.match((Number)Float.valueOf(sloppyFreq), "S, the sloppy frequency of the interval query " + interval, new Explanation[0]));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SigmoidFunction that = (SigmoidFunction)o;
            return Float.compare(that.pivot, this.pivot) == 0 && Float.compare(that.a, this.a) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.pivot), Float.valueOf(this.a));
        }

        @Override
        public String toString() {
            return "SigmoidFunction(pivot=" + this.pivot + ", a=" + this.a + ")";
        }
    }

    private static class SaturationFunction
    extends IntervalScoreFunction {
        final float pivot;

        private SaturationFunction(float pivot) {
            this.pivot = pivot;
        }

        @Override
        public Similarity.SimScorer scorer(final float weight) {
            return new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return weight * (1.0f - pivot / (pivot + freq));
                }
            };
        }

        @Override
        public Explanation explain(String interval, float weight, float sloppyFreq) {
            float score = this.scorer(weight).score(sloppyFreq, 1L);
            return Explanation.match((Number)Float.valueOf(score), "Saturation function on interval frequency, computed as w * S / (S + k) from:", Explanation.match((Number)Float.valueOf(weight), "w, weight of this function", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.pivot), "k, pivot feature value that would give a score contribution equal to w/2", new Explanation[0]), Explanation.match((Number)Float.valueOf(sloppyFreq), "S, the sloppy frequency of the interval query " + interval, new Explanation[0]));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SaturationFunction that = (SaturationFunction)o;
            return Float.compare(that.pivot, this.pivot) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.pivot));
        }

        @Override
        public String toString() {
            return "SaturationFunction(pivot=" + this.pivot + ")";
        }
    }
}

