/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataSizeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.NodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.SignatureObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.ChunkingFactory;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.SequenceNumberGenerator;

public class IntermediateNodeObject
extends NodeObject {
    public IntermediateNodeObject() {
        super(StreamObjectTypeHeaderStart.IntermediateNodeObject);
        this.intermediateNodeObjectList = new ArrayList();
    }

    @Override
    public List<Byte> getContent() throws TikaException {
        ArrayList<Byte> content = new ArrayList<Byte>();
        for (LeafNodeObject intermediateNode : this.intermediateNodeObjectList) {
            content.addAll(intermediateNode.getContent());
        }
        return content;
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        if (lengthOfItems != 0) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "IntermediateNodeObject", "Stream Object over-parse error", null);
        }
        this.signature = StreamObject.getCurrent(byteArray, index, SignatureObject.class);
        this.dataSize = StreamObject.getCurrent(byteArray, index, DataSizeObject.class);
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        byteList.addAll(this.signature.serializeToByteList());
        byteList.addAll(this.dataSize.serializeToByteList());
        return 0;
    }

    public static class RootNodeObjectBuilder {
        public IntermediateNodeObject Build(byte[] fileContent) throws TikaException, IOException {
            IntermediateNodeObject rootNode = new IntermediateNodeObject();
            rootNode.signature = new SignatureObject();
            rootNode.dataSize = new DataSizeObject();
            rootNode.dataSize.dataSize = fileContent.length;
            rootNode.exGuid = new ExGuid(SequenceNumberGenerator.GetCurrentSerialNumber(), UUID.randomUUID());
            rootNode.intermediateNodeObjectList = ChunkingFactory.createChunkingInstance(fileContent).chunking();
            return rootNode;
        }
    }
}

